/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.client.ClientEventHandler;
import top.theillusivec4.curios.client.CuriosClientConfig;
import top.theillusivec4.curios.client.CuriosClientMod;
import top.theillusivec4.curios.client.IconHelper;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.client.gui.GuiEventHandler;
import top.theillusivec4.curios.client.render.CuriosLayer;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.capability.CurioInventoryCapability;
import top.theillusivec4.curios.common.capability.CurioItemCapability;
import top.theillusivec4.curios.common.event.CuriosEventHandler;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.slottype.SlotTypeManager;
import top.theillusivec4.curios.common.triggers.EquipCurioTrigger;
import top.theillusivec4.curios.server.SlotHelper;
import top.theillusivec4.curios.server.command.CurioArgumentType;
import top.theillusivec4.curios.server.command.CuriosCommand;
import top.theillusivec4.curios.server.command.CuriosSelectorOptions;

@Mod(value="curios")
public class Curios {
    public static final String MODID = "curios";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG = false;

    public Curios() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> CuriosClientMod::init);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::config);
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::process);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CuriosClientConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CuriosConfig.SERVER_SPEC);
    }

    private void setup(FMLCommonSetupEvent evt) {
        CuriosApi.setCuriosHelper(new CuriosHelper());
        CurioInventoryCapability.register();
        CurioItemCapability.register();
        MinecraftForge.EVENT_BUS.register((Object)new CuriosEventHandler());
        NetworkHandler.register();
        ArgumentTypes.func_218136_a((String)"curios:slot_type", CurioArgumentType.class, (IArgumentSerializer)new ArgumentSerializer(CurioArgumentType::slot));
        CriteriaTriggers.func_192118_a((ICriterionTrigger)EquipCurioTrigger.INSTANCE);
        CuriosSelectorOptions.register();
    }

    private void enqueue(InterModEnqueueEvent evt) {
    }

    private void process(InterModProcessEvent evt) {
        SlotTypeManager.buildImcSlotTypes(evt.getIMCStream("register_type"::equals), evt.getIMCStream("modify_type"::equals));
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        CuriosApi.setSlotHelper(new SlotHelper());
        SlotTypeManager.buildSlotTypes();
    }

    private void serverStopped(FMLServerStoppedEvent evt) {
        CuriosApi.setSlotHelper(null);
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        CuriosCommand.register((CommandDispatcher<CommandSource>)evt.getDispatcher());
    }

    private void reload(AddReloadListenerEvent evt) {
        evt.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            @Nonnull
            protected Void prepare(@Nonnull IResourceManager resourceManagerIn, @Nonnull IProfiler profilerIn) {
                return null;
            }

            protected void apply(@Nonnull Void objectIn, @Nonnull IResourceManager resourceManagerIn, @Nonnull IProfiler profilerIn) {
                CuriosEventHandler.dirtyTags = true;
            }
        });
    }

    private void config(ModConfig.Loading evt) {
        if (evt.getConfig().getModId().equals(MODID) && evt.getConfig().getType() == ModConfig.Type.SERVER) {
            ForgeConfigSpec spec = evt.getConfig().getSpec();
            CommentedConfig commentedConfig = evt.getConfig().getConfigData();
            if (spec == CuriosConfig.SERVER_SPEC) {
                CuriosConfig.transformCurios(commentedConfig);
                SlotTypeManager.buildConfigSlotTypes();
            }
        }
    }

    private static /* synthetic */ Object lambda$enqueue$2() {
        return Arrays.stream(SlotTypePreset.values()).map(preset -> preset.getMessageBuilder().build()).collect(Collectors.toList());
    }

    @Mod.EventBusSubscriber(modid="curios", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void stitchTextures(TextureStitchEvent.Pre evt) {
            CuriosClientMod.stitch(evt);
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            CuriosApi.setIconHelper(new IconHelper());
            MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
            ScreenManager.func_216911_a(CuriosRegistry.CONTAINER_TYPE, CuriosScreen::new);
            KeyRegistry.registerKeys();
        }

        @SubscribeEvent
        public static void postSetupClient(FMLLoadCompleteEvent evt) {
            Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
            for (PlayerRenderer render : skinMap.values()) {
                render.func_177094_a(new CuriosLayer(render));
            }
        }
    }
}

