/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.inventory.DynamicStackHandler;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

public class CurioStacksHandler
implements ICurioStacksHandler {
    private static final UUID LEGACY_UUID = UUID.fromString("0b0eabbd-4220-4e9f-bafb-34100da2bd7e");
    private final ICuriosItemHandler itemHandler;
    private final String identifier;
    private final Map<UUID, AttributeModifier> modifiers = new HashMap<UUID, AttributeModifier>();
    private final Set<AttributeModifier> persistentModifiers = new HashSet<AttributeModifier>();
    private final Set<AttributeModifier> cachedModifiers = new HashSet<AttributeModifier>();
    private final Multimap<AttributeModifier.Operation, AttributeModifier> modifiersByOperation = HashMultimap.create();
    private int baseSize;
    private IDynamicStackHandler stackHandler;
    private IDynamicStackHandler cosmeticStackHandler;
    private boolean visible;
    private boolean cosmetic;
    private NonNullList<Boolean> renderHandler;
    private boolean update;

    public CurioStacksHandler(ICuriosItemHandler itemHandler, String identifier) {
        this(itemHandler, identifier, 1, 0, true, false);
    }

    public CurioStacksHandler(ICuriosItemHandler itemHandler, String identifier, int size, int shift, boolean visible, boolean cosmetic) {
        this.baseSize = size;
        this.visible = visible;
        this.cosmetic = cosmetic;
        this.itemHandler = itemHandler;
        this.identifier = identifier;
        this.stackHandler = new DynamicStackHandler(size);
        this.cosmeticStackHandler = new DynamicStackHandler(size);
        this.renderHandler = NonNullList.func_191197_a((int)size, (Object)true);
    }

    @Override
    public IDynamicStackHandler getStacks() {
        this.update();
        return this.stackHandler;
    }

    @Override
    public IDynamicStackHandler getCosmeticStacks() {
        this.update();
        return this.cosmeticStackHandler;
    }

    @Override
    public NonNullList<Boolean> getRenders() {
        this.update();
        return this.renderHandler;
    }

    @Override
    public int getSlots() {
        this.update();
        return this.stackHandler.getSlots();
    }

    @Override
    public int getSizeShift() {
        return 0;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean hasCosmetic() {
        return this.cosmetic;
    }

    @Override
    public void grow(int amount) {
        if ((amount = Math.max(0, amount)) > 0) {
            this.addLegacyChange(amount);
        }
    }

    @Override
    public void shrink(int amount) {
        if ((amount = Math.max(0, amount)) > 0) {
            this.addLegacyChange(Math.min(this.getSlots(), amount) * -1);
        }
    }

    private void addLegacyChange(int shift) {
        AttributeModifier mod = this.getModifiers().get(LEGACY_UUID);
        int current = mod != null ? (int)mod.func_111164_d() : 0;
        AttributeModifier newModifier = new AttributeModifier(LEGACY_UUID, "legacy", (double)(current += shift), AttributeModifier.Operation.ADDITION);
        this.modifiers.put(newModifier.func_111167_a(), newModifier);
        Collection<AttributeModifier> modifiers = this.getModifiersByOperation(newModifier.func_220375_c());
        modifiers.remove(newModifier);
        modifiers.add(newModifier);
        this.persistentModifiers.remove(newModifier);
        this.persistentModifiers.add(newModifier);
        this.flagUpdate();
    }

    @Override
    public CompoundNBT serializeNBT() {
        ListNBT list;
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("SavedBaseSize", this.baseSize);
        compoundNBT.func_218657_a("Stacks", (INBT)this.stackHandler.serializeNBT());
        compoundNBT.func_218657_a("Cosmetics", (INBT)this.cosmeticStackHandler.serializeNBT());
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("Slot", i);
            tag.func_74757_a("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Renders", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.renderHandler.size());
        compoundNBT.func_218657_a("Renders", (INBT)nbt);
        compoundNBT.func_74757_a("HasCosmetic", this.cosmetic);
        compoundNBT.func_74757_a("Visible", this.visible);
        if (!this.persistentModifiers.isEmpty()) {
            list = new ListNBT();
            for (AttributeModifier attributeModifier : this.persistentModifiers) {
                list.add((Object)attributeModifier.func_233801_e_());
            }
            compoundNBT.func_218657_a("PersistentModifiers", (INBT)list);
        }
        if (!this.modifiers.isEmpty()) {
            list = new ListNBT();
            this.modifiers.forEach((uuid, modifier) -> {
                if (!this.persistentModifiers.contains(modifier)) {
                    list.add((Object)modifier.func_233801_e_());
                }
            });
            compoundNBT.func_218657_a("CachedModifiers", (INBT)list);
        }
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT list;
        int sizeShift;
        if (nbt.func_74764_b("SavedBaseSize")) {
            this.baseSize = nbt.func_74762_e("SavedBaseSize");
        }
        if (nbt.func_74764_b("Stacks")) {
            this.stackHandler.deserializeNBT(nbt.func_74775_l("Stacks"));
        }
        if (nbt.func_74764_b("Cosmetics")) {
            this.cosmeticStackHandler.deserializeNBT(nbt.func_74775_l("Cosmetics"));
        }
        if (nbt.func_74764_b("Renders")) {
            CompoundNBT tag = nbt.func_74775_l("Renders");
            this.renderHandler = NonNullList.func_191197_a((int)(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stackHandler.getSlots()), (Object)true);
            ListNBT tagList = tag.func_150295_c("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tags = tagList.func_150305_b(i);
                int slot = tags.func_74762_e("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.func_74767_n("Render"));
            }
        }
        if (nbt.func_74764_b("SizeShift") && (sizeShift = nbt.func_74762_e("SizeShift")) != 0) {
            this.addLegacyChange(sizeShift);
        }
        this.cosmetic = nbt.func_74764_b("HasCosmetic") ? nbt.func_74767_n("HasCosmetic") : this.cosmetic;
        boolean bl = this.visible = nbt.func_74764_b("Visible") ? nbt.func_74767_n("Visible") : this.visible;
        if (nbt.func_150297_b("PersistentModifiers", 9)) {
            list = nbt.func_150295_c("PersistentModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.func_233800_a_((CompoundNBT)list.func_150305_b(i));
                if (attributeModifier == null) continue;
                this.addPermanentModifier(attributeModifier);
            }
        }
        if (nbt.func_150297_b("CachedModifiers", 9)) {
            list = nbt.func_150295_c("CachedModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.func_233800_a_((CompoundNBT)list.func_150305_b(i));
                if (attributeModifier == null) continue;
                this.cachedModifiers.add(attributeModifier);
                this.addTransientModifier(attributeModifier);
            }
        }
        this.update();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public CompoundNBT getSyncTag() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("Stacks", (INBT)this.stackHandler.serializeNBT());
        compoundNBT.func_218657_a("Cosmetics", (INBT)this.cosmeticStackHandler.serializeNBT());
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("Slot", i);
            tag.func_74757_a("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Renders", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.renderHandler.size());
        compoundNBT.func_218657_a("Renders", (INBT)nbt);
        compoundNBT.func_74757_a("HasCosmetic", this.cosmetic);
        compoundNBT.func_74757_a("Visible", this.visible);
        compoundNBT.func_74768_a("BaseSize", this.baseSize);
        if (!this.modifiers.isEmpty()) {
            ListNBT list = new ListNBT();
            for (Map.Entry<UUID, AttributeModifier> modifier : this.modifiers.entrySet()) {
                list.add((Object)modifier.getValue().func_233801_e_());
            }
            compoundNBT.func_218657_a("Modifiers", (INBT)list);
        }
        return compoundNBT;
    }

    @Override
    public void applySyncTag(CompoundNBT tag) {
        int sizeShift;
        if (tag.func_74764_b("BaseSize")) {
            this.baseSize = tag.func_74762_e("BaseSize");
        }
        if (tag.func_74764_b("Stacks")) {
            this.stackHandler.deserializeNBT(tag.func_74775_l("Stacks"));
        }
        if (tag.func_74764_b("Cosmetics")) {
            this.cosmeticStackHandler.deserializeNBT(tag.func_74775_l("Cosmetics"));
        }
        if (tag.func_74764_b("Renders")) {
            CompoundNBT compoundNBT = tag.func_74775_l("Renders");
            this.renderHandler = NonNullList.func_191197_a((int)(compoundNBT.func_150297_b("Size", 3) ? compoundNBT.func_74762_e("Size") : this.stackHandler.getSlots()), (Object)true);
            ListNBT tagList = compoundNBT.func_150295_c("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tags = tagList.func_150305_b(i);
                int slot = tags.func_74762_e("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.func_74767_n("Render"));
            }
        }
        if (tag.func_74764_b("SizeShift") && (sizeShift = tag.func_74762_e("SizeShift")) != 0) {
            this.addLegacyChange(sizeShift);
        }
        this.cosmetic = tag.func_74764_b("HasCosmetic") ? tag.func_74767_n("HasCosmetic") : this.cosmetic;
        this.visible = tag.func_74764_b("Visible") ? tag.func_74767_n("Visible") : this.visible;
        this.modifiers.clear();
        this.persistentModifiers.clear();
        this.modifiersByOperation.clear();
        if (tag.func_150297_b("Modifiers", 9)) {
            ListNBT list = tag.func_150295_c("Modifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.func_233800_a_((CompoundNBT)list.func_150305_b(i));
                if (attributeModifier == null) continue;
                this.addTransientModifier(attributeModifier);
            }
        }
        this.flagUpdate();
        this.update();
    }

    @Override
    public void copyModifiers(ICurioStacksHandler other) {
        this.modifiers.clear();
        this.cachedModifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.getModifiers().forEach((uuid, modifier) -> this.addTransientModifier((AttributeModifier)modifier));
        this.cachedModifiers.addAll(other.getCachedModifiers());
        for (AttributeModifier persistentModifier : other.getPermanentModifiers()) {
            this.addPermanentModifier(persistentModifier);
        }
        this.update();
    }

    @Override
    public Map<UUID, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Set<AttributeModifier> getPermanentModifiers() {
        return this.persistentModifiers;
    }

    @Override
    public Set<AttributeModifier> getCachedModifiers() {
        return this.cachedModifiers;
    }

    @Override
    public Collection<AttributeModifier> getModifiersByOperation(AttributeModifier.Operation operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    @Override
    public void addTransientModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.func_111167_a(), modifier);
        this.getModifiersByOperation(modifier.func_220375_c()).add(modifier);
        this.flagUpdate();
    }

    @Override
    public void addPermanentModifier(AttributeModifier modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    @Override
    public void removeModifier(UUID uuid) {
        AttributeModifier modifier = this.modifiers.remove(uuid);
        if (modifier != null) {
            this.persistentModifiers.remove(modifier);
            this.getModifiersByOperation(modifier.func_220375_c()).remove(modifier);
            this.flagUpdate();
        }
    }

    private void flagUpdate() {
        this.update = true;
        if (this.itemHandler != null) {
            this.itemHandler.getUpdatingInventories().remove(this);
            this.itemHandler.getUpdatingInventories().add(this);
        }
    }

    @Override
    public void clearModifiers() {
        HashSet<UUID> ids = new HashSet<UUID>(this.modifiers.keySet());
        for (UUID id : ids) {
            this.removeModifier(id);
        }
    }

    @Override
    public void clearCachedModifiers() {
        for (AttributeModifier cachedModifier : this.cachedModifiers) {
            this.removeModifier(cachedModifier.func_111167_a());
        }
        this.cachedModifiers.clear();
        this.flagUpdate();
    }

    @Override
    public void update() {
        if (this.update) {
            this.update = false;
            double baseSize = this.baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADDITION)) {
                baseSize += mod.func_111164_d();
            }
            double size = baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.MULTIPLY_BASE)) {
                size += (double)this.baseSize * mod.func_111164_d();
            }
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                size *= mod.func_111164_d();
            }
            if (size != (double)this.getSlots()) {
                this.resize((int)size);
                if (this.itemHandler != null && this.itemHandler.getWearer() instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)this.itemHandler.getWearer();
                    if (player.field_71070_bA instanceof CuriosContainer) {
                        ((CuriosContainer)player.field_71070_bA).resetSlots();
                    }
                }
            }
        }
    }

    private void resize(int newSize) {
        int currentSize = this.getSlots();
        if (currentSize != newSize) {
            int change = newSize - currentSize;
            if (currentSize > newSize) {
                this.loseStacks(this.stackHandler, this.identifier, change *= -1);
                this.stackHandler.shrink(change);
                this.cosmeticStackHandler.shrink(change);
                NonNullList newList = NonNullList.func_191197_a((int)newSize, (Object)true);
                for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.renderHandler.get(i)));
                }
                this.renderHandler = newList;
            } else {
                this.stackHandler.grow(change);
                this.cosmeticStackHandler.grow(change);
                NonNullList newList = NonNullList.func_191197_a((int)newSize, (Object)true);
                for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.renderHandler.get(i)));
                }
                this.renderHandler = newList;
            }
        }
    }

    private void loseStacks(IDynamicStackHandler stackHandler, String identifier, int amount) {
        if (this.itemHandler == null) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = Math.max(0, stackHandler.getSlots() - amount); i >= 0 && i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            drops.add(stackHandler.getStackInSlot(i));
            LivingEntity entity = this.itemHandler.getWearer();
            SlotContext slotContext = new SlotContext(identifier, entity, i);
            if (!stack.func_190926_b()) {
                UUID uuid = UUID.nameUUIDFromBytes((identifier + i).getBytes());
                Multimap<Attribute, AttributeModifier> map = CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack);
                HashMultimap slots = HashMultimap.create();
                HashSet<CuriosHelper.SlotAttributeWrapper> toRemove = new HashSet<CuriosHelper.SlotAttributeWrapper>();
                for (Attribute attribute : map.keySet()) {
                    if (!(attribute instanceof CuriosHelper.SlotAttributeWrapper)) continue;
                    CuriosHelper.SlotAttributeWrapper wrapper = (CuriosHelper.SlotAttributeWrapper)attribute;
                    slots.putAll((Object)wrapper.identifier, (Iterable)map.get((Object)attribute));
                    toRemove.add(wrapper);
                }
                for (Attribute attribute : toRemove) {
                    map.removeAll((Object)attribute);
                }
                this.itemHandler.getWearer().func_233645_dx_().func_233785_a_(map);
                this.itemHandler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
                CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, ItemStack.field_190927_a));
            }
            stackHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        drops.forEach(this.itemHandler::loseInvalidStack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurioStacksHandler that = (CurioStacksHandler)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

