/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.Util;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.ITag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerMixin {
    @Redirect(method={"attack", "checkMovementStatistics", "tryToStartFallFlying"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isInWater()Z"))
    private boolean setInWater(PlayerEntity player) {
        return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> ((PlayerEntity)player).func_70090_H());
    }

    @Redirect(method={"checkMovementStatistics"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isEyeInFluid(Lnet/minecraft/tags/Tag;)Z"))
    private boolean setEyeInFluid(PlayerEntity player, ITag<Fluid> tag) {
        return Util.processEventResult(EventDispatcher.onPlayerSwim(player), () -> player.func_208600_a(tag));
    }

    @Redirect(method={"travel"}, allow=1, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;isEmpty()Z"))
    private boolean cancelSurfaceCheck(FluidState fluidState) {
        PlayerEntity self = (PlayerEntity)this;
        return Util.processEventResult(EventDispatcher.onPlayerSwim(self), false, true, () -> ((FluidState)fluidState).func_206888_e());
    }
}

