/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.DeathManager;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.UUIDArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RestoreCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"restore").requires(commandSource -> commandSource.func_197034_c(2));
        Command add = commandSource -> {
            UUID deathID = UUIDArgument.func_239195_a_((CommandContext)commandSource, (String)"death_id");
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)commandSource, (String)"target");
            Death death = DeathManager.getDeath(player.func_71121_q(), deathID);
            if (death == null) {
                ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.gravestone.death_id_not_found", new Object[]{deathID.toString()}));
                return 0;
            }
            for (ItemStack stack : death.getAllItems()) {
                if (player.field_71071_by.func_70441_a(stack)) continue;
                player.func_71019_a(stack, false);
            }
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.gravestone.restore.success", new Object[]{player.func_145748_c_()}), true);
            return 1;
        };
        Command replace = commandSource -> {
            UUID deathID = UUIDArgument.func_239195_a_((CommandContext)commandSource, (String)"death_id");
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)commandSource, (String)"target");
            Death death = DeathManager.getDeath(player.func_71121_q(), deathID);
            if (death == null) {
                ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.gravestone.death_id_not_found", new Object[]{deathID.toString()}));
                return 0;
            }
            player.field_71071_by.func_174888_l();
            NonNullList<ItemStack> itemStacks = Main.GRAVESTONE.fillPlayerInventory((PlayerEntity)player, death);
            for (ItemStack stack : itemStacks) {
                player.func_71019_a(stack, false);
            }
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.gravestone.restore.success", new Object[]{player.func_145748_c_()}), true);
            return 1;
        };
        literalBuilder.then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"death_id", (ArgumentType)UUIDArgument.func_239194_a_()).then(Commands.func_197057_a((String)"replace").executes(replace))).then(Commands.func_197057_a((String)"add").executes(add))));
        dispatcher.register(literalBuilder);
    }
}

