/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.client.PlayerSkins;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class GravestoneRenderer
extends TileEntityRenderer<GraveStoneTileEntity> {
    public GravestoneRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(GraveStoneTileEntity grave, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ITextComponent name = grave.getGraveName();
        if (name == null) {
            return;
        }
        Direction direction = (Direction)grave.func_195044_w().func_177229_b((Property)GraveStoneBlock.FACING);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + direction.func_185119_l()));
        FontRenderer font = this.field_228858_b_.func_147548_a();
        int textWidth = font.func_78256_a(name.getString());
        double textScale = Math.min(0.8 / (double)textWidth, 0.02);
        matrixStack.func_227861_a_(0.0, 0.3, 0.37);
        matrixStack.func_227862_a_((float)textScale, (float)textScale, (float)textScale);
        float left = -textWidth / 2;
        font.func_228079_a_(name.getString(), left, 0.0f, Main.CLIENT_CONFIG.graveTextColor, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        matrixStack.func_227865_b_();
        BlockState state = grave.func_145831_w().func_180495_p(grave.func_174877_v().func_177977_b());
        boolean render = state.func_215686_e((IBlockReader)grave.func_145831_w(), grave.func_174877_v());
        UUID playerUUID = grave.getDeath().getPlayerUUID();
        if (playerUUID != null && !playerUUID.equals(GraveUtils.EMPTY_UUID) && ((Boolean)Main.CLIENT_CONFIG.renderSkull.get()).booleanValue() && render) {
            this.renderSkull(playerUUID, name.getString(), direction, matrixStack, buffer, combinedLight);
        }
    }

    public void renderSkull(UUID uuid, String name, Direction rotation, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight) {
        HumanoidHeadModel model = new HumanoidHeadModel();
        ResourceLocation resourcelocation = PlayerSkins.getSkin(uuid, name);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotation.func_185119_l()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-26.0f));
        matrixStack.func_227861_a_(0.0, -0.14, 0.18);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-61.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        model.func_225598_a_(matrixStack, buffer.getBuffer(model.func_228282_a_(resourcelocation)), combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }
}

