/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render;

import com.github.alexthe666.iceandfire.client.render.tile.RenderDreadPortal;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class IafRenderType
extends RenderType {
    private static final ResourceLocation STONE_TEXTURE = new ResourceLocation("textures/block/stone.png");
    protected static final RenderState.TransparencyState GHOST_TRANSPARANCY = new RenderState.TransparencyState("translucent_ghost_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

    public IafRenderType(String nameIn, VertexFormat formatIn, int drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
    }

    public static RenderType getGhost(ResourceLocation locationIn) {
        RenderState.TextureState lvt_1_1_ = new RenderState.TextureState(locationIn, false, false);
        return IafRenderType.func_228633_a_((String)"ghost_iaf", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)262144, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(lvt_1_1_).func_228727_a_(field_228495_E_).func_228715_a_(field_228494_D_).func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_).func_228719_a_(field_228529_u_).func_228722_a_(field_228530_v_).func_228726_a_(GHOST_TRANSPARANCY).func_228717_a_(field_228502_L_).func_228714_a_(RenderState.field_228534_z_).func_228728_a_(true));
    }

    public static RenderType getGhostDaytime(ResourceLocation locationIn) {
        RenderState.TextureState lvt_1_1_ = new RenderState.TextureState(locationIn, false, false);
        return IafRenderType.func_228633_a_((String)"ghost_iaf_day", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)262144, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(lvt_1_1_).func_228727_a_(field_228495_E_).func_228715_a_(field_228494_D_).func_228713_a_(field_228517_i_).func_228716_a_(field_228532_x_).func_228719_a_(field_228529_u_).func_228722_a_(field_228530_v_).func_228726_a_(field_228515_g_).func_228717_a_(field_228502_L_).func_228714_a_(RenderState.field_228534_z_).func_228728_a_(true));
    }

    public static RenderType getDreadlandsRenderType(int iterationIn) {
        RenderState.TextureState renderstate$texturestate;
        RenderState.TransparencyState renderstate$transparencystate;
        if (iterationIn <= 1) {
            renderstate$transparencystate = field_228515_g_;
            renderstate$texturestate = new RenderState.TextureState(RenderDreadPortal.END_SKY_TEXTURE, false, false);
        } else {
            renderstate$transparencystate = field_228511_c_;
            renderstate$texturestate = new RenderState.TextureState(RenderDreadPortal.END_PORTAL_TEXTURE, false, false);
        }
        return IafRenderType.func_228633_a_((String)"dreadlands_portal", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(renderstate$transparencystate).func_228724_a_(renderstate$texturestate).func_228725_a_((RenderState.TexturingState)new DreadlandsPortalTexturingState(iterationIn)).func_228728_a_(false));
    }

    public static RenderType getStoneMobRenderType(float xSize, float ySize) {
        RenderState.TextureState textureState = new RenderState.TextureState(STONE_TEXTURE, false, false);
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(textureState).func_228725_a_((RenderState.TexturingState)new StoneTexturingState(STONE_TEXTURE, xSize, ySize)).func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
        return IafRenderType.func_228632_a_((String)"stone_entity_type", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (RenderType.State)rendertype$state);
    }

    public static RenderType getIce(ResourceLocation locationIn) {
        RenderState.TextureState lvt_1_1_ = new RenderState.TextureState(locationIn, false, false);
        return IafRenderType.func_228633_a_((String)"ice_texture", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(lvt_1_1_).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228534_z_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true));
    }

    public static RenderType getStoneCrackRenderType(ResourceLocation crackTex, float xSize, float ySize) {
        RenderState.TextureState renderstate$texturestate = new RenderState.TextureState(crackTex, false, false);
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(renderstate$texturestate).func_228725_a_((RenderState.TexturingState)new StoneTexturingState(crackTex, xSize, ySize)).func_228716_a_(field_228532_x_).func_228713_a_(RenderState.field_228518_j_).func_228726_a_(field_228515_g_).func_228715_a_(field_228493_C_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(false);
        return IafRenderType.func_228632_a_((String)"stone_entity_type_crack", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (RenderType.State)rendertype$state);
    }

    public static final class DreadlandsPortalTexturingState
    extends RenderState.TexturingState {
        private final int iteration;

        public DreadlandsPortalTexturingState(int iteration) {
            super("portal_texturing", () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.0f);
                RenderSystem.scalef((float)0.5f, (float)-0.5f, (float)1.0f);
                float yDist = iteration <= 1 ? 1.0f : (float)(Util.func_211177_b() % 80000L) / 80000.0f;
                RenderSystem.translatef((float)(17.0f / (float)iteration), (float)((2.0f + (float)iteration / 0.5f) * yDist), (float)0.0f);
                RenderSystem.mulTextureByProjModelView();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.setupEndPortalTexGen();
            }, () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.popMatrix();
                RenderSystem.matrixMode((int)5888);
                RenderSystem.clearTexGen();
            });
            this.iteration = iteration;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && ((Object)((Object)this)).getClass() == p_equals_1_.getClass()) {
                DreadlandsPortalTexturingState renderstate$portaltexturingstate = (DreadlandsPortalTexturingState)((Object)p_equals_1_);
                return this.iteration == renderstate$portaltexturingstate.iteration;
            }
            return false;
        }

        public int hashCode() {
            return Integer.hashCode(this.iteration);
        }
    }

    public static final class StoneTexturingState
    extends RenderState.TexturingState {
        private final float xSize;
        private final float ySize;

        public StoneTexturingState(ResourceLocation tex, float xSize, float ySize) {
            super("stone_entity_type", () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.loadIdentity();
                RenderSystem.scalef((float)xSize, (float)ySize, (float)1.0f);
                RenderSystem.matrixMode((int)5888);
            }, () -> {
                RenderSystem.matrixMode((int)5890);
                RenderSystem.loadIdentity();
                RenderSystem.matrixMode((int)5888);
            });
            this.xSize = xSize;
            this.ySize = ySize;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ != null && ((Object)((Object)this)).getClass() == p_equals_1_.getClass()) {
                StoneTexturingState renderstate$portaltexturingstate = (StoneTexturingState)((Object)p_equals_1_);
                return this.ySize == renderstate$portaltexturingstate.ySize && this.xSize == renderstate$portaltexturingstate.xSize;
            }
            return false;
        }

        public int hashCode() {
            return Float.hashCode(this.xSize) + Float.hashCode(this.ySize);
        }
    }
}

