/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.entity.EntityDragonSkull;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class RenderDragonSkull
extends EntityRenderer<EntityDragonSkull> {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public float[][] growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    private final TabulaModel fireDragonModel;
    private final TabulaModel lightningDragonModel;
    private final TabulaModel iceDragonModel;

    public RenderDragonSkull(EntityRendererManager renderManager, SegmentedModel fireDragonModel, SegmentedModel iceDragonModel, SegmentedModel lightningDragonModel) {
        super(renderManager);
        this.fireDragonModel = (TabulaModel)fireDragonModel;
        this.iceDragonModel = (TabulaModel)iceDragonModel;
        this.lightningDragonModel = (TabulaModel)lightningDragonModel;
    }

    private static void setRotationAngles(ModelRenderer cube, float rotX, float rotY, float rotZ) {
        cube.field_78795_f = rotX;
        cube.field_78796_g = rotY;
        cube.field_78808_h = rotZ;
    }

    public void render(EntityDragonSkull entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        TabulaModel model = entity.getDragonType() == 2 ? this.lightningDragonModel : (entity.getDragonType() == 1 ? this.iceDragonModel : this.fireDragonModel);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getEntityTexture(entity)));
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -180.0f, true));
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229180_c_, 180.0f - entity.getYaw(), true));
        float f = 0.0625f;
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
        float size = this.getRenderSize(entity) / 3.0f;
        matrixStackIn.func_227862_a_(size, size, size);
        matrixStackIn.func_227861_a_(0.0, entity.isOnWall() ? (double)-0.24f : (double)-0.12f, entity.isOnWall() ? (double)0.4f : 0.5);
        model.resetToDefaultPose();
        RenderDragonSkull.setRotationAngles((ModelRenderer)model.getCube("Head"), entity.isOnWall() ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
        model.getCube("Head").func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(EntityDragonSkull entity) {
        if (entity.getDragonType() == 2) {
            return EnumDragonTextures.getLightningDragonSkullTextures(entity);
        }
        if (entity.getDragonType() == 1) {
            return EnumDragonTextures.getIceDragonSkullTextures(entity);
        }
        return EnumDragonTextures.getFireDragonSkullTextures(entity);
    }

    public float getRenderSize(EntityDragonSkull skull) {
        float step = (this.growth_stages[skull.getDragonStage() - 1][1] - this.growth_stages[skull.getDragonStage() - 1][0]) / 25.0f;
        if (skull.getDragonAge() > 125) {
            return this.growth_stages[skull.getDragonStage() - 1][0] + step * 25.0f;
        }
        return this.growth_stages[skull.getDragonStage() - 1][0] + step * (float)this.getAgeFactor(skull);
    }

    private int getAgeFactor(EntityDragonSkull skull) {
        return skull.getDragonStage() > 1 ? skull.getDragonAge() - 25 * (skull.getDragonStage() - 1) : skull.getDragonAge();
    }
}

