/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.client.model.util.LegSolverQuadruped;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonFlightManager;
import com.github.alexthe666.iceandfire.entity.IafDragonLogic;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIEscort;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIMate;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIReturnToRoost;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIRide;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetNonTamed;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.github.alexthe666.iceandfire.entity.props.ChainProperties;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeInput;
import com.github.alexthe666.iceandfire.entity.util.ChainBuffer;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.ICustomMoveController;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.entity.util.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.util.IDropArmor;
import com.github.alexthe666.iceandfire.entity.util.IFlyingMount;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IMultipartEntity;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.util.ReversedBuffer;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.inventory.ContainerDragon;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemDragonArmor;
import com.github.alexthe666.iceandfire.item.ItemSummoningCrystal;
import com.github.alexthe666.iceandfire.message.MessageDragonSetBurnBlock;
import com.github.alexthe666.iceandfire.message.MessageStartRidingMob;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.IPassabilityNavigator;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathingStuckHandler;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.github.alexthe666.iceandfire.world.DragonPosWorldData;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public abstract class EntityDragonBase
extends TameableEntity
implements IPassabilityNavigator,
ISyncMount,
IFlyingMount,
IMultipartEntity,
IAnimatedEntity,
IDragonFlute,
IDeadMob,
IVillagerFear,
IAnimalFear,
IDropArmor,
IHasCustomizableAttributes,
ICustomSizeNavigator,
ICustomMoveController,
IInventoryChangedListener {
    public static final int FLIGHT_CHANCE_PER_TICK = 1500;
    protected static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> AGE_TICKS = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FIREBREATHING = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOVERING = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MODEL_DEAD = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DEATH_STAGE = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> TACKLE = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> AGINGDISABLED = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DRAGON_PITCH = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> CRYSTAL_BOUND = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> CUSTOM_POSE = EntityDataManager.func_187226_a(EntityDragonBase.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static Animation ANIMATION_FIRECHARGE;
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public static Animation ANIMATION_WINGBLAST;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_EPIC_ROAR;
    public static Animation ANIMATION_TAILWHACK;
    public DragonType dragonType;
    public double minimumDamage;
    public double maximumDamage;
    public double minimumHealth;
    public double maximumHealth;
    public double minimumSpeed;
    public double maximumSpeed;
    public double minimumArmor;
    public double maximumArmor;
    public float sitProgress;
    public float sleepProgress;
    public float hoverProgress;
    public float flyProgress;
    public float fireBreathProgress;
    public float diveProgress;
    public float prevDiveProgress;
    public float prevFireBreathProgress;
    public int fireStopTicks;
    public int flyTicks;
    public float modelDeadProgress;
    public float prevModelDeadProgress;
    public float ridingProgress;
    public float tackleProgress;
    public boolean isSwimming;
    public float prevSwimProgress;
    public float swimProgress;
    public int ticksSwiming;
    public int swimCycle;
    public float[] prevAnimationProgresses = new float[10];
    public boolean isDaytime;
    public int flightCycle;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    public IFChainBuffer roll_buffer;
    public IFChainBuffer pitch_buffer;
    public IFChainBuffer pitch_buffer_body;
    public ReversedBuffer turn_buffer;
    public ChainBuffer tail_buffer;
    public int spacebarTicks;
    public float[][] growth_stages;
    public LegSolverQuadruped legSolver;
    public int walkCycle;
    public BlockPos burningTarget;
    public int burnProgress;
    public double burnParticleX;
    public double burnParticleY;
    public double burnParticleZ;
    public float prevDragonPitch;
    public IafDragonAttacks.Air airAttack;
    public IafDragonAttacks.Ground groundAttack;
    public boolean usingGroundAttack = true;
    public IafDragonLogic logic;
    public int hoverTicks;
    public int tacklingTicks;
    public int ticksStill;
    public int navigatorType;
    public Inventory dragonInventory;
    public String prevArmorResLoc = "0|0|0|0";
    public String armorResLoc = "0|0|0|0";
    public IafDragonFlightManager flightManager;
    public boolean lookingForRoostAIFlag = false;
    protected int flyHovering;
    protected boolean hasHadHornUse = false;
    protected int fireTicks;
    protected int blockBreakCounter;
    private int prevFlightCycle;
    private boolean isModelDead;
    private int animationTick;
    private Animation currentAnimation;
    private float lastScale;
    private EntityDragonPart headPart;
    private EntityDragonPart neckPart;
    private EntityDragonPart rightWingUpperPart;
    private EntityDragonPart rightWingLowerPart;
    private EntityDragonPart leftWingUpperPart;
    private EntityDragonPart leftWingLowerPart;
    private EntityDragonPart tail1Part;
    private EntityDragonPart tail2Part;
    private EntityDragonPart tail3Part;
    private EntityDragonPart tail4Part;
    private boolean isOverAir;

    public EntityDragonBase(EntityType t, World world, DragonType type, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(t, world);
        IHasCustomizableAttributes.applyAttributesForEntity(t, this);
        this.dragonType = type;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.minimumArmor = 1.0;
        this.maximumArmor = 20.0;
        ANIMATION_EAT = Animation.create((int)20);
        this.initInventory();
        if (world.field_72995_K) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.pitch_buffer_body = new IFChainBuffer();
            this.turn_buffer = new ReversedBuffer();
            this.tail_buffer = new ChainBuffer();
        }
        this.legSolver = new LegSolverQuadruped(0.3f, 0.35f, 0.2f, 1.45f, 1.0f);
        this.flightManager = new IafDragonFlightManager(this);
        this.logic = this.createDragonLogic();
        this.field_70158_ak = true;
        this.switchNavigator(0);
        this.randomizeAttacks();
        this.resetParts(1.0f);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, (double)Math.min(2048, IafConfig.dragonTargetSearchLength)).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    @Override
    public AttributeModifierMap.MutableAttribute getAttributes() {
        return EntityDragonBase.bakeAttributes();
    }

    public BlockPos func_213384_dI() {
        return this.homePos == null ? super.func_213384_dI() : this.homePos.getPosition();
    }

    public float func_213391_dJ() {
        return IafConfig.dragonWanderFromHomeDistance;
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean func_213394_dL() {
        return this.hasHomePosition && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.field_70170_p)) || super.func_213394_dL();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new DragonAIRide<EntityDragonBase>(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new DragonAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new DragonAIReturnToRoost(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new DragonAIEscort(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DragonAIAttackMelee(this, 1.5, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new AquaticAITempt((MobEntity)this, 1.0, IafItemRegistry.FIRE_STEW, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new DragonAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new DragonAIWatchClosest((CreatureEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new DragonAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new DragonAITargetNonTamed<LivingEntity>(this, LivingEntity.class, false, (Predicate<LivingEntity>)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_()) && DragonUtils.canHostilesTarget((Entity)entity) && entity.func_200600_R() != EntityDragonBase.this.func_200600_R() && EntityDragonBase.this.shouldTarget((Entity)entity) && DragonUtils.isAlive(entity);
            }
        }));
        this.field_70715_bh.func_75776_a(5, new DragonAITarget<LivingEntity>(this, LivingEntity.class, true, (Predicate<LivingEntity>)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity) && entity.func_200600_R() != EntityDragonBase.this.func_200600_R() && EntityDragonBase.this.shouldTarget((Entity)entity) && DragonUtils.isAlive(entity);
            }
        }));
        this.field_70715_bh.func_75776_a(6, new DragonAITargetItems(this, false));
    }

    protected abstract boolean shouldTarget(Entity var1);

    public void resetParts(float scale) {
        this.removeParts();
        this.headPart = new EntityDragonPart(this, 1.55f * scale, 0.0f, 0.6f * scale, 0.5f * scale, 0.35f * scale, 1.5f);
        this.headPart.func_82149_j((Entity)this);
        this.headPart.setParent((Entity)this);
        this.neckPart = new EntityDragonPart(this, 0.85f * scale, 0.0f, 0.7f * scale, 0.5f * scale, 0.2f * scale, 1.0f);
        this.neckPart.func_82149_j((Entity)this);
        this.neckPart.setParent((Entity)this);
        this.rightWingUpperPart = new EntityDragonPart(this, 1.0f * scale, 90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.rightWingUpperPart.func_82149_j((Entity)this);
        this.rightWingUpperPart.setParent((Entity)this);
        this.rightWingLowerPart = new EntityDragonPart(this, 1.4f * scale, 100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.rightWingLowerPart.func_82149_j((Entity)this);
        this.rightWingLowerPart.setParent((Entity)this);
        this.leftWingUpperPart = new EntityDragonPart(this, 1.0f * scale, -90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.leftWingUpperPart.func_82149_j((Entity)this);
        this.leftWingUpperPart.setParent((Entity)this);
        this.leftWingLowerPart = new EntityDragonPart(this, 1.4f * scale, -100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.leftWingLowerPart.func_82149_j((Entity)this);
        this.leftWingLowerPart.setParent((Entity)this);
        this.tail1Part = new EntityDragonPart(this, -0.75f * scale, 0.0f, 0.6f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail1Part.func_82149_j((Entity)this);
        this.tail1Part.setParent((Entity)this);
        this.tail2Part = new EntityDragonPart(this, -1.15f * scale, 0.0f, 0.45f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail2Part.func_82149_j((Entity)this);
        this.tail2Part.setParent((Entity)this);
        this.tail3Part = new EntityDragonPart(this, -1.5f * scale, 0.0f, 0.35f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail3Part.func_82149_j((Entity)this);
        this.tail3Part.setParent((Entity)this);
        this.tail4Part = new EntityDragonPart(this, -1.95f * scale, 0.0f, 0.25f * scale, 0.45f * scale, 0.3f * scale, 1.5f);
        this.tail4Part.func_82149_j((Entity)this);
        this.tail4Part.setParent((Entity)this);
    }

    public void removeParts() {
        if (this.headPart != null) {
            this.headPart.func_70106_y();
            this.headPart = null;
        }
        if (this.neckPart != null) {
            this.neckPart.func_70106_y();
            this.neckPart = null;
        }
        if (this.rightWingUpperPart != null) {
            this.rightWingUpperPart.func_70106_y();
            this.rightWingUpperPart = null;
        }
        if (this.rightWingLowerPart != null) {
            this.rightWingLowerPart.func_70106_y();
            this.rightWingLowerPart = null;
        }
        if (this.leftWingUpperPart != null) {
            this.leftWingUpperPart.func_70106_y();
            this.leftWingUpperPart = null;
        }
        if (this.leftWingLowerPart != null) {
            this.leftWingLowerPart.func_70106_y();
            this.leftWingLowerPart = null;
        }
        if (this.tail1Part != null) {
            this.tail1Part.func_70106_y();
            this.tail1Part = null;
        }
        if (this.tail2Part != null) {
            this.tail2Part.func_70106_y();
            this.tail2Part = null;
        }
        if (this.tail3Part != null) {
            this.tail3Part.func_70106_y();
            this.tail3Part = null;
        }
        if (this.tail4Part != null) {
            this.tail4Part.func_70106_y();
            this.tail4Part = null;
        }
    }

    public void updateParts() {
        if (this.headPart != null) {
            if (!this.headPart.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.headPart);
            }
            this.headPart.setParent((Entity)this);
        }
        if (this.neckPart != null) {
            if (!this.neckPart.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.neckPart);
            }
            this.neckPart.setParent((Entity)this);
        }
        if (this.rightWingUpperPart != null) {
            if (!this.rightWingUpperPart.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.rightWingUpperPart);
            }
            this.rightWingUpperPart.setParent((Entity)this);
        }
        if (this.rightWingLowerPart != null) {
            if (!this.rightWingLowerPart.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.rightWingLowerPart);
            }
            this.rightWingLowerPart.setParent((Entity)this);
        }
        if (this.leftWingUpperPart != null) {
            if (!this.leftWingUpperPart.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.leftWingUpperPart);
            }
            this.leftWingUpperPart.setParent((Entity)this);
        }
        if (this.leftWingLowerPart != null) {
            if (!this.leftWingLowerPart.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.leftWingLowerPart);
            }
            this.leftWingLowerPart.setParent((Entity)this);
        }
        if (this.tail1Part != null) {
            if (!this.tail1Part.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.tail1Part);
            }
            this.tail1Part.setParent((Entity)this);
        }
        if (this.tail2Part != null) {
            if (!this.tail2Part.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.tail2Part);
            }
            this.tail2Part.setParent((Entity)this);
        }
        if (this.tail3Part != null) {
            if (!this.tail3Part.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.tail3Part);
            }
            this.tail3Part.setParent((Entity)this);
        }
        if (this.tail4Part != null) {
            if (!this.tail4Part.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.tail4Part);
            }
            this.tail4Part.setParent((Entity)this);
        }
    }

    protected void updateBurnTarget() {
        if (!(this.burningTarget == null || this.func_70608_bn() || this.isModelDead() || this.func_70631_g_())) {
            float maxDist = 115 * this.getDragonStage();
            boolean flag = false;
            if (this.field_70170_p.func_175625_s(this.burningTarget) instanceof TileEntityDragonforgeInput && ((TileEntityDragonforgeInput)this.field_70170_p.func_175625_s(this.burningTarget)).isAssembled() && this.func_70092_e((double)this.burningTarget.func_177958_n() + 0.5, (double)this.burningTarget.func_177956_o() + 0.5, (double)this.burningTarget.func_177952_p() + 0.5) < (double)maxDist && this.canPositionBeSeen((double)this.burningTarget.func_177958_n() + 0.5, (double)this.burningTarget.func_177956_o() + 0.5, (double)this.burningTarget.func_177952_p() + 0.5)) {
                this.func_70671_ap().func_75650_a((double)this.burningTarget.func_177958_n() + 0.5, (double)this.burningTarget.func_177956_o() + 0.5, (double)this.burningTarget.func_177952_p() + 0.5, 180.0f, 180.0f);
                this.breathFireAtPos(this.burningTarget);
                this.setBreathingFire(true);
            } else {
                if (!this.field_70170_p.field_72995_K) {
                    IceAndFire.sendMSGToAll(new MessageDragonSetBurnBlock(this.func_145782_y(), true, this.burningTarget));
                }
                this.burningTarget = null;
            }
        }
    }

    protected abstract void breathFireAtPos(BlockPos var1);

    protected PathingStuckHandler createStuckHandler() {
        return PathingStuckHandler.createStuckHandler();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.WALKING);
    }

    protected PathNavigator createNavigator(World worldIn, AdvancedPathNavigate.MovementType type) {
        return this.createNavigator(worldIn, type, this.createStuckHandler());
    }

    protected PathNavigator createNavigator(World worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler) {
        return this.createNavigator(worldIn, type, stuckHandler, 4.0f, 4.0f);
    }

    protected PathNavigator createNavigator(World worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler, float width, float height) {
        AdvancedPathNavigate newNavigator = new AdvancedPathNavigate((MobEntity)this, this.field_70170_p, type, width, height);
        this.field_70699_by = newNavigator;
        newNavigator.func_212239_d(true);
        newNavigator.func_189566_q().func_186321_b(true);
        return newNavigator;
    }

    protected void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.field_70765_h = new IafDragonFlightManager.GroundMoveHelper((MobEntity)this);
            this.field_70699_by = this.createNavigator(this.field_70170_p, AdvancedPathNavigate.MovementType.WALKING, this.createStuckHandler().withTeleportSteps(5));
            this.navigatorType = 0;
            this.setFlying(false);
            this.setHovering(false);
        } else if (navigatorType == 1) {
            this.field_70765_h = new IafDragonFlightManager.FlightMoveHelper(this);
            this.field_70699_by = this.createNavigator(this.field_70170_p, AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 1;
        } else {
            this.field_70765_h = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityDragonBase>(this);
            this.field_70699_by = this.createNavigator(this.field_70170_p, AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 2;
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.breakBlock();
    }

    public boolean canDestroyBlock(BlockPos pos, BlockState state) {
        return state.func_177230_c().canEntityDestroy(state, (IBlockReader)this.field_70170_p, pos, (Entity)this);
    }

    @Override
    public boolean isMobDead() {
        return this.isModelDead();
    }

    public int func_184649_cE() {
        return 10 * this.getDragonStage() / 5;
    }

    public void openGUI(PlayerEntity playerEntity) {
        IceAndFire.PROXY.setReferencedMob((Entity)this);
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            playerEntity.func_213829_a(new INamedContainerProvider(){

                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    return new ContainerDragon(p_createMenu_1_, (IInventory)EntityDragonBase.this.dragonInventory, p_createMenu_2_, EntityDragonBase.this);
                }

                public ITextComponent func_145748_c_() {
                    return EntityDragonBase.this.func_145748_c_();
                }
            });
        }
    }

    public int func_70627_aG() {
        return 90;
    }

    protected void func_70609_aI() {
        this.field_70725_aQ = 0;
        if (!this.isModelDead() && !this.field_70170_p.field_72995_K && this.field_70718_bc > 0) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (PlayerEntity)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = ExperienceOrbEntity.func_70527_a((int)i);
                this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), j));
            }
        }
        this.setModelDead(true);
        this.func_184226_ay();
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            this.func_70106_y();
            for (int k = 0; k < 40; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (!this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
            this.spawnDeathParticles();
        }
    }

    protected void spawnDeathParticles() {
    }

    protected void spawnBabyParticles() {
    }

    public void func_70106_y() {
        this.removeParts();
        super.func_70106_y();
    }

    protected int func_70693_a(PlayerEntity player) {
        switch (this.getDragonStage()) {
            case 2: {
                return 20;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 300;
            }
            case 5: {
                return 650;
            }
        }
        return 5;
    }

    public int getArmorOrdinal(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemDragonArmor) {
            ItemDragonArmor armorItem = (ItemDragonArmor)stack.func_77973_b();
            return armorItem.type + 1;
        }
        return 0;
    }

    public boolean func_175446_cd() {
        return this.isModelDead() || super.func_175446_cd();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNGER, (Object)0);
        this.field_70180_af.func_187214_a(AGE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(FIREBREATHING, (Object)false);
        this.field_70180_af.func_187214_a(HOVERING, (Object)false);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(DEATH_STAGE, (Object)0);
        this.field_70180_af.func_187214_a(MODEL_DEAD, (Object)false);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(TACKLE, (Object)false);
        this.field_70180_af.func_187214_a(AGINGDISABLED, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(DRAGON_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CRYSTAL_BOUND, (Object)false);
        this.field_70180_af.func_187214_a(CUSTOM_POSE, (Object)"");
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean isAttacking() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean isStriking() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean isDismounting() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 4 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
        this.setStateField(1, down);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        this.func_233687_w_(command == 1);
    }

    public float getDragonPitch() {
        return ((Float)this.field_70180_af.func_187225_a(DRAGON_PITCH)).floatValue();
    }

    public void setDragonPitch(float pitch) {
        this.field_70180_af.func_187227_b(DRAGON_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementDragonPitch(float pitch) {
        this.field_70180_af.func_187227_b(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() + pitch));
    }

    public void decrementDragonPitch(float pitch) {
        this.field_70180_af.func_187227_b(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() - pitch));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74768_a("AgeTicks", this.getAgeInTicks());
        compound.func_74757_a("Gender", this.isMale());
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Sleeping", this.func_70608_bn());
        compound.func_74757_a("TamedDragon", this.func_70909_n());
        compound.func_74757_a("FireBreathing", this.isBreathingFire());
        compound.func_74757_a("AttackDecision", this.usingGroundAttack);
        compound.func_74757_a("Hovering", this.isHovering());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("DeathStage", this.getDeathStage());
        compound.func_74757_a("ModelDead", this.isModelDead());
        compound.func_74776_a("DeadProg", this.modelDeadProgress);
        compound.func_74757_a("Tackle", this.isTackling());
        compound.func_74757_a("HasHomePosition", this.hasHomePosition);
        compound.func_74778_a("CustomPose", this.getCustomPose());
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(compound);
        }
        compound.func_74757_a("AgingDisabled", this.isAgingDisabled());
        compound.func_74768_a("Command", this.getCommand());
        if (this.dragonInventory != null) {
            ListNBT nbttaglist = new ListNBT();
            for (int i = 0; i < this.dragonInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.dragonInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                CompoundNBT2.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(CompoundNBT2);
                nbttaglist.add((Object)CompoundNBT2);
            }
            compound.func_218657_a("Items", (INBT)nbttaglist);
        }
        compound.func_74757_a("CrystalBound", this.isBoundToCrystal());
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.func_200201_e()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setAgeInTicks(compound.func_74762_e("AgeTicks"));
        this.setGender(compound.func_74767_n("Gender"));
        this.setVariant(compound.func_74762_e("Variant"));
        this.func_233686_v_(compound.func_74767_n("Sleeping"));
        this.func_70903_f(compound.func_74767_n("TamedDragon"));
        this.setBreathingFire(compound.func_74767_n("FireBreathing"));
        this.usingGroundAttack = compound.func_74767_n("AttackDecision");
        this.setHovering(compound.func_74767_n("Hovering"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setDeathStage(compound.func_74762_e("DeathStage"));
        this.setModelDead(compound.func_74767_n("ModelDead"));
        this.modelDeadProgress = compound.func_74760_g("DeadProg");
        this.setCustomPose(compound.func_74779_i("CustomPose"));
        this.hasHomePosition = compound.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(compound, this.field_70170_p);
        }
        this.setTackling(compound.func_74767_n("Tackle"));
        this.setAgingDisabled(compound.func_74767_n("AgingDisabled"));
        this.setCommand(compound.func_74762_e("Command"));
        if (this.dragonInventory != null) {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (INBT inbt : nbttaglist) {
                CompoundNBT CompoundNBT2 = (CompoundNBT)inbt;
                int j = CompoundNBT2.func_74771_c("Slot") & 0xFF;
                if (j > 4) continue;
                this.dragonInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
            }
        } else {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (INBT inbt : nbttaglist) {
                CompoundNBT CompoundNBT3 = (CompoundNBT)inbt;
                int j = CompoundNBT3.func_74771_c("Slot") & 0xFF;
                this.dragonInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT3));
            }
        }
        this.setCrystalBound(compound.func_74767_n("CrystalBound"));
        if (compound.func_150297_b("CustomName", 8) && !compound.func_74779_i("CustomName").startsWith("TextComponent")) {
            this.func_200203_b((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName")));
        }
    }

    private void initInventory() {
        Inventory inventory = this.dragonInventory;
        this.dragonInventory = new Inventory(5);
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.dragonInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.dragonInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.dragonInventory.func_110134_a((IInventoryChangedListener)this);
        this.updateAttributes();
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity) || this.func_70638_az() == passenger) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public boolean isRidingPlayer(PlayerEntity player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Override
    @Nullable
    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    protected void updateAttributes() {
        this.prevArmorResLoc = this.armorResLoc;
        int armorHead = this.getArmorOrdinal(this.func_184582_a(EquipmentSlotType.HEAD));
        int armorNeck = this.getArmorOrdinal(this.func_184582_a(EquipmentSlotType.CHEST));
        int armorLegs = this.getArmorOrdinal(this.func_184582_a(EquipmentSlotType.LEGS));
        int armorFeet = this.getArmorOrdinal(this.func_184582_a(EquipmentSlotType.FEET));
        this.armorResLoc = this.dragonType.getName() + "|" + armorHead + "|" + armorNeck + "|" + armorLegs + "|" + armorFeet;
        IceAndFire.PROXY.updateDragonArmorRender(this.armorResLoc);
        if (this.getAgeInDays() <= 125) {
            double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
            double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
            double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
            double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)Math.round(this.minimumHealth + healthStep * (double)this.getAgeInDays()));
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)Math.round(this.minimumDamage + attackStep * (double)this.getAgeInDays()));
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.minimumSpeed + speedStep * (double)this.getAgeInDays());
            double baseValue = this.minimumArmor + armorStep * (double)this.getAgeInDays();
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(baseValue);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110148_a(Attributes.field_233826_i_).func_188479_b(ARMOR_MODIFIER_UUID);
                this.func_110148_a(Attributes.field_233826_i_).func_233767_b_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Dragon armor bonus", this.calculateArmorModifier(), AttributeModifier.Operation.ADDITION));
            }
        }
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)Math.min(2048, IafConfig.dragonTargetSearchLength));
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)MathHelper.func_76125_a((int)hunger, (int)0, (int)100));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.field_70180_af.func_187225_a(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.field_70180_af.func_187227_b(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(GENDER);
    }

    public boolean isModelDead() {
        if (this.field_70170_p.field_72995_K) {
            this.isModelDead = (Boolean)this.field_70180_af.func_187225_a(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public void setModelDead(boolean modeldead) {
        this.field_70180_af.func_187227_b(MODEL_DEAD, (Object)modeldead);
        if (!this.field_70170_p.field_72995_K) {
            this.isModelDead = modeldead;
        }
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.field_70180_af.func_187225_a(HOVERING);
    }

    public void setHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(HOVERING, (Object)hovering);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public boolean useFlyingPathFinder() {
        return this.isFlying();
    }

    public void setGender(boolean male) {
        this.field_70180_af.func_187227_b(GENDER, (Object)male);
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public boolean isBreathingFire() {
        return (Boolean)this.field_70180_af.func_187225_a(FIREBREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        this.field_70180_af.func_187227_b(FIREBREATHING, (Object)breathing);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public boolean func_233685_eM_() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
    }

    public void func_233686_v_(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public void func_233687_w_(boolean sitting) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public String getCustomPose() {
        return (String)this.field_70180_af.func_187225_a(CUSTOM_POSE);
    }

    public void setCustomPose(String customPose) {
        this.field_70180_af.func_187227_b(CUSTOM_POSE, (Object)customPose);
        this.modelDeadProgress = 20.0f;
    }

    public void riderShootFire(Entity controller) {
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        this.setHunger(this.getHunger() + FoodUtils.getFoodPoints((Entity)entity));
    }

    private double calculateArmorModifier() {
        EquipmentSlotType[] slots;
        double val = 1.0;
        block7: for (EquipmentSlotType slot : slots = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET}) {
            switch (this.getArmorOrdinal(this.func_184582_a(slot))) {
                case 1: {
                    val += 2.0;
                    continue block7;
                }
                case 2: 
                case 4: {
                    val += 3.0;
                    continue block7;
                }
                case 3: {
                    val += 5.0;
                    continue block7;
                }
                case 5: 
                case 6: 
                case 8: {
                    val += 10.0;
                    continue block7;
                }
                case 7: {
                    val += 1.5;
                }
            }
        }
        return val;
    }

    public boolean canMove() {
        return !this.func_233685_eM_() && !this.func_70608_bn() && this.func_184179_bs() == null && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    public boolean isFuelingForge() {
        return this.burningTarget != null && this.field_70170_p.func_175625_s(this.burningTarget) instanceof TileEntityDragonforgeInput;
    }

    public boolean func_70089_S() {
        return super.func_70089_S();
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int lastDeathStage = Math.min(this.getAgeInDays() / 5, 25);
        if (stack.func_77973_b() == IafItemRegistry.DRAGON_DEBUG_STICK) {
            this.logic.debug();
            return ActionResultType.SUCCESS;
        }
        if (this.isModelDead() && this.getDeathStage() < lastDeathStage && player.func_175142_cm()) {
            if (!this.field_70170_p.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == Items.field_151069_bo && this.getDeathStage() < lastDeathStage / 2 && IafConfig.dragonDropBlood) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                this.setDeathStage(this.getDeathStage() + 1);
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)this.getBloodItem(), 1));
                return ActionResultType.SUCCESS;
            }
            if (!this.field_70170_p.field_72995_K && stack.func_190926_b() && IafConfig.dragonDropSkull) {
                if (this.getDeathStage() >= lastDeathStage - 1) {
                    ItemStack skull = this.getSkull().func_77946_l();
                    skull.func_77982_d(new CompoundNBT());
                    skull.func_77978_p().func_74768_a("Stage", this.getDragonStage());
                    skull.func_77978_p().func_74768_a("DragonType", 0);
                    skull.func_77978_p().func_74768_a("DragonAge", this.getAgeInDays());
                    this.setDeathStage(this.getDeathStage() + 1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70099_a(skull, 1.0f);
                    }
                    this.func_70106_y();
                } else if (this.getDeathStage() == lastDeathStage / 2 - 1 && IafConfig.dragonDropHeart) {
                    ItemStack heart = new ItemStack(this.getHeartItem(), 1);
                    ItemStack egg = new ItemStack((IItemProvider)this.getVariantEgg(this.field_70146_Z.nextInt(4)), 1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70099_a(heart, 1.0f);
                        if (!this.isMale() && this.getDragonStage() > 3) {
                            this.func_70099_a(egg, 1.0f);
                        }
                    }
                    this.setDeathStage(this.getDeathStage() + 1);
                } else {
                    this.setDeathStage(this.getDeathStage() + 1);
                    ItemStack drop = this.getRandomDrop();
                    if (!drop.func_190926_b() && !this.field_70170_p.field_72995_K) {
                        this.func_70099_a(drop, 1.0f);
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int lastDeathStage = this.getAgeInDays() / 5;
        if (stack.func_77973_b() == IafItemRegistry.DRAGON_DEBUG_STICK) {
            this.logic.debug();
            return ActionResultType.SUCCESS;
        }
        if (!this.isModelDead()) {
            if (stack.func_77973_b() == IafItemRegistry.CREATIVE_DRAGON_MEAL) {
                this.func_70903_f(true);
                this.func_193101_c(player);
                this.setHunger(this.getHunger() + 20);
                this.func_70691_i(Math.min(this.func_110143_aJ(), (float)((int)(this.func_110138_aP() / 2.0f))));
                this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                this.spawnItemCrackParticles(stack.func_77973_b());
                this.spawnItemCrackParticles(Items.field_151103_aS);
                this.spawnItemCrackParticles(Items.field_196106_bc);
                this.eatFoodBonus(stack);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            if (this.func_70877_b(stack) && this.func_230282_cS_()) {
                this.func_70873_a(0);
                this.func_175505_a(player, stack);
                this.func_146082_f(player);
                return ActionResultType.SUCCESS;
            }
            if (this.func_152114_e((LivingEntity)player)) {
                if (stack.func_77973_b() == this.getSummoningCrystal() && !ItemSummoningCrystal.hasDragon(stack)) {
                    this.setCrystalBound(true);
                    CompoundNBT compound = stack.func_77978_p();
                    if (compound == null) {
                        compound = new CompoundNBT();
                        stack.func_77982_d(compound);
                    }
                    CompoundNBT dragonTag = new CompoundNBT();
                    dragonTag.func_186854_a("DragonUUID", this.func_110124_au());
                    if (this.func_200201_e() != null) {
                        dragonTag.func_74778_a("CustomName", this.func_200201_e().getString());
                    }
                    compound.func_218657_a("Dragon", (INBT)dragonTag);
                    this.func_184185_a(SoundEvents.field_187618_I, 1.0f, 1.0f);
                    player.func_184609_a(hand);
                    return ActionResultType.SUCCESS;
                }
                this.func_193101_c(player);
                if (stack.func_77973_b() == IafItemRegistry.DRAGON_HORN) {
                    return super.func_230254_b_(player, hand);
                }
                if (stack.func_190926_b() && !player.func_225608_bj_()) {
                    if (!this.field_70170_p.field_72995_K) {
                        int dragonStage = this.getDragonStage();
                        if (dragonStage < 2) {
                            this.func_184205_a((Entity)player, true);
                            IceAndFire.sendMSGToAll(new MessageStartRidingMob(this.func_145782_y(), true, true));
                            return ActionResultType.SUCCESS;
                        }
                        if (dragonStage > 2 && !player.func_184218_aH()) {
                            player.func_226284_e_(false);
                            player.func_184205_a((Entity)this, true);
                            IceAndFire.sendMSGToAll(new MessageStartRidingMob(this.func_145782_y(), true, false));
                            this.func_233686_v_(false);
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_190926_b() && player.func_225608_bj_()) {
                    this.openGUI(player);
                    return ActionResultType.SUCCESS;
                }
                int itemFoodAmount = FoodUtils.getFoodPoints(stack, true, this.dragonType.isPiscivore());
                if (itemFoodAmount > 0 && (this.getHunger() < 100 || this.func_110143_aJ() < this.func_110138_aP())) {
                    this.setHunger(this.getHunger() + itemFoodAmount);
                    this.func_70606_j(Math.min(this.func_110138_aP(), (float)((int)(this.func_110143_aJ() + (float)(itemFoodAmount / 10)))));
                    this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                    this.spawnItemCrackParticles(stack.func_77973_b());
                    this.eatFoodBonus(stack);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                Item stackItem = stack.func_77973_b();
                if (stackItem == IafItemRegistry.DRAGON_MEAL) {
                    this.growDragon(1);
                    this.setHunger(this.getHunger() + 20);
                    this.func_70691_i(Math.min(this.func_110143_aJ(), (float)((int)(this.func_110138_aP() / 2.0f))));
                    this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.field_151103_aS);
                    this.spawnItemCrackParticles(Items.field_196106_bc);
                    this.eatFoodBonus(stack);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (stackItem == IafItemRegistry.SICKLY_DRAGON_MEAL && !this.isAgingDisabled()) {
                    this.setHunger(this.getHunger() + 20);
                    this.func_70691_i(this.func_110138_aP());
                    this.func_184185_a(SoundEvents.field_187942_hp, this.func_70599_aP(), this.func_70647_i());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.field_151103_aS);
                    this.spawnItemCrackParticles(Items.field_196106_bc);
                    this.spawnItemCrackParticles(Items.field_151170_bI);
                    this.spawnItemCrackParticles(Items.field_151170_bI);
                    this.setAgingDisabled(true);
                    this.eatFoodBonus(stack);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (stackItem == IafItemRegistry.DRAGON_STAFF) {
                    if (player.func_225608_bj_()) {
                        if (this.hasHomePosition) {
                            this.hasHomePosition = false;
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("dragon.command.remove_home"), true);
                            return ActionResultType.SUCCESS;
                        }
                        BlockPos pos = this.func_233580_cy_();
                        this.homePos = new HomePosition(pos, this.field_70170_p);
                        this.hasHomePosition = true;
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("dragon.command.new_home", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.homePos.getDimension()}), true);
                        return ActionResultType.SUCCESS;
                    }
                    this.func_184185_a(SoundEvents.field_187945_hs, this.func_70599_aP(), this.func_70647_i());
                    if (!this.field_70170_p.field_72995_K) {
                        this.setCommand(this.getCommand() + 1);
                        if (this.getCommand() > 2) {
                            this.setCommand(0);
                        }
                    }
                    String commandText = "stand";
                    if (this.getCommand() == 1) {
                        commandText = "sit";
                    } else if (this.getCommand() == 2) {
                        commandText = "escort";
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("dragon.command." + commandText), true);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.func_230254_b_(player, hand);
    }

    protected abstract IItemProvider getHeartItem();

    protected abstract Item getBloodItem();

    protected ItemStack getSkull() {
        return ItemStack.field_190927_a;
    }

    private ItemStack getRandomDrop() {
        ItemStack stack = this.getItemFromLootTable();
        if (stack.func_77973_b() == IafItemRegistry.DRAGON_BONE) {
            this.func_184185_a(SoundEvents.field_187854_fc, 1.0f, 1.0f);
        } else {
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
        }
        return stack;
    }

    public boolean canPositionBeSeen(double x, double y, double z) {
        BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_()), new Vector3d(x, y, z), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        double dist = result.func_216347_e().func_186679_c(x, y, z);
        return dist <= 1.0 || result.func_216346_c() == RayTraceResult.Type.MISS;
    }

    public abstract ResourceLocation getDeadLootTable();

    public ItemStack getItemFromLootTable() {
        LootContext.Builder lootcontext$builder;
        LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.getDeadLootTable());
        Iterator iterator = loottable.func_216113_a((lootcontext$builder = this.func_213363_a(false, DamageSource.field_76377_j)).func_216022_a(LootParameterSets.field_216263_d)).iterator();
        if (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void eatFoodBonus(ItemStack stack) {
    }

    public boolean func_213392_I() {
        return true;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public void growDragon(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.func_174829_m();
        if (this.field_70170_p.field_72995_K && this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                float f = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
                float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
                float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ);
                ++i;
            }
        }
        if (this.getDragonStage() >= 2) {
            this.func_233575_bb_();
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.func_70681_au().nextGaussian() * 0.07;
            double motionY = this.func_70681_au().nextGaussian() * 0.07;
            double motionZ = this.func_70681_au().nextGaussian() * 0.07;
            Vector3d headVec = this.getHeadPosition();
            if (!this.field_70170_p.field_72995_K) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)item)), headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c, 1, motionX, motionY, motionZ, 0.1);
                continue;
            }
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)item)), headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c, motionX, motionY, motionZ);
        }
    }

    public boolean isTimeToWake() {
        return this.field_70170_p.func_72935_r() || this.getCommand() == 2;
    }

    private boolean isStuck() {
        return !this.isChained() && !this.func_70909_n() && !this.func_70661_as().func_75500_f() && (this.func_70661_as().func_75505_d() == null || this.func_70661_as().func_75505_d().func_75870_c() != null && this.func_70092_e(this.func_70661_as().func_75505_d().func_75870_c().field_75839_a, this.func_70661_as().func_75505_d().func_75870_c().field_75837_b, this.func_70661_as().func_75505_d().func_75870_c().field_75838_c) > 15.0) && this.ticksStill > 80 && !this.isHovering() && this.canMove();
    }

    protected boolean isOverAir() {
        return this.isOverAir;
    }

    private boolean isOverAirLogic() {
        return this.field_70170_p.func_175623_d(new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_()));
    }

    public boolean isDiving() {
        return false;
    }

    public boolean isBeyondHeight() {
        if (this.func_226278_cu_() > (double)this.field_70170_p.func_217301_I()) {
            return true;
        }
        return this.func_226278_cu_() > (double)IafConfig.maxDragonFlight;
    }

    private int calculateDownY() {
        if (this.func_70661_as().func_75505_d() != null) {
            Path path = this.func_70661_as().func_75505_d();
            Vector3d p = path.func_75881_a((Entity)this, Math.min(path.func_75874_d() - 1, path.func_75873_e() + 1));
            if (p.field_72448_b < this.func_226278_cu_() - 1.0) {
                return -1;
            }
        }
        return 1;
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0 || IafConfig.dragonBreakBlockCooldown == 0) {
            --this.blockBreakCounter;
            if (!(this.isIceInWater() || this.blockBreakCounter != 0 && IafConfig.dragonBreakBlockCooldown != 0 || !ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) || IafConfig.dragonGriefing == 2 || this.func_70909_n() && !IafConfig.tamedDragonGriefing || this.isModelDead() || this.getDragonStage() < 3 || !this.canMove() && this.func_184179_bs() == null)) {
                boolean bounds = true;
                int flightModifier = this.isFlying() && this.func_70638_az() != null ? -1 : 1;
                int yMinus = this.calculateDownY();
                BlockPos.func_218287_a((int)((int)Math.floor(this.func_174813_aQ().field_72340_a) - 1), (int)((int)Math.floor(this.func_174813_aQ().field_72338_b) + yMinus), (int)((int)Math.floor(this.func_174813_aQ().field_72339_c) - 1), (int)((int)Math.floor(this.func_174813_aQ().field_72336_d) + 1), (int)((int)Math.floor(this.func_174813_aQ().field_72337_e) + 1 + flightModifier), (int)((int)Math.floor(this.func_174813_aQ().field_72334_f) + 1)).forEach(pos -> {
                    float hardness;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))) {
                        return;
                    }
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    float f = hardness = IafConfig.dragonGriefing == 1 || this.getDragonStage() <= 3 ? 2.0f : 5.0f;
                    if (this.isBreakable((BlockPos)pos, state, hardness)) {
                        this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.6f, 1.0, (double)0.6f));
                        if (!this.field_70170_p.field_72995_K) {
                            if ((double)this.field_70146_Z.nextFloat() <= IafConfig.dragonBlockBreakingDropChance && DragonUtils.canDropFromDragonBlockBreak(state)) {
                                this.field_70170_p.func_175655_b(pos, true);
                            } else {
                                this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                            }
                        }
                    }
                });
            }
        }
    }

    protected boolean isBreakable(BlockPos pos, BlockState state, float hardness) {
        return state.func_185904_a().func_76230_c() && !state.func_196958_f() && state.func_204520_s().func_206888_e() && !state.func_196954_c((IBlockReader)this.field_70170_p, pos).func_197766_b() && state.func_185887_b((IBlockReader)this.field_70170_p, pos) >= 0.0f && state.func_185887_b((IBlockReader)this.field_70170_p, pos) <= hardness && DragonUtils.canDragonBreak(state.func_177230_c()) && this.canDestroyBlock(pos, state);
    }

    @Override
    public boolean isBlockExplicitlyPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        if (!this.isModelDead() && this.getDragonStage() >= 3 && IafConfig.dragonGriefing != 2 && (!this.func_70909_n() || IafConfig.tamedDragonGriefing) && (double)pos.func_177956_o() >= this.func_226278_cu_()) {
            return this.isBreakable(pos, state, IafConfig.dragonGriefing == 1 || this.getDragonStage() <= 3 ? 2.0f : 5.0f);
        }
        return false;
    }

    @Override
    public boolean isBlockExplicitlyNotPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return false;
    }

    protected boolean isIceInWater() {
        return false;
    }

    public void spawnGroundEffects() {
        if (this.field_70170_p.field_72995_K) {
            int i = 0;
            while ((float)i < this.getRenderSize()) {
                for (int i1 = 0; i1 < 20; ++i1) {
                    float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                    float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraY = 0.8f;
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    BlockPos ground = this.getGround(new BlockPos(MathHelper.func_76128_c((double)(this.func_226277_ct_() + extraX)), MathHelper.func_76128_c((double)(this.func_226278_cu_() + (double)0.8f)) - 1, MathHelper.func_76128_c((double)(this.func_226281_cx_() + extraZ))));
                    BlockState BlockState2 = this.field_70170_p.func_180495_p(ground);
                    if (BlockState2.func_185904_a() == Material.field_151579_a) continue;
                    double motionX = this.func_70681_au().nextGaussian() * 0.07;
                    double motionY = this.func_70681_au().nextGaussian() * 0.07;
                    double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                    this.field_70170_p.func_195590_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, BlockState2), true, this.func_226277_ct_() + extraX, (double)ground.func_177956_o() + (double)0.8f, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }

    private BlockPos getGround(BlockPos blockPos) {
        while (this.field_70170_p.func_175623_d(blockPos) && blockPos.func_177956_o() > 1) {
            blockPos = blockPos.func_177977_b();
        }
        return blockPos;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public boolean isActuallyBreathingFire() {
        return this.fireTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 6000 || this.isGoingDown() || this.flyTicks > 40 && this.flyProgress == 0.0f || this.isChained() && this.flyTicks > 100;
    }

    public abstract String getVariantName(int var1);

    public boolean shouldRiderSit() {
        return this.func_184179_bs() != null;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            if (this.func_184179_bs() == null || !this.func_184179_bs().func_110124_au().equals(passenger.func_110124_au())) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.func_184210_p();
                }
                this.field_70761_aq = this.field_70177_z;
                this.field_70177_z = passenger.field_70177_z;
                Vector3d riderPos = this.getRiderPosition();
                passenger.func_70107_b(riderPos.field_72450_a, riderPos.field_72448_b + (double)passenger.func_213302_cg(), riderPos.field_72449_c);
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        double a = MathHelper.func_76126_a((float)(f * speed)) * f1 * degree;
        float bob = (float)(a - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(a));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    protected void updatePreyInMouth(Entity prey) {
        if (this.getAnimation() != ANIMATION_SHAKEPREY) {
            this.setAnimation(ANIMATION_SHAKEPREY);
        }
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null) {
            prey.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), prey instanceof PlayerEntity ? 17.0f : (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 4.0f);
            prey.func_184210_p();
        }
        this.field_70761_aq = this.field_70177_z;
        float modTick_0 = this.getAnimationTick() - 25;
        float modTick_1 = this.getAnimationTick() > 25 && this.getAnimationTick() < 55 ? 8.0f * MathHelper.func_76131_a((float)MathHelper.func_76126_a((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
        float modTick_2 = this.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, this.getAnimationTick() - 20);
        float radius = 0.75f * (0.6f * this.getRenderSize() / 3.0f) * -3.0f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f + modTick_1 * 2.0f * 0.015f;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(this.getRenderSize() / 3.0f));
        prey.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ);
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() < 4 && this.getDragonStage() > 2;
    }

    public boolean func_230282_cS_() {
        return this.getDragonStage() >= 4;
    }

    public boolean func_70631_g_() {
        return this.getDragonStage() < 2;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setGender(this.func_70681_au().nextBoolean());
        int age = this.func_70681_au().nextInt(80) + 1;
        this.growDragon(age);
        this.setVariant(new Random().nextInt(4));
        this.func_233686_v_(false);
        this.updateAttributes();
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.func_70691_i(Math.round(this.minimumHealth + healthStep * (double)age));
        this.usingGroundAttack = true;
        this.setHunger(50);
        return spawnDataIn;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.isModelDead()) {
            return false;
        }
        if (this.func_184207_aI() && dmg.func_76346_g() != null && this.func_184179_bs() != null && dmg.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        if ((dmg.field_76373_n.contains("arrow") || this.func_184187_bx() != null && dmg.func_76346_g() != null && dmg.func_76346_g().func_70028_i(this.func_184187_bx())) && this.func_184218_aH()) {
            return false;
        }
        if (dmg == DamageSource.field_76368_d || dmg == DamageSource.field_82729_p || dmg == DamageSource.field_191291_g) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && dmg.func_76346_g() != null && this.func_70681_au().nextInt(4) == 0) {
            this.roar();
        }
        if (i > 0.0f && this.func_70608_bn()) {
            this.func_233686_v_(false);
            if (!this.func_70909_n() && dmg.func_76346_g() instanceof PlayerEntity) {
                this.func_70624_b((LivingEntity)((PlayerEntity)dmg.func_76346_g()));
            }
        }
        return super.func_70097_a(dmg, i);
    }

    public void func_213323_x_() {
        super.func_213323_x_();
        float scale = Math.min(this.getRenderSize() * 0.35f, 7.0f);
        if (scale != this.lastScale) {
            this.resetParts(this.getRenderSize() / 3.0f);
        }
        this.lastScale = scale;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213323_x_();
        this.updateParts();
        this.prevDragonPitch = this.getDragonPitch();
        this.field_70170_p.func_217381_Z().func_76320_a("dragonLogic");
        this.field_70138_W = 1.2f;
        this.isOverAir = this.isOverAirLogic();
        this.logic.updateDragonCommon();
        if (this.isModelDead()) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175623_d(new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_())) && this.func_226278_cu_() > -1.0) {
                this.func_213315_a(MoverType.SELF, new Vector3d(0.0, (double)-0.2f, 0.0));
            }
            this.setBreathingFire(false);
            float dragonPitch = this.getDragonPitch();
            if (dragonPitch > 0.0f) {
                dragonPitch = Math.min(0.0f, dragonPitch - 5.0f);
                this.setDragonPitch(dragonPitch);
            }
            if (dragonPitch < 0.0f) {
                this.setDragonPitch(Math.max(0.0f, dragonPitch + 5.0f));
            }
        } else if (this.field_70170_p.field_72995_K) {
            this.logic.updateDragonClient();
        } else {
            this.logic.updateDragonServer();
            this.logic.updateDragonAttack();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("dragonFlight");
        if (this.isFlying() && !this.field_70170_p.field_72995_K) {
            this.flightManager.update();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevModelDeadProgress = this.modelDeadProgress;
        this.prevDiveProgress = this.diveProgress;
        this.prevAnimationProgresses[0] = this.sitProgress;
        this.prevAnimationProgresses[1] = this.sleepProgress;
        this.prevAnimationProgresses[2] = this.hoverProgress;
        this.prevAnimationProgresses[3] = this.flyProgress;
        this.prevAnimationProgresses[4] = this.fireBreathProgress;
        this.prevAnimationProgresses[5] = this.ridingProgress;
        this.prevAnimationProgresses[6] = this.tackleProgress;
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (this.isModelDead()) {
            if (this.func_184207_aI()) {
                this.func_184226_ay();
            }
            this.setHovering(false);
            this.setFlying(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.animationTick > this.getAnimation().getDuration() && !this.field_70170_p.field_72995_K) {
            this.animationTick = 0;
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
    }

    public float func_213355_cm() {
        return Math.min(this.getRenderSize() * 0.35f, 7.0f);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getRenderSize() {
        int stage = this.getDragonStage() - 1;
        float step = (this.growth_stages[stage][1] - this.growth_stages[stage][0]) / 25.0f;
        if (this.getAgeInDays() > 125) {
            return this.growth_stages[stage][0] + step * 25.0f;
        }
        return this.growth_stages[stage][0] + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_70671_ap().func_75651_a(entityIn, 30.0f, 30.0f);
        if (this.isTackling() || this.isModelDead()) {
            return false;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && !entity.func_70089_S()) {
            this.func_184210_p();
        } else {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.func_184196_w((Entity)this) && riding instanceof PlayerEntity) {
            int i = riding.func_184188_bt().indexOf(this);
            float radius = (i == 2 ? -0.2f : 0.5f) + (float)(((PlayerEntity)riding).func_184613_cA() ? 2 : 0);
            float angle = (float)Math.PI / 180 * ((PlayerEntity)riding).field_70761_aq + (float)(i == 1 ? 90 : (i == 0 ? -90 : 0));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = (riding.func_225608_bj_() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.field_70759_as = ((PlayerEntity)riding).field_70759_as;
            this.field_70126_B = ((PlayerEntity)riding).field_70759_as;
            this.func_70107_b(riding.func_226277_ct_() + extraX, riding.func_226278_cu_() + extraY, riding.func_226281_cx_() + extraZ);
            if ((this.getControlState() == 16 || ((PlayerEntity)riding).func_184613_cA()) && !riding.func_184218_aH()) {
                this.func_184210_p();
                if (this.field_70170_p.field_72995_K) {
                    IceAndFire.sendMSGToServer(new MessageStartRidingMob(this.func_145782_y(), false, true));
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void func_70642_aH() {
        if (!(this.func_70608_bn() || this.isModelDead() || this.field_70170_p.field_72995_K)) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_70642_aH();
        }
    }

    protected void func_184581_c(DamageSource source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_184581_c(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal instanceof EntityDragonBase && otherAnimal != this && otherAnimal.getClass() == this.getClass()) {
            EntityDragonBase dragon = (EntityDragonBase)otherAnimal;
            return this.isMale() && !dragon.isMale() || !this.isMale() && dragon.isMale();
        }
        return false;
    }

    public EntityDragonEgg createEgg(EntityDragonBase ageable) {
        EntityDragonEgg dragon = new EntityDragonEgg((EntityType)IafEntityRegistry.DRAGON_EGG.get(), this.field_70170_p);
        dragon.setEggType(EnumDragonEgg.byMetadata(new Random().nextInt(4) + this.getStartMetaForType()));
        dragon.func_70107_b((double)MathHelper.func_76128_c((double)this.func_226277_ct_()) + 0.5, MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1, (double)MathHelper.func_76128_c((double)this.func_226281_cx_()) + 0.5);
        return dragon;
    }

    public int getStartMetaForType() {
        return 0;
    }

    public boolean isTargetBlocked(Vector3d target) {
        if (target != null) {
            BlockRayTraceResult rayTrace = this.field_70170_p.func_217299_a(new RayTraceContext(this.func_213303_ch().func_72441_c(0.0, (double)this.func_70047_e(), 0.0), target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            BlockPos sidePos = rayTrace.func_216350_a();
            if (!this.field_70170_p.func_175623_d(sidePos)) {
                return true;
            }
            if (!this.field_70170_p.func_175623_d(new BlockPos(rayTrace.func_216347_e()))) {
                return true;
            }
            return rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK;
        }
        return false;
    }

    private double getFlySpeed() {
        return (2 + this.getAgeInDays() / 125 * 2) * (this.isTackling() ? 2 : 1);
    }

    public boolean isTackling() {
        return (Boolean)this.field_70180_af.func_187225_a(TACKLE);
    }

    public void setTackling(boolean tackling) {
        this.field_70180_af.func_187227_b(TACKLE, (Object)tackling);
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(AGINGDISABLED);
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.field_70180_af.func_187227_b(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public boolean isBoundToCrystal() {
        return (Boolean)this.field_70180_af.func_187225_a(CRYSTAL_BOUND);
    }

    public void setCrystalBound(boolean crystalBound) {
        this.field_70180_af.func_187227_b(CRYSTAL_BOUND, (Object)crystalBound);
    }

    public float getDistanceSquared(Vector3d Vector3d2) {
        float f = (float)(this.func_226277_ct_() - Vector3d2.field_72450_a);
        float f1 = (float)(this.func_226278_cu_() - Vector3d2.field_72448_b);
        float f2 = (float)(this.func_226281_cx_() - Vector3d2.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    public abstract Item getVariantScale(int var1);

    public abstract Item getVariantEgg(int var1);

    public abstract Item getSummoningCrystal();

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_233685_eM_() && !this.func_184207_aI() || this.isModelDead();
    }

    public void func_213352_e(Vector3d Vector3d2) {
        if (this.getAnimation() == ANIMATION_SHAKEPREY || !this.canMove() && !this.func_184207_aI() || this.func_233685_eM_()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            Vector3d2 = new Vector3d(0.0, 0.0, 0.0);
        }
        super.func_213352_e(Vector3d2);
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        if (this.func_233685_eM_() && !this.func_184207_aI()) {
            pos = new Vector3d(0.0, pos.func_82617_b(), 0.0);
        }
        super.func_213315_a(typeIn, pos);
    }

    public void updateCheckPlayer() {
        double checkLength = this.func_174813_aQ().func_72320_b() * 3.0;
        PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, checkLength);
        if (this.func_70608_bn() && player != null && !this.func_152114_e((LivingEntity)player) && !player.func_184812_l_()) {
            this.func_233686_v_(false);
            this.func_233687_w_(false);
            this.func_70624_b((LivingEntity)player);
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean isDirectPathBetweenPoints(Vector3d vec1, Vector3d vec2) {
        BlockRayTraceResult rayTrace = this.field_70170_p.func_217299_a(new RayTraceContext(vec1, new Vector3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.func_213302_cg() * 0.5, vec2.field_72449_c), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        return rayTrace.func_216346_c() != RayTraceResult.Type.BLOCK;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    @Override
    public void onHearFlute(PlayerEntity player) {
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)player) && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    public abstract SoundEvent getRoarSound();

    public void roar() {
        block9: {
            block8: {
                if (EntityGorgon.isStoneMob((LivingEntity)this) || this.isModelDead()) {
                    return;
                }
                if (!this.field_70146_Z.nextBoolean()) break block8;
                if (this.getAnimation() != ANIMATION_EPIC_ROAR) {
                    this.setAnimation(ANIMATION_EPIC_ROAR);
                    this.func_184185_a(this.getRoarSound(), this.func_70599_aP() + 3.0f + (float)Math.max(0, this.getDragonStage() - 2), this.func_70647_i() * 0.7f);
                }
                if (this.getDragonStage() <= 3) break block9;
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity) || isStrongerDragon) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (this.func_152114_e(living) || this.isOwnersPet(living)) {
                        living.func_195064_c(new EffectInstance(Effects.field_76420_g, 50 * size));
                        continue;
                    }
                    if (living.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == IafItemRegistry.EARPLUGS) continue;
                    living.func_195064_c(new EffectInstance(Effects.field_76437_t, 50 * size));
                }
                break block9;
            }
            if (this.getAnimation() != ANIMATION_ROAR) {
                this.setAnimation(ANIMATION_ROAR);
                this.func_184185_a(this.getRoarSound(), this.func_70599_aP() + 2.0f + (float)Math.max(0, this.getDragonStage() - 3), this.func_70647_i());
            }
            if (this.getDragonStage() > 3) {
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity) || isStrongerDragon) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (this.func_152114_e(living) || this.isOwnersPet(living)) {
                        living.func_195064_c(new EffectInstance(Effects.field_76420_g, 30 * size));
                        continue;
                    }
                    living.func_195064_c(new EffectInstance(Effects.field_76437_t, 30 * size));
                }
            }
        }
    }

    private boolean isOwnersPet(LivingEntity living) {
        return this.func_70909_n() && this.func_70902_q() != null && living instanceof TameableEntity && ((TameableEntity)living).func_70902_q() != null && this.func_70902_q().func_70028_i((Entity)((TameableEntity)living).func_70902_q());
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vector3d vec1, Vector3d vec2) {
        BlockRayTraceResult movingobjectposition = this.field_70170_p.func_217299_a(new RayTraceContext(vec1, vec2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        return movingobjectposition.func_216346_c() != RayTraceResult.Type.BLOCK;
    }

    public void processArrows() {
        List entities = this.field_70170_p.func_217357_a(Entity.class, this.func_174813_aQ());
        for (Entity entity : entities) {
            if (!(entity instanceof AbstractArrowEntity)) continue;
        }
    }

    public boolean shouldRenderEyes() {
        return !this.func_70608_bn() && !this.isModelDead() && !this.isBlinking() && !EntityGorgon.isStoneMob((LivingEntity)this);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
    }

    public boolean isChained() {
        return ChainProperties.hasChainData((LivingEntity)this);
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public RayTraceResult rayTraceRider(Entity rider, double blockReachDistance, float partialTicks) {
        Vector3d Vector3d2 = rider.func_174824_e(partialTicks);
        Vector3d Vector3d1 = rider.func_70676_i(partialTicks);
        Vector3d Vector3d22 = Vector3d2.func_72441_c(Vector3d1.field_72450_a * blockReachDistance, Vector3d1.field_72448_b * blockReachDistance, Vector3d1.field_72449_c * blockReachDistance);
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, Vector3d22, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
    }

    public Vector3d getRiderPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        float sleepProg = this.sleepProgress * -0.025f;
        float extraAgeScale = this.func_213355_cm() * 0.2f;
        float pitchX = 0.0f;
        float pitchY = 0.0f;
        float dragonPitch = this.getDragonPitch();
        if (dragonPitch > 0.0f) {
            pitchX = Math.min(dragonPitch / 90.0f, 0.3f);
            pitchY = -(dragonPitch / 90.0f) * 2.0f;
        } else if (dragonPitch < 0.0f) {
            pitchY = dragonPitch / 90.0f * 0.1f;
            pitchX = Math.max(dragonPitch / 90.0f, -0.7f);
        }
        float xzMod = (0.15f + pitchX) * this.getRenderSize() + extraAgeScale;
        float headPosX = (float)(this.func_226277_ct_() + (double)(xzMod * MathHelper.func_76134_b((float)((float)((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.func_226278_cu_() + (double)((0.7f + sitProg + hoverProg + deadProg + sleepProg + flyProg + pitchY) * this.getRenderSize() * 0.3f) + (double)extraAgeScale);
        float headPosZ = (float)(this.func_226281_cx_() + (double)(xzMod * MathHelper.func_76126_a((float)((float)((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0)))));
        return new Vector3d((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public void func_174812_G() {
        this.func_70106_y();
        this.setDeathStage(this.getAgeInDays() / 5);
        this.setModelDead(false);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public Vector3d getHeadPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        int tick = 0;
        tick = this.getAnimationTick() < 10 ? this.getAnimationTick() : (this.getAnimationTick() > 50 ? 60 - this.getAnimationTick() : 10);
        float epicRoarProg = this.getAnimation() == ANIMATION_EPIC_ROAR ? (float)tick * 0.1f : 0.0f;
        float sleepProg = this.sleepProgress * -0.025f;
        float pitchMulti = 0.0f;
        float pitchAdjustment = 0.0f;
        float pitchMinus = 0.0f;
        float dragonPitch = -this.getDragonPitch();
        if (this.isFlying() || this.isHovering()) {
            pitchMulti = MathHelper.func_76126_a((float)((float)Math.toRadians(dragonPitch)));
            pitchAdjustment = 1.2f;
            if ((pitchMulti *= 2.1f * Math.abs(dragonPitch) / 90.0f) > 0.0f) {
                pitchMulti *= 1.5f - pitchMulti * 0.5f;
            }
            if (pitchMulti < 0.0f) {
                pitchMulti *= 1.3f - pitchMulti * 0.1f;
            }
            pitchMinus = 0.3f * Math.abs(dragonPitch / 90.0f);
            if (dragonPitch >= 0.0f) {
                pitchAdjustment = 0.6f * Math.abs(dragonPitch / 90.0f);
                pitchMinus = 0.95f * Math.abs(dragonPitch / 90.0f);
            }
        }
        float flightXz = 1.0f + flyProg + hoverProg;
        float xzMod = 1.7f * this.getRenderSize() * 0.3f * flightXz + this.getRenderSize() * (0.3f * MathHelper.func_76126_a((float)((float)((double)(dragonPitch + 90.0f) * Math.PI / 180.0))) * pitchAdjustment - pitchMinus - hoverProg * 0.45f);
        float headPosX = (float)(this.func_226277_ct_() + (double)(xzMod * MathHelper.func_76134_b((float)((float)((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.func_226278_cu_() + (double)((0.7f + sitProg + hoverProg + deadProg + epicRoarProg + sleepProg + flyProg + pitchMulti) * this.getRenderSize() * 0.3f));
        float headPosZ = (float)(this.func_226281_cx_() + (double)(xzMod * MathHelper.func_76126_a((float)((float)((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0)))));
        return new Vector3d((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public abstract void stimulateFire(double var1, double var3, double var5, int var7);

    public void randomizeAttacks() {
        this.airAttack = IafDragonAttacks.Air.values()[this.func_70681_au().nextInt(IafDragonAttacks.Air.values().length)];
        this.groundAttack = IafDragonAttacks.Ground.values()[this.func_70681_au().nextInt(IafDragonAttacks.Ground.values().length)];
    }

    public boolean func_174816_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, float explosionPower) {
        return !(blockStateIn.func_177230_c() instanceof IDragonProof) && DragonUtils.canDragonBreak(blockStateIn.func_177230_c());
    }

    public void tryScorchTarget() {
        LivingEntity entity = this.func_70638_az();
        if (entity != null) {
            float distX = (float)(entity.func_226277_ct_() - this.func_226277_ct_());
            float distZ = (float)(entity.func_226281_cx_() - this.func_226281_cx_());
            if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.field_70177_z = this.field_70761_aq;
                    if (this.field_70173_aa % 5 == 0) {
                        this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(this.func_226277_ct_() + (double)(distX * (float)this.fireTicks / 40.0f), entity.func_226278_cu_(), this.func_226281_cx_() + (double)(distZ * (float)this.fireTicks / 40.0f), 1);
                }
            } else {
                this.setBreathingFire(true);
            }
        }
    }

    public void func_70624_b(@Nullable LivingEntity LivingEntityIn) {
        super.func_70624_b(LivingEntityIn);
        this.flightManager.onSetAttackTarget(LivingEntityIn);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        TameableEntity tamableTarget;
        UUID targetOwner;
        if (this.func_70909_n() && target instanceof TameableEntity && (targetOwner = (tamableTarget = (TameableEntity)target).func_184753_b()) != null && targetOwner.equals(this.func_184753_b())) {
            return false;
        }
        return super.func_142018_a(target, owner);
    }

    public boolean func_213336_c(LivingEntity target) {
        return super.func_213336_c(target) && DragonUtils.isAlive(target);
    }

    public boolean isPart(Entity entityHit) {
        return this.headPart != null && this.headPart.func_70028_i(entityHit) || this.neckPart != null && this.neckPart.func_70028_i(entityHit) || this.leftWingLowerPart != null && this.leftWingLowerPart.func_70028_i(entityHit) || this.rightWingLowerPart != null && this.rightWingLowerPart.func_70028_i(entityHit) || this.leftWingUpperPart != null && this.leftWingUpperPart.func_70028_i(entityHit) || this.rightWingUpperPart != null && this.rightWingUpperPart.func_70028_i(entityHit) || this.tail1Part != null && this.tail1Part.func_70028_i(entityHit) || this.tail2Part != null && this.tail2Part.func_70028_i(entityHit) || this.tail3Part != null && this.tail3Part.func_70028_i(entityHit) || this.tail4Part != null && this.tail4Part.func_70028_i(entityHit);
    }

    @Override
    public double getFlightSpeedModifier() {
        return IafConfig.dragonFlightSpeedMod;
    }

    public boolean isAllowedToTriggerFlight() {
        return (this.hasFlightClearance() && this.field_70122_E || this.func_70090_H()) && !this.func_233685_eM_() && this.func_184188_bt().isEmpty() && !this.func_70631_g_() && !this.func_70608_bn() && this.canMove();
    }

    public BlockPos getEscortPosition() {
        return this.func_70902_q() != null ? new BlockPos(this.func_70902_q().func_213303_ch()) : this.func_233580_cy_();
    }

    public boolean shouldTPtoOwner() {
        return this.func_70902_q() != null && this.func_70032_d((Entity)this.func_70902_q()) > 10.0f;
    }

    public boolean isSkeletal() {
        return this.getDeathStage() >= this.getAgeInDays() / 5 / 2;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_70039_c(CompoundNBT compound) {
        return this.func_184198_c(compound);
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.field_187537_bA || soundIn == this.func_184639_G() || soundIn == this.func_184601_bQ(null) || soundIn == this.func_184615_bR() || soundIn == this.getRoarSound()) {
            if (!this.func_174814_R() && this.headPart != null) {
                this.field_70170_p.func_184148_a(null, this.headPart.func_226277_ct_(), this.headPart.func_226278_cu_(), this.headPart.func_226281_cx_(), soundIn, this.func_184176_by(), volume, pitch);
            }
        } else {
            super.func_184185_a(soundIn, volume, pitch);
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean hasFlightClearance() {
        BlockPos topOfBB = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
        for (int i = 1; i < 4; ++i) {
            if (this.field_70170_p.func_175623_d(topOfBB.func_177981_b(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        switch (slotIn) {
            case OFFHAND: {
                return this.dragonInventory.func_70301_a(0);
            }
            case HEAD: {
                return this.dragonInventory.func_70301_a(1);
            }
            case CHEST: {
                return this.dragonInventory.func_70301_a(2);
            }
            case LEGS: {
                return this.dragonInventory.func_70301_a(3);
            }
            case FEET: {
                return this.dragonInventory.func_70301_a(4);
            }
        }
        return super.func_184582_a(slotIn);
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        switch (slotIn) {
            case OFFHAND: {
                this.dragonInventory.func_70299_a(0, stack);
                break;
            }
            case HEAD: {
                this.dragonInventory.func_70299_a(1, stack);
                break;
            }
            case CHEST: {
                this.dragonInventory.func_70299_a(2, stack);
                break;
            }
            case LEGS: {
                this.dragonInventory.func_70299_a(3, stack);
                break;
            }
            case FEET: {
                this.dragonInventory.func_70299_a(4, stack);
                break;
            }
            default: {
                super.func_184582_a(slotIn);
            }
        }
        this.updateAttributes();
    }

    public float func_70647_i() {
        return super.func_70647_i();
    }

    public SoundEvent getBabyFireSound() {
        return SoundEvents.field_187646_bt;
    }

    protected boolean isPlayingAttackAnimation() {
        return this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_SHAKEPREY || this.getAnimation() == ANIMATION_WINGBLAST || this.getAnimation() == ANIMATION_TAILWHACK;
    }

    protected IafDragonLogic createDragonLogic() {
        return new IafDragonLogic(this);
    }

    protected int getFlightChancePerTick() {
        return 1500;
    }

    public void onRemovedFromWorld() {
        DragonPosWorldData data;
        if (IafConfig.chunkLoadSummonCrystal && this.isBoundToCrystal() && (data = DragonPosWorldData.get(this.field_70170_p)) != null) {
            data.addDragon(this.func_110124_au(), this.func_233580_cy_());
        }
        super.onRemovedFromWorld();
    }

    @Override
    public int maxSearchNodes() {
        return (int)this.func_110148_a(Attributes.field_233819_b_).func_111126_e();
    }

    @Override
    public boolean isSmallerThanBlock() {
        return false;
    }

    @Override
    public float getXZNavSize() {
        return Math.max(1.4f, this.func_213311_cf() / 2.0f);
    }

    @Override
    public int getYNavSize() {
        return MathHelper.func_76123_f((float)this.func_213302_cg());
    }

    public void func_76316_a(IInventory invBasic) {
        if (!this.field_70170_p.field_72995_K) {
            this.updateAttributes();
        }
    }
}

