/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.github.alexthe666.iceandfire.entity.util.IDragonProjectile;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityDragonCharge
extends AbstractFireballEntity
implements IDragonProjectile {
    public EntityDragonCharge(EntityType<? extends AbstractFireballEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityDragonCharge(EntityType<? extends AbstractFireballEntity> type, World worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(type, posX, posY, posZ, accelX, accelY, accelZ, worldIn);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.07;
        this.field_70233_c = accelY / d0 * 0.07;
        this.field_70230_d = accelZ / d0 * 0.07;
    }

    public EntityDragonCharge(EntityType<? extends AbstractFireballEntity> type, World worldIn, EntityDragonBase shooter, double accelX, double accelY, double accelZ) {
        super(type, (LivingEntity)shooter, accelX, accelY, accelZ, worldIn);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.07;
        this.field_70233_c = accelY / d0 * 0.07;
        this.field_70230_d = accelZ / d0 * 0.07;
    }

    public void func_70071_h_() {
        Entity shootingEntity = this.func_234616_v_();
        if (this.field_70170_p.field_72995_K || (shootingEntity == null || shootingEntity.func_70089_S()) && this.field_70170_p.func_175667_e(this.func_233580_cy_())) {
            super.func_70030_z();
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::canHitMob);
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            this.func_145775_I();
            Vector3d vector3d = this.func_213322_ci();
            double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
            double d1 = this.func_226278_cu_() + vector3d.field_72448_b;
            double d2 = this.func_226281_cx_() + vector3d.field_72449_c;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float f = this.func_82341_c();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - this.func_213322_ci().field_72450_a * 0.25, this.func_226278_cu_() - this.func_213322_ci().field_72448_b * 0.25, this.func_226281_cx_() - this.func_213322_ci().field_72449_c * 0.25, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                }
                f = 0.8f;
            }
            this.func_213317_d(vector3d.func_72441_c(this.field_70232_b, this.field_70233_c, this.field_70230_d).func_186678_a((double)f));
            this.field_70170_p.func_195594_a(this.func_195057_f(), this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.func_70107_b(d0, d1, d2);
        } else {
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult movingObject) {
        Entity shootingEntity = this.func_234616_v_();
        if (!this.field_70170_p.field_72995_K) {
            if (movingObject.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityDragonBase dragon;
                Entity entity = ((EntityRayTraceResult)movingObject).func_216348_a();
                if (entity instanceof IDragonProjectile) {
                    return;
                }
                if (shootingEntity != null && shootingEntity instanceof EntityDragonBase && ((dragon = (EntityDragonBase)shootingEntity).func_184191_r(entity) || dragon.func_70028_i(entity) || dragon.isPart(entity))) {
                    return;
                }
                if (entity == null || !(entity instanceof IDragonProjectile) && entity != shootingEntity && shootingEntity instanceof EntityDragonBase) {
                    dragon = (EntityDragonBase)shootingEntity;
                    if (shootingEntity != null && (entity == shootingEntity || entity instanceof TameableEntity && ((EntityDragonBase)shootingEntity).func_152114_e(((EntityDragonBase)shootingEntity).func_70902_q()))) {
                        return;
                    }
                    if (dragon != null) {
                        dragon.randomizeAttacks();
                    }
                    this.func_70106_y();
                }
                if (entity != null && !(entity instanceof IDragonProjectile) && !entity.func_70028_i(shootingEntity)) {
                    if (shootingEntity != null && (entity.func_70028_i(shootingEntity) || shootingEntity instanceof EntityDragonBase & entity instanceof TameableEntity && ((EntityDragonBase)shootingEntity).func_70902_q() == ((TameableEntity)entity).func_70902_q())) {
                        return;
                    }
                    if (shootingEntity instanceof EntityDragonBase) {
                        float damageAmount = this.getDamage() * (float)((EntityDragonBase)shootingEntity).getDragonStage();
                        EntityDragonBase shootingDragon = (EntityDragonBase)shootingEntity;
                        EntityDragonBase cause = shootingDragon.getRidingPlayer() != null ? shootingDragon.getRidingPlayer() : shootingDragon;
                        DamageSource source = this.causeDamage((Entity)cause);
                        entity.func_70097_a(source, damageAmount);
                        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_110143_aJ() == 0.0f) {
                            ((EntityDragonBase)shootingEntity).randomizeAttacks();
                        }
                    }
                    if (shootingEntity instanceof LivingEntity) {
                        this.func_174815_a((LivingEntity)shootingEntity, entity);
                    }
                    this.func_70106_y();
                }
            }
            if (movingObject.func_216346_c() != RayTraceResult.Type.MISS) {
                if (shootingEntity instanceof EntityDragonBase && IafConfig.dragonGriefing != 2) {
                    this.destroyArea(this.field_70170_p, new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), (EntityDragonBase)shootingEntity);
                }
                this.func_70106_y();
            }
        }
    }

    public abstract DamageSource causeDamage(@Nullable Entity var1);

    public abstract void destroyArea(World var1, BlockPos var2, EntityDragonBase var3);

    public abstract float getDamage();

    public boolean func_70067_L() {
        return false;
    }

    protected boolean canHitMob(Entity hitMob) {
        Entity shooter = this.func_234616_v_();
        return hitMob != this && super.func_230298_a_(hitMob) && shooter != null && !hitMob.func_184191_r(shooter) && !(hitMob instanceof EntityDragonPart);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

