/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.DragonFireEvent;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonFireCharge;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonSyncFire;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityFireDragon
extends EntityDragonBase {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public static final ResourceLocation FEMALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/fire_dragon_female");
    public static final ResourceLocation MALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/fire_dragon_male");
    public static final ResourceLocation SKELETON_LOOT = new ResourceLocation("iceandfire", "entities/dragon/fire_dragon_skeleton");

    public EntityFireDragon(World worldIn) {
        this((EntityType)IafEntityRegistry.FIRE_DRAGON.get(), worldIn);
    }

    public EntityFireDragon(EntityType<?> t, World worldIn) {
        super(t, worldIn, DragonType.FIRE, 1.0, 1 + IafConfig.dragonAttackDamage, IafConfig.dragonHealth * 0.04, IafConfig.dragonHealth, 0.15f, 0.4f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)30);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
    }

    @Override
    protected boolean shouldTarget(Entity entity) {
        if (entity instanceof EntityDragonBase && !this.func_70909_n()) {
            return entity.func_200600_R() != this.func_200600_R() && this.func_213311_cf() >= entity.func_213311_cf() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof PlayerEntity || DragonUtils.isDragonTargetable(entity, IafTagRegistry.FIRE_DRAGON_TARGETS) || !this.func_70909_n() && DragonUtils.isVillager(entity);
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "red_";
            }
            case 1: {
                return "green_";
            }
            case 2: {
                return "bronze_";
            }
            case 3: 
        }
        return "gray_";
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return IafItemRegistry.DRAGONSCALES_RED;
            }
            case 1: {
                return IafItemRegistry.DRAGONSCALES_GREEN;
            }
            case 2: {
                return IafItemRegistry.DRAGONSCALES_BRONZE;
            }
            case 3: 
        }
        return IafItemRegistry.DRAGONSCALES_GRAY;
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return IafItemRegistry.DRAGONEGG_RED;
            }
            case 1: {
                return IafItemRegistry.DRAGONEGG_GREEN;
            }
            case 2: {
                return IafItemRegistry.DRAGONEGG_BRONZE;
            }
            case 3: 
        }
        return IafItemRegistry.DRAGONEGG_GRAY;
    }

    @Override
    public Item getSummoningCrystal() {
        return IafItemRegistry.SUMMONING_CRYSTAL_FIRE;
    }

    @Override
    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.func_70671_ap().func_75651_a(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.func_213303_ch().func_72441_c(0.0, (double)(this.func_213302_cg() / 2.0f), 0.0), entityIn.func_213303_ch().func_72441_c(0.0, (double)(entityIn.func_213302_cg() / 2.0f), 0.0)) && entityIn.func_213311_cf() < this.func_213311_cf() * 0.5f && this.func_184179_bs() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.func_184220_m((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        LivingEntity attackTarget = this.func_70638_az();
        if (!this.field_70170_p.field_72995_K && attackTarget != null) {
            if (this.func_174813_aQ().func_72314_b((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).func_72326_a(attackTarget.func_174813_aQ())) {
                this.func_70652_k((Entity)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.field_70122_E)) {
                this.shootFireAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.func_70068_e((Entity)attackTarget) < 100.0) {
                double difX = attackTarget.func_226277_ct_() - this.func_226277_ct_();
                double difY = attackTarget.func_226278_cu_() + (double)attackTarget.func_213302_cg() - this.func_226278_cu_();
                double difZ = attackTarget.func_226281_cx_() - this.func_226281_cx_();
                this.func_213317_d(this.func_213322_ci().func_72441_c(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.func_174813_aQ().func_72314_b((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).func_72326_a(attackTarget.func_174813_aQ())) {
                    this.func_70652_k((Entity)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.func_177958_n() + 0.5f, (float)burningTarget.func_177956_o() + 0.5f, (float)burningTarget.func_177952_p() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.func_70681_au().nextInt(5) == 0 && !this.func_70631_g_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.field_70177_z = this.field_70761_aq;
                Vector3d headVec = this.getHeadPosition();
                this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                float inaccuracy = 1.0f;
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType)IafEntityRegistry.FIRE_DRAGON_CHARGE.get(), this.field_70170_p, (EntityDragonBase)this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                if (this.func_70631_g_()) {
                    // empty if block
                }
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                RayTraceResult mop;
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    protected IItemProvider getHeartItem() {
        return IafItemRegistry.FIRE_DRAGON_HEART;
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(LivingEntity entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.func_70681_au().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 20) {
                    this.field_70177_z = this.field_70761_aq;
                    Vector3d headVec = this.getHeadPosition();
                    double d2 = entity.func_226277_ct_() - headVec.field_72450_a;
                    double d3 = entity.func_226278_cu_() - headVec.field_72448_b;
                    double d4 = entity.func_226281_cx_() - headVec.field_72449_c;
                    float inaccuracy = 1.0f;
                    this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType)IafEntityRegistry.FIRE_DRAGON_CHARGE.get(), this.field_70170_p, (EntityDragonBase)this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    if (this.func_70631_g_()) {
                        // empty if block
                    }
                    entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                    }
                    if (!entity.func_70089_S() || entity == null) {
                        this.setBreathingFire(false);
                    }
                    this.randomizeAttacks();
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.field_70177_z = this.field_70761_aq;
                    if (this.field_70173_aa % 5 == 0) {
                        this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 1);
                    if (!entity.func_70089_S() || entity == null) {
                        this.setBreathingFire(false);
                        this.randomizeAttacks();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireEvent(this, burnX, burnY, burnZ))) {
            return;
        }
        if (syncType == 1 && !this.field_70170_p.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 2 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 3 && !this.field_70170_p.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType == 4 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.field_70177_z = this.field_70761_aq;
                Vector3d headVec = this.getHeadPosition();
                double d2 = burnX - headVec.field_72450_a;
                double d3 = burnY - headVec.field_72448_b;
                double d4 = burnZ - headVec.field_72449_c;
                float inaccuracy = 1.0f;
                this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType)IafEntityRegistry.FIRE_DRAGON_CHARGE.get(), this.field_70170_p, (EntityDragonBase)this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                }
                this.randomizeAttacks();
            }
            return;
        }
        this.func_70661_as().func_75499_g();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vector3d headPos = this.getHeadPosition();
        double d2 = burnX - headPos.field_72450_a;
        double d3 = burnY - headPos.field_72448_b;
        double d4 = burnZ - headPos.field_72449_c;
        MathHelper.func_76131_a((float)(this.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f);
        double distance = Math.max(2.5 * this.func_70092_e(burnX, burnY, burnZ), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int particleCount = this.getDragonStage() <= 3 ? 6 : 3;
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.field_72450_a + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.field_72448_b + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.field_72449_c + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(particleCount) == 0) {
                    IceAndFire.PROXY.spawnDragonParticle(EnumParticles.DragonFire, headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, 0.0, 0.0, 0.0, this);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_()), new Vector3d(progressX, progressY, progressZ), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                BlockPos pos = new BlockPos(result.func_216347_e());
                IafDragonDestructionManager.destroyAreaFire(this.field_70170_p, pos, this);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            if (!this.field_70170_p.field_72995_K) {
                IafDragonDestructionManager.destroyAreaFire(this.field_70170_p, new BlockPos(spawnX, spawnY, spawnZ), this);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_IDLE : (this.func_230282_cS_() ? IafSoundRegistry.FIREDRAGON_ADULT_IDLE : IafSoundRegistry.FIREDRAGON_CHILD_IDLE);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_HURT : (this.func_230282_cS_() ? IafSoundRegistry.FIREDRAGON_ADULT_HURT : IafSoundRegistry.FIREDRAGON_CHILD_HURT);
    }

    protected SoundEvent func_184615_bR() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_DEATH : (this.func_230282_cS_() ? IafSoundRegistry.FIREDRAGON_ADULT_DEATH : IafSoundRegistry.FIREDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_ROAR : (this.func_230282_cS_() ? IafSoundRegistry.FIREDRAGON_ADULT_ROAR : IafSoundRegistry.FIREDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR, ANIMATION_EPIC_ROAR};
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == IafItemRegistry.FIRE_STEW;
    }

    @Override
    protected void spawnDeathParticles() {
        for (int k = 0; k < 3; ++k) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            if (!this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
        }
    }

    @Override
    protected void spawnBabyParticles() {
        for (int i = 0; i < 5; ++i) {
            float radiusAdd = (float)i * 0.15f;
            float headPosX = (float)(this.func_226277_ct_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * MathHelper.func_76134_b((float)((float)((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0)))));
            float headPosZ = (float)(this.func_226278_cu_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * MathHelper.func_76126_a((float)((float)((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0)))));
            float headPosY = (float)(this.func_226281_cx_() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected ItemStack getSkull() {
        return new ItemStack((IItemProvider)IafItemRegistry.DRAGON_SKULL_FIRE);
    }

    @Override
    protected Item getBloodItem() {
        return IafItemRegistry.FIRE_DRAGON_BLOOD;
    }
}

