/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockMyrmexConnectedResin;
import com.github.alexthe666.iceandfire.block.BlockMyrmexResin;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.IPassabilityNavigator;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathResult;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public abstract class EntityMyrmexBase
extends AnimalEntity
implements IAnimatedEntity,
IMerchant,
ICustomSizeNavigator,
IPassabilityNavigator,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_PUPA_WIGGLE = Animation.create((int)20);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityMyrmexBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> GROWTH_STAGE = EntityDataManager.func_187226_a(EntityMyrmexBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> VARIANT = EntityDataManager.func_187226_a(EntityMyrmexBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final ResourceLocation TEXTURE_DESERT_LARVA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_larva.png");
    private static final ResourceLocation TEXTURE_DESERT_PUPA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_pupa.png");
    private static final ResourceLocation TEXTURE_JUNGLE_LARVA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_larva.png");
    private static final ResourceLocation TEXTURE_JUNGLE_PUPA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_pupa.png");
    private final Inventory villagerInventory = new Inventory(8);
    public boolean isEnteringHive = false;
    public boolean isBeingGuarded = false;
    protected int growthTicks = 1;
    private int waitTicks = 0;
    @Nullable
    protected MerchantOffers offers;
    private int animationTick;
    private Animation currentAnimation;
    private MyrmexHive hive;
    private int timeUntilReset;
    private boolean leveledUp;
    @Nullable
    private PlayerEntity customer;

    public EntityMyrmexBase(EntityType<? extends EntityMyrmexBase> t, World worldIn) {
        super(t, worldIn);
        IHasCustomizableAttributes.applyAttributesForEntity(t, this);
        this.field_70138_W = 1.0f;
        this.field_70747_aH = 0.2f;
        this.field_70699_by = this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.CLIMBING);
    }

    private static boolean isJungleBiome(World world, BlockPos position) {
        return BiomeConfig.test(BiomeConfig.jungleMyrmexBiomes, world.func_226691_t_(position));
    }

    public static boolean haveSameHive(EntityMyrmexBase myrmex, Entity entity) {
        if (entity instanceof EntityMyrmexBase && myrmex.getHive() != null && ((EntityMyrmexBase)entity).getHive() != null && myrmex.isJungle() == ((EntityMyrmexBase)entity).isJungle()) {
            return myrmex.getHive().getCenter() == ((EntityMyrmexBase)entity).getHive().getCenter();
        }
        if (entity instanceof EntityMyrmexEgg) {
            return myrmex.isJungle() == ((EntityMyrmexEgg)entity).isJungle();
        }
        return false;
    }

    public static boolean isEdibleBlock(BlockState blockState) {
        return BlockTags.func_199896_a().func_199910_a(IafTagRegistry.MYRMEX_HARVESTABLES).func_230235_a_((Object)blockState.func_177230_c());
    }

    public static int getRandomCaste(World world, Random random, boolean royal) {
        float rand = random.nextFloat();
        if (royal) {
            if ((double)rand > 0.9) {
                return 2;
            }
            if ((double)rand > 0.75) {
                return 3;
            }
            if ((double)rand > 0.5) {
                return 1;
            }
            return 0;
        }
        if ((double)rand > 0.8) {
            return 3;
        }
        if ((double)rand > 0.6) {
            return 1;
        }
        return 0;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean canMove() {
        return this.getGrowthStage() > 1;
    }

    public boolean func_70631_g_() {
        return this.getGrowthStage() < 2;
    }

    protected void func_70619_bc() {
        if (!this.hasCustomer() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.leveledUp) {
                    this.levelUp();
                    this.leveledUp = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        if (this.getHive() != null && this.func_70931_l_() != null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)14);
            this.getHive().setWorld(this.field_70170_p);
        }
        super.func_70619_bc();
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.getCasteImportance() * 7 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (dmg == DamageSource.field_76368_d && this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getGrowthStage() < 2) {
            this.setAnimation(ANIMATION_PUPA_WIGGLE);
        }
        return super.func_70097_a(dmg, i);
    }

    protected float func_175134_bD() {
        return 0.52f;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockMyrmexResin ? 10.0f : super.func_180484_a(pos);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.CLIMBING);
    }

    protected PathNavigator createNavigator(World worldIn, AdvancedPathNavigate.MovementType type) {
        return this.createNavigator(worldIn, type, 1.0f, 1.0f);
    }

    protected PathNavigator createNavigator(World worldIn, AdvancedPathNavigate.MovementType type, float width, float height) {
        AdvancedPathNavigate newNavigator = new AdvancedPathNavigate((MobEntity)this, this.field_70170_p, type, width, height);
        this.field_70699_by = newNavigator;
        newNavigator.func_212239_d(true);
        newNavigator.func_189566_q().func_186321_b(true);
        return newNavigator;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(GROWTH_STAGE, (Object)2);
        this.field_70180_af.func_187214_a(VARIANT, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70138_W = 1.0f;
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (this.getGrowthStage() < 2 && this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityMyrmexBase) {
            float yaw;
            this.field_70177_z = yaw = this.func_184187_bx().field_70177_z;
            this.field_70759_as = yaw;
            this.field_70761_aq = 0.0f;
            this.field_70760_ar = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F && (this.func_233570_aj_() || !this.field_70124_G));
        }
        if (this.getGrowthStage() < 2) {
            ++this.growthTicks;
            if (this.growthTicks == IafConfig.myrmexLarvaTicks) {
                this.setGrowthStage(this.getGrowthStage() + 1);
                this.growthTicks = 0;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getGrowthStage() < 2 && this.func_70681_au().nextInt(150) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_PUPA_WIGGLE);
        }
        if (this.func_70638_az() != null && !(this.func_70638_az() instanceof PlayerEntity) && this.func_70661_as().func_75500_f()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && (EntityMyrmexBase.haveSameHive(this, (Entity)this.func_70638_az()) || this.func_70638_az() instanceof TameableEntity && !this.canAttackTamable((TameableEntity)this.func_70638_az()) || this.func_70638_az() instanceof PlayerEntity && this.getHive() != null && !this.getHive().isPlayerReputationLowEnoughToFight(this.func_70638_az().func_110124_au()))) {
            this.func_70624_b(null);
        }
        if (this.getWaitTicks() > 0) {
            this.setWaitTicks(this.getWaitTicks() - 1);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 500 == 0 && this.isOnResin()) {
            this.func_70691_i(1.0f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)76);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_213281_b(CompoundNBT tag) {
        MerchantOffers merchantoffers;
        super.func_213281_b(tag);
        tag.func_74768_a("GrowthStage", this.getGrowthStage());
        tag.func_74768_a("GrowthTicks", this.growthTicks);
        tag.func_74757_a("Variant", this.isJungle());
        if (this.getHive() != null) {
            tag.func_186854_a("HiveUUID", this.getHive().hiveUUID);
        }
        if (!(merchantoffers = this.func_213706_dY()).isEmpty()) {
            tag.func_218657_a("Offers", (INBT)merchantoffers.func_222199_a());
        }
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        tag.func_218657_a("Inventory", (INBT)listnbt);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setGrowthStage(tag.func_74762_e("GrowthStage"));
        this.growthTicks = tag.func_74762_e("GrowthTicks");
        this.setJungleVariant(tag.func_74767_n("Variant"));
        if (tag.func_186855_b("HiveUUID")) {
            this.setHive(MyrmexWorldData.get(this.field_70170_p).getHiveFromUUID(tag.func_186857_a("HiveUUID")));
        }
        if (tag.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(tag.func_74775_l("Offers"));
        }
        ListNBT listnbt = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.villagerInventory.func_174894_a(itemstack);
        }
    }

    public boolean canAttackTamable(TameableEntity tameable) {
        if (tameable.func_70902_q() != null && this.getHive() != null) {
            return this.getHive().isPlayerReputationLowEnoughToFight(tameable.func_184753_b());
        }
        return true;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos getPos() {
        return this.func_233580_cy_();
    }

    public int getGrowthStage() {
        return (Integer)this.field_70180_af.func_187225_a(GROWTH_STAGE);
    }

    public void setGrowthStage(int stage) {
        this.field_70180_af.func_187227_b(GROWTH_STAGE, (Object)stage);
    }

    public void setWaitTicks(int waitTicks) {
        this.waitTicks = waitTicks;
    }

    public int getWaitTicks() {
        return this.waitTicks;
    }

    public boolean isJungle() {
        return (Boolean)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setJungleVariant(boolean isJungle) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)isJungle);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70617_f_() {
        if (this.func_70661_as() instanceof AdvancedPathNavigate && ((AdvancedPathNavigate)this.func_70661_as()).entityOnAndBelowPath((Entity)this, new Vector3d(1.1, 0.0, 1.1))) {
            return true;
        }
        return super.func_70617_f_();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE};
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        if (this.getHive() == null || livingBase == null || livingBase instanceof PlayerEntity && this.getHive().isPlayerReputationLowEnoughToFight(livingBase.func_110124_au())) {
            super.func_70604_c(livingBase);
        }
        if (this.getHive() != null && livingBase != null) {
            this.getHive().addOrRenewAgressor(livingBase, this.getImportance());
        }
        if (this.getHive() != null && livingBase != null && livingBase instanceof PlayerEntity) {
            int i = -5 * this.getCasteImportance();
            this.getHive().setWorld(this.field_70170_p);
            this.getHive().modifyPlayerReputation(livingBase.func_110124_au(), i);
            if (this.func_70089_S()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)13);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        Entity entity;
        if (this.getHive() != null && (entity = cause.func_76346_g()) != null) {
            this.getHive().setWorld(this.field_70170_p);
            this.getHive().modifyPlayerReputation(entity.func_110124_au(), -15);
        }
        this.resetCustomer();
        super.func_70645_a(cause);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        boolean flag;
        boolean flag2;
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.shouldHaveNormalAI()) {
            return ActionResultType.PASS;
        }
        boolean bl = flag2 = itemstack.func_77973_b() == IafItemRegistry.MYRMEX_JUNGLE_STAFF || itemstack.func_77973_b() == IafItemRegistry.MYRMEX_DESERT_STAFF;
        if (flag2) {
            this.onStaffInteract(player, itemstack);
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        boolean bl2 = flag = itemstack.func_77973_b() == Items.field_151057_cb || itemstack.func_77973_b() == Items.field_151058_ca;
        if (flag) {
            return super.func_230254_b_(player, hand);
        }
        if (this.getGrowthStage() >= 2 && this.func_70089_S() && !this.func_70631_g_() && !player.func_225608_bj_()) {
            if (this.func_213706_dY().isEmpty()) {
                return super.func_230254_b_(player, hand);
            }
            if (!(this.field_70170_p.field_72995_K || this.func_70638_az() != null && this.func_70638_az().equals((Object)player) || hand != Hand.MAIN_HAND || this.getHive() == null || this.getHive().isPlayerReputationTooLowToTrade(player.func_110124_au()))) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void onStaffInteract(PlayerEntity player, ItemStack itemstack) {
        UUID staffUUID;
        if (itemstack.func_77978_p() == null) {
            return;
        }
        UUID uUID = staffUUID = itemstack.func_77978_p().func_186855_b("HiveUUID") ? itemstack.func_77978_p().func_186857_a("HiveUUID") : null;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!player.func_184812_l_() && this.getHive() != null && !this.getHive().canPlayerCommandHive(player.func_110124_au())) {
            return;
        }
        if (this.getHive() == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.null_hive"), true);
        } else if (staffUUID != null && staffUUID.equals(this.getHive().hiveUUID)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.staff_already_set"), true);
        } else {
            this.getHive().setWorld(this.field_70170_p);
            EntityMyrmexQueen queen = this.getHive().getQueen();
            BlockPos center = this.getHive().getCenterGround();
            if (queen != null && queen.func_145818_k_()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.staff_set_named", new Object[]{queen.func_200200_C_(), center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), true);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.staff_set_unnamed", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), true);
            }
            itemstack.func_77978_p().func_186854_a("HiveUUID", this.getHive().hiveUUID);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setHive(MyrmexWorldData.get(this.field_70170_p).getNearestHive(this.func_233580_cy_(), 400));
        if (this.getHive() != null) {
            this.setJungleVariant(EntityMyrmexBase.isJungleBiome(this.field_70170_p, this.getHive().getCenter()));
        } else {
            this.setJungleVariant(this.field_70146_Z.nextBoolean());
        }
        return spawnDataIn;
    }

    public abstract boolean shouldLeaveHive();

    public abstract boolean shouldEnterHive();

    public float func_213355_cm() {
        return this.getGrowthStage() == 0 ? 0.5f : (this.getGrowthStage() == 1 ? 0.75f : 1.0f);
    }

    public abstract ResourceLocation getAdultTexture();

    public abstract float getModelScale();

    public ResourceLocation getTexture() {
        if (this.getGrowthStage() == 0) {
            return this.isJungle() ? TEXTURE_JUNGLE_LARVA : TEXTURE_DESERT_LARVA;
        }
        if (this.getGrowthStage() == 1) {
            return this.isJungle() ? TEXTURE_JUNGLE_PUPA : TEXTURE_DESERT_PUPA;
        }
        return this.getAdultTexture();
    }

    public MyrmexHive getHive() {
        return this.hive;
    }

    public void setHive(MyrmexHive newHive) {
        this.hive = newHive;
        if (this.hive != null) {
            this.hive.addMyrmex(this);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!EntityMyrmexBase.haveSameHive(this, entityIn)) {
            entityIn.func_70108_f((Entity)this);
        }
    }

    public boolean canSeeSky() {
        return this.field_70170_p.func_175710_j(this.func_233580_cy_());
    }

    public boolean isOnResin() {
        double d0 = this.func_226278_cu_() - 1.0;
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), d0, this.func_226281_cx_());
        while (this.field_70170_p.func_175623_d(blockpos) && blockpos.func_177956_o() > 1) {
            blockpos = blockpos.func_177977_b();
        }
        BlockState BlockState2 = this.field_70170_p.func_180495_p(blockpos);
        return BlockState2.func_177230_c() instanceof BlockMyrmexResin || BlockState2.func_177230_c() instanceof BlockMyrmexConnectedResin;
    }

    public boolean isInNursery() {
        if (this.getHive() != null && this.getHive().getRooms(WorldGenMyrmexHive.RoomType.NURSERY).isEmpty() && this.getHive().getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_233580_cy_()) != null) {
            return false;
        }
        if (this.getHive() != null) {
            BlockPos nursery = this.getHive().getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_233580_cy_());
            return MathHelper.func_76133_a((double)this.func_70092_e(nursery.func_177958_n(), nursery.func_177956_o(), nursery.func_177952_p())) < 45.0f;
        }
        return false;
    }

    public boolean isInHive() {
        if (this.getHive() != null) {
            for (BlockPos pos : this.getHive().getAllRooms()) {
                if (!this.isCloseEnoughToTarget(MyrmexHive.getGroundedPos((IWorld)this.func_190670_t_(), pos), 50.0)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_213352_e(Vector3d motion) {
        if (!this.canMove()) {
            super.func_213352_e(Vector3d.field_186680_a);
            return;
        }
        super.func_213352_e(motion);
    }

    public int getImportance() {
        if (this.getGrowthStage() < 2) {
            return 1;
        }
        return this.getCasteImportance();
    }

    public abstract int getCasteImportance();

    public boolean needsGaurding() {
        return true;
    }

    public boolean shouldMoveThroughHive() {
        return true;
    }

    public boolean shouldWander() {
        return this.getHive() == null;
    }

    public void func_70103_a(byte id) {
        if (id == 76) {
            this.playVillagerEffect();
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.MYRMEX_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.MYRMEX_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.MYRMEX_DIE;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.func_184185_a(IafSoundRegistry.MYRMEX_WALK, 0.16f * this.getMyrmexPitch() * (this.func_70681_au().nextFloat() * 0.6f + 0.4f), 1.0f);
    }

    protected void playBiteSound() {
        this.func_184185_a(IafSoundRegistry.MYRMEX_BITE, 1.0f * this.getMyrmexPitch(), 1.0f);
    }

    protected void playStingSound() {
        this.func_184185_a(IafSoundRegistry.MYRMEX_STING, 1.0f * this.getMyrmexPitch(), 0.6f);
    }

    protected void playVillagerEffect() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    public float getMyrmexPitch() {
        return this.func_213311_cf();
    }

    public boolean shouldHaveNormalAI() {
        return true;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public AxisAlignedBB getAttackBounds() {
        float size = this.func_213355_cm() * 0.65f;
        return this.func_174813_aQ().func_72314_b((double)(1.0f + size), (double)(1.0f + size), (double)(1.0f + size));
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.customer = player;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213702_q(int xpIn) {
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.onVillagerTrade(offer);
    }

    protected void onVillagerTrade(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
        if (this.getHive() != null && this.func_70931_l_() != null) {
            this.getHive().setWorld(this.field_70170_p);
            this.getHive().modifyPlayerReputation(this.func_70931_l_().func_110124_au(), 1);
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.getVillagerYesNoSound(!stack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public SoundEvent func_213714_ea() {
        return IafSoundRegistry.MYRMEX_IDLE;
    }

    protected SoundEvent getVillagerYesNoSound(boolean getYesSound) {
        return IafSoundRegistry.MYRMEX_IDLE;
    }

    public void playCelebrateSound() {
    }

    protected void resetCustomer() {
        this.func_70932_a_(null);
    }

    @Nullable
    public Entity changeDimension(ServerWorld server, ITeleporter teleporter) {
        this.resetCustomer();
        return super.changeDimension(server, teleporter);
    }

    public Inventory getVillagerInventory() {
        return this.villagerInventory;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.villagerInventory.func_70302_i_()) {
            this.villagerInventory.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_70146_Z.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ITrade villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    private void levelUp() {
        this.populateTradeData();
    }

    protected abstract VillagerTrades.ITrade[] getLevel1Trades();

    protected abstract VillagerTrades.ITrade[] getLevel2Trades();

    protected void populateTradeData() {
        VillagerTrades.ITrade[] level1 = this.getLevel1Trades();
        VillagerTrades.ITrade[] level2 = this.getLevel2Trades();
        if (level1 != null && level2 != null) {
            MerchantOffer merchantoffer3;
            MerchantOffer merchantoffer2;
            int rolls;
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.addTrades(merchantoffers, level1, 5);
            int i = this.field_70146_Z.nextInt(level2.length);
            int j = this.field_70146_Z.nextInt(level2.length);
            int k = this.field_70146_Z.nextInt(level2.length);
            for (rolls = 0; j == i && rolls < 100; ++rolls) {
                j = this.field_70146_Z.nextInt(level2.length);
            }
            for (rolls = 0; (k == i || k == j) && rolls < 100; ++rolls) {
                k = this.field_70146_Z.nextInt(level2.length);
            }
            VillagerTrades.ITrade rareTrade1 = level2[i];
            VillagerTrades.ITrade rareTrade2 = level2[j];
            VillagerTrades.ITrade rareTrade3 = level2[k];
            MerchantOffer merchantoffer1 = rareTrade1.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer1 != null) {
                merchantoffers.add((Object)merchantoffer1);
            }
            if ((merchantoffer2 = rareTrade2.func_221182_a((Entity)this, this.field_70146_Z)) != null) {
                merchantoffers.add((Object)merchantoffer2);
            }
            if ((merchantoffer3 = rareTrade3.func_221182_a((Entity)this, this.field_70146_Z)) != null) {
                merchantoffers.add((Object)merchantoffer3);
            }
        }
    }

    public boolean isCloseEnoughToTarget(BlockPos target, double distanceSquared) {
        if (target != null) {
            return this.func_70092_e((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5) <= distanceSquared;
        }
        return false;
    }

    public boolean pathReachesTarget(PathResult path, BlockPos target, double distanceSquared) {
        return !path.failedToReachDestination() && (this.isCloseEnoughToTarget(target, distanceSquared) || this.func_70661_as().func_75505_d() == null || !this.func_70661_as().func_75505_d().func_75879_b());
    }

    @Override
    public boolean isSmallerThanBlock() {
        return false;
    }

    @Override
    public float getXZNavSize() {
        return this.func_213311_cf() / 2.0f;
    }

    @Override
    public int getYNavSize() {
        return (int)this.func_213302_cg() / 2;
    }

    @Override
    public int maxSearchNodes() {
        return IafConfig.maxDragonPathingNodes;
    }

    @Override
    public boolean isBlockExplicitlyPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return false;
    }

    @Override
    public boolean isBlockExplicitlyNotPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return state.func_185904_a() == Material.field_151584_j;
    }
}

