/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIAttackMeleeNoCooldown;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIFollowSummoner;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAISummonerHurtByTarget;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAISummonerHurtTarget;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityMyrmexSwarmer
extends EntityMyrmexRoyal {
    private static final DataParameter<Optional<UUID>> SUMMONER_ID = EntityDataManager.func_187226_a(EntityMyrmexSwarmer.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> TICKS_ALIVE = EntityDataManager.func_187226_a(EntityMyrmexSwarmer.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityMyrmexSwarmer(EntityType type, World worldIn) {
        super((EntityType<EntityMyrmexRoyal>)type, worldIn);
        this.field_70765_h = new EntityMyrmexRoyal.FlyMoveHelper(this);
        this.field_70699_by = this.createNavigator(this.field_70170_p, AdvancedPathNavigate.MovementType.FLYING);
        this.switchNavigator(false);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    @Override
    protected void switchNavigator(boolean onLand) {
    }

    @Override
    protected double attackDistance() {
        return 25.0;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MyrmexAIFollowSummoner(this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new EntityMyrmexRoyal.AIFlyAtTarget());
        this.field_70714_bg.func_75776_a(3, (Goal)new EntityMyrmexRoyal.AIFlyRandom());
        this.field_70714_bg.func_75776_a(4, (Goal)new EntityAIAttackMeleeNoCooldown((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new MyrmexAISummonerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new MyrmexAISummonerHurtTarget(this));
    }

    @Override
    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof EntityMyrmexSwarmer) {
            super.func_82167_n(entityIn);
        }
    }

    @Override
    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMONER_ID, Optional.empty());
        this.field_70180_af.func_187214_a(TICKS_ALIVE, (Object)0);
    }

    @Nullable
    public LivingEntity getSummoner() {
        try {
            UUID uuid = this.getSummonerUUID();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (this.getSummonerUUID() == null || entityIn instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)entityIn).getSummonerUUID() == null) {
            return false;
        }
        if (entityIn instanceof TameableEntity) {
            UUID ownerID = ((TameableEntity)entityIn).func_184753_b();
            return ownerID != null && ownerID.equals(this.getSummonerUUID());
        }
        return entityIn.func_110124_au().equals(this.getSummonerUUID()) || entityIn instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)entityIn).getSummonerUUID() != null && ((EntityMyrmexSwarmer)entityIn).getSummonerUUID().equals(this.getSummonerUUID());
    }

    public void setSummonerID(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(SUMMONER_ID, Optional.ofNullable(uuid));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getSummonerUUID() == null) {
            compound.func_74778_a("SummonerUUID", "");
        } else {
            compound.func_74778_a("SummonerUUID", this.getSummonerUUID().toString());
        }
        compound.func_74768_a("SummonTicks", this.getTicksAlive());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        String s = "";
        if (compound.func_186855_b("SummonerUUID")) {
            s = compound.func_74779_i("SummonerUUID");
        }
        if (!s.isEmpty()) {
            try {
                this.setSummonerID(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setTicksAlive(compound.func_74762_e("SummonTicks"));
    }

    public void setSummonedBy(PlayerEntity player) {
        this.setSummonerID(player.func_110124_au());
    }

    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(SUMMONER_ID)).orElse(null);
    }

    public int getTicksAlive() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_ALIVE);
    }

    public void setTicksAlive(int ticks) {
        this.field_70180_af.func_187227_b(TICKS_ALIVE, (Object)ticks);
    }

    @Override
    public void func_70636_d() {
        double dist;
        super.func_70636_d();
        this.setFlying(true);
        boolean flying = this.isFlying() && !this.field_70122_E;
        this.setTicksAlive(this.getTicksAlive() + 1);
        if (flying) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.08, 0.0));
            if (this.field_70765_h.func_179919_e() > this.func_226278_cu_()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.08, 0.0));
            }
        }
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.2, 0.0));
        }
        if (this.func_70638_az() != null) {
            this.field_70765_h.func_75642_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().func_226281_cx_(), 1.0);
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_BITE : ANIMATION_STING);
            }
        }
        if (this.getTicksAlive() > 1800) {
            this.func_174812_G();
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < this.attackDistance()) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playStingSound();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < this.attackDistance()) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 2));
                this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76436_u, 70, 1));
            }
        }
    }

    @Override
    public int getGrowthStage() {
        return 2;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public float getModelScale() {
        return 0.25f;
    }

    @Override
    public boolean shouldHaveNormalAI() {
        return false;
    }

    @Override
    public int getCasteImportance() {
        return 0;
    }

    @Override
    public boolean isBreedingSeason() {
        return false;
    }

    public boolean shouldAttackEntity(LivingEntity attacker, LivingEntity LivingEntity2) {
        return !this.func_184191_r((Entity)attacker);
    }
}

