/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.TrollAIFleeSun;
import com.github.alexthe666.iceandfire.entity.util.BlockBreakExplosion;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityTroll
extends MonsterEntity
implements IAnimatedEntity,
IVillagerFear,
IHumanoid,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_STRIKE_HORIZONTAL = Animation.create((int)20);
    public static final Animation ANIMATION_STRIKE_VERTICAL = Animation.create((int)20);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_ROAR = Animation.create((int)25);
    public static final ResourceLocation FOREST_LOOT = new ResourceLocation("iceandfire", "entities/troll_forest");
    public static final ResourceLocation FROST_LOOT = new ResourceLocation("iceandfire", "entities/troll_frost");
    public static final ResourceLocation MOUNTAIN_LOOT = new ResourceLocation("iceandfire", "entities/troll_mountain");
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityTroll.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WEAPON = EntityDataManager.func_187226_a(EntityTroll.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float stoneProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean avoidSun = true;

    public EntityTroll(EntityType<EntityTroll> t, World worldIn) {
        super(t, worldIn);
        IHasCustomizableAttributes.applyAttributesForEntity(t, this);
    }

    public static boolean canTrollSpawnOn(EntityType<? extends MobEntity> typeIn, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && EntityTroll.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityTroll.func_223315_a((EntityType)((EntityType)IafEntityRegistry.TROLL.get()), (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.trollMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, IafConfig.trollAttackStrength).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233826_i_, 9.0);
    }

    @Override
    public AttributeModifierMap.MutableAttribute getAttributes() {
        return EntityTroll.bakeAttributes();
    }

    private void setAvoidSun(boolean day) {
        if (day && !this.avoidSun) {
            ((GroundPathNavigator)this.func_70661_as()).func_179685_e(true);
            this.avoidSun = true;
        }
        if (!day && this.avoidSun) {
            ((GroundPathNavigator)this.func_70661_as()).func_179685_e(false);
            this.avoidSun = false;
        }
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        BlockPos pos = this.func_233580_cy_();
        BlockPos heightAt = worldIn.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos);
        boolean rngCheck = true;
        if (IafConfig.trollSpawnCheckChance > 0) {
            boolean bl = rngCheck = this.func_70681_au().nextInt(IafConfig.trollSpawnCheckChance) == 0;
        }
        if (worldIn instanceof IServerWorld && !IafWorldRegistry.isDimensionListedForMobs((IServerWorld)this.field_70170_p)) {
            return false;
        }
        return rngCheck && pos.func_177956_o() < heightAt.func_177956_o() - 10 && super.func_213380_a(worldIn, spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new TrollAIFleeSun(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.setAvoidSun(true);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_70681_au().nextBoolean()) {
            this.setAnimation(ANIMATION_STRIKE_VERTICAL);
        } else {
            this.setAnimation(ANIMATION_STRIKE_HORIZONTAL);
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(WEAPON, (Object)0);
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public EnumTroll getTrollType() {
        return EnumTroll.values()[this.getVariant()];
    }

    public void setTrollType(EnumTroll variant) {
        this.setVariant(variant.ordinal());
    }

    private int getWeapon() {
        return (Integer)this.field_70180_af.func_187225_a(WEAPON);
    }

    private void setWeapon(int variant) {
        this.field_70180_af.func_187227_b(WEAPON, (Object)variant);
    }

    public EnumTroll.Weapon getWeaponType() {
        return EnumTroll.Weapon.values()[this.getWeapon()];
    }

    public void setWeaponType(EnumTroll.Weapon variant) {
        this.setWeapon(variant.ordinal());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("Weapon", this.getWeapon());
        compound.func_74776_a("StoneProgress", this.stoneProgress);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setWeapon(compound.func_74762_e("Weapon"));
        this.stoneProgress = compound.func_74760_g("StoneProgress");
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setTrollType(EnumTroll.getBiomeType(this.field_70170_p.func_226691_t_(this.func_233580_cy_())));
        this.setWeaponType(EnumTroll.getWeaponForType(this.getTrollType()));
        return spawnDataIn;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76355_l().contains("arrow")) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getTrollType()) {
            case MOUNTAIN: {
                return MOUNTAIN_LOOT;
            }
            case FROST: {
                return FROST_LOOT;
            }
            case FOREST: {
                return FOREST_LOOT;
            }
        }
        return null;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 15;
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 20 && !this.field_70170_p.field_72995_K && IafConfig.trollsDropWeapon) {
            if (this.func_70681_au().nextInt(3) == 0) {
                ItemStack weaponStack = new ItemStack((IItemProvider)this.getWeaponType().item, 1);
                weaponStack.func_96631_a(this.func_70681_au().nextInt(250), this.func_70681_au(), null);
                this.dropItemAt(weaponStack, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            } else {
                ItemStack brokenDrop = new ItemStack((IItemProvider)Blocks.field_196696_di, this.func_70681_au().nextInt(2) + 1);
                ItemStack brokenDrop2 = new ItemStack((IItemProvider)Blocks.field_196696_di, this.func_70681_au().nextInt(2) + 1);
                if (this.getWeaponType() == EnumTroll.Weapon.AXE) {
                    brokenDrop = new ItemStack((IItemProvider)Items.field_151055_y, this.func_70681_au().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((IItemProvider)Blocks.field_150347_e, this.func_70681_au().nextInt(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN) {
                    brokenDrop = new ItemStack((IItemProvider)Blocks.field_196696_di, this.func_70681_au().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((IItemProvider)Blocks.field_196696_di, this.func_70681_au().nextInt(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN_FOREST) {
                    brokenDrop = new ItemStack((IItemProvider)Blocks.field_196696_di, this.func_70681_au().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((IItemProvider)Blocks.field_196696_di, this.func_70681_au().nextInt(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN_FROST) {
                    brokenDrop = new ItemStack((IItemProvider)Blocks.field_196696_di, this.func_70681_au().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((IItemProvider)Items.field_151126_ay, this.func_70681_au().nextInt(4) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.HAMMER) {
                    brokenDrop = new ItemStack((IItemProvider)Items.field_151103_aS, this.func_70681_au().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((IItemProvider)Blocks.field_150347_e, this.func_70681_au().nextInt(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.TRUNK) {
                    brokenDrop = new ItemStack((IItemProvider)Blocks.field_196617_K, this.func_70681_au().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((IItemProvider)Blocks.field_196617_K, this.func_70681_au().nextInt(2) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.TRUNK_FROST) {
                    brokenDrop = new ItemStack((IItemProvider)Blocks.field_196618_L, this.func_70681_au().nextInt(4) + 1);
                    brokenDrop2 = new ItemStack((IItemProvider)Items.field_151126_ay, this.func_70681_au().nextInt(4) + 1);
                }
                this.dropItemAt(brokenDrop, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.dropItemAt(brokenDrop2, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            }
        }
    }

    @Nullable
    private ItemEntity dropItemAt(ItemStack stack, double x, double y, double z) {
        if (stack.func_190916_E() > 0) {
            ItemEntity entityitem = new ItemEntity(this.field_70170_p, x, y, z, stack);
            entityitem.func_174869_p();
            this.field_70170_p.func_217376_c((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public void func_70636_d() {
        float weaponX;
        boolean stone;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if ((stone = EntityGorgon.isStoneMob((LivingEntity)this)) && this.stoneProgress < 20.0f) {
            this.stoneProgress += 2.0f;
        } else if (!stone && this.stoneProgress > 0.0f) {
            this.stoneProgress -= 2.0f;
        }
        if (!stone && this.getAnimation() == NO_ANIMATION && this.func_70638_az() != null && this.func_70681_au().nextInt(100) == 0) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.TROLL_ROAR, 1.0f, 1.0f);
        }
        if (!stone && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 30, 1, false, false));
        }
        this.setAvoidSun(this.field_70170_p.func_72935_r());
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof BoatEntity ? new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_()).func_177984_a() : new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_());
            if (f > 0.5f && this.field_70170_p.func_226660_f_(blockpos)) {
                this.func_213293_j(0.0, 0.0, 0.0);
                this.setAnimation(NO_ANIMATION);
                this.func_184185_a(IafSoundRegistry.TURN_STONE, 1.0f, 1.0f);
                this.stoneProgress = 20.0f;
                EntityStoneStatue statue = EntityStoneStatue.buildStatueEntity((LivingEntity)this);
                statue.getTrappedTag().func_74776_a("StoneProgress", 20.0f);
                statue.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)statue);
                }
                statue.field_70126_B = this.field_70177_z;
                statue.field_70177_z = this.field_70177_z;
                statue.field_70759_as = this.field_70177_z;
                statue.field_70761_aq = this.field_70177_z;
                statue.field_70760_ar = this.field_70177_z;
                this.func_70106_y();
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            weaponX = (float)(this.func_226277_ct_() + (double)(1.9f * MathHelper.func_76134_b((float)((float)((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0)))));
            float weaponZ = (float)(this.func_226281_cx_() + (double)(1.9f * MathHelper.func_76126_a((float)((float)((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0)))));
            float weaponY = (float)(this.func_226278_cu_() + (double)0.2f);
            BlockState state = this.field_70170_p.func_180495_p(new BlockPos((double)weaponX, (double)(weaponY - 1.0f), (double)weaponZ));
            for (int i = 0; i < 20; ++i) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                if (!state.func_185904_a().func_76220_a() || !this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), (double)(weaponX + (this.func_70681_au().nextFloat() - 0.5f)), (double)(weaponY + (this.func_70681_au().nextFloat() - 0.5f)), (double)(weaponZ + (this.func_70681_au().nextFloat() - 0.5f)), motionX, motionY, motionZ);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.getAnimationTick() == 10 && this.field_70725_aQ <= 0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.getAnimationTick() == 10 && this.field_70725_aQ <= 0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
            float f1 = 0.5f;
            float f2 = this.func_70638_az().field_191988_bg;
            float f3 = 0.6f;
            float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f1 / f4;
            float f5 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
            float f8 = f3 * f6 + f2 * f5;
            this.func_70638_az().func_213293_j((double)f5, (double)f6, (double)0.4f);
        }
        if (this.func_70661_as().func_75500_f() && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 3.0 && this.func_70068_e((Entity)this.func_70638_az()) < 30.0 && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            if (this.getAnimation() == NO_ANIMATION && this.field_70146_Z.nextInt(15) == 0) {
                this.setAnimation(ANIMATION_STRIKE_VERTICAL);
            }
            if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
                weaponX = (float)(this.func_226277_ct_() + (double)(1.9f * MathHelper.func_76134_b((float)((float)((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0)))));
                float weaponZ = (float)(this.func_226281_cx_() + (double)(1.9f * MathHelper.func_76126_a((float)((float)((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0)))));
                float weaponY = (float)(this.func_226278_cu_() + (double)(this.func_70047_e() / 2.0f));
                BlockBreakExplosion explosion = new BlockBreakExplosion(this.field_70170_p, (MobEntity)this, weaponX, weaponY, weaponZ, 1.0f + this.func_70681_au().nextFloat());
                if (!MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, weaponX, weaponY, weaponZ))) {
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
                this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            this.func_184185_a(SoundEvents.field_187730_dW, 2.5f, 0.5f);
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.getAnimationTick() == 10) {
            this.func_184185_a(SoundEvents.field_187730_dW, 2.5f, 0.5f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.TROLL_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.TROLL_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.TROLL_DIE;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_STRIKE_HORIZONTAL, ANIMATION_STRIKE_VERTICAL, ANIMATION_SPEAK, ANIMATION_ROAR};
    }
}

