/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.world.gen.processor.VillageHouseProcessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="iceandfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IafVillagerRegistry {
    private static final String[] VILLAGE_TYPES = new String[]{"plains", "desert", "snowy", "savanna", "taiga"};
    private static final StructureProcessorList HOUSE_PROCESSOR = (StructureProcessorList)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243655_g, (ResourceLocation)new ResourceLocation("iceandfire:village_house_processor"), (Object)IafVillagerRegistry.genVillageHouseProcessor());
    public static PointOfInterestType LECTERN_POI;
    public static VillagerProfession SCRIBE;

    private static StructureProcessorList genVillageHouseProcessor() {
        RuleStructureProcessor mossify = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P())));
        return new StructureProcessorList((List)ImmutableList.of((Object)mossify, (Object)((Object)new VillageHouseProcessor())));
    }

    public static void setup() {
        if (IafConfig.villagerHouseWeight > 0) {
            PlainsVillagePools.func_214744_a();
            SnowyVillagePools.func_214746_a();
            SavannaVillagePools.func_214745_a();
            DesertVillagePools.func_222739_a();
            TaigaVillagePools.func_214806_a();
            for (String type : VILLAGE_TYPES) {
                IafVillagerRegistry.addStructureToPool(new ResourceLocation("village/" + type + "/houses"), new ResourceLocation("village/" + type + "/terminators"), new ResourceLocation("iceandfire", "village/" + type + "_scriber_1"), IafConfig.villagerHouseWeight);
            }
        }
    }

    private static JigsawPiece createWorkstation(String name) {
        return new LegacySingleJigsawPiece(Either.left((Object)new ResourceLocation("iceandfire", name)), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID);
    }

    @SubscribeEvent
    public static void registerPointOfInterests(RegistryEvent.Register<PointOfInterestType> event) {
        LECTERN_POI = (PointOfInterestType)new PointOfInterestType("scribe", (Set)ImmutableSet.copyOf((Collection)IafBlockRegistry.LECTERN.func_176194_O().func_177619_a()), 1, 1).setRegistryName("iceandfire", "scribe");
        event.getRegistry().register((IForgeRegistryEntry)LECTERN_POI);
        PointOfInterestType.func_221052_a((PointOfInterestType)LECTERN_POI);
    }

    @SubscribeEvent
    public static void registerVillagerProfessions(RegistryEvent.Register<VillagerProfession> event) {
        SCRIBE = (VillagerProfession)new VillagerProfession("scribe", LECTERN_POI, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219702_mJ).setRegistryName("iceandfire", "scribe");
        event.getRegistry().register((IForgeRegistryEntry)SCRIBE);
    }

    public static void addScribeTrades(Int2ObjectMap<List<VillagerTrades.ITrade>> trades) {
        float emeraldForItemsMultiplier = 0.05f;
        float itemForEmeraldMultiplier = 0.05f;
        float rareItemForEmeraldMultiplier = 0.2f;
        ((List)trades.get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)IafItemRegistry.MANUSCRIPT, 4), 25, 2, 0.05f));
        ((List)trades.get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_221651_bN, 3), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 8, 3, 0.05f));
        ((List)trades.get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151121_aF, 15), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 4, 4, 0.05f));
        ((List)trades.get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafBlockRegistry.ASH, 10), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 8, 4, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.SILVER_INGOT, 5), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 3, 5, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafBlockRegistry.FIRE_LILY, 8), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 3, 5, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafBlockRegistry.LIGHTNING_LILY, 7), new ItemStack((IItemProvider)Items.field_151166_bC, 3), 2, 5, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 3), new ItemStack((IItemProvider)IafBlockRegistry.FROST_LILY, 4), 3, 3, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 2), new ItemStack((IItemProvider)IafBlockRegistry.DRAGON_ICE_SPIKES, 7), 2, 3, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.SAPPHIRE_GEM), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 30, 3, 0.2f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 2), new ItemStack((IItemProvider)IafBlockRegistry.JAR_EMPTY, 1), 3, 4, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 2), new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN, 1), 40, 2, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 2), new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_RESIN, 1), 40, 2, 0.05f));
        ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.AMYTHEST_GEM), new ItemStack((IItemProvider)Items.field_151166_bC, 3), 20, 3, 0.2f));
        ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE, 6), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 7, 4, 0.05f));
        ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.CHAIN, 2), new ItemStack((IItemProvider)Items.field_151166_bC, 3), 4, 2, 0.05f));
        ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 6), new ItemStack((IItemProvider)IafItemRegistry.PIXIE_DUST, 2), 8, 3, 0.05f));
        ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 6), new ItemStack((IItemProvider)IafItemRegistry.FIRE_DRAGON_FLESH, 2), 8, 3, 0.05f));
        ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 7), new ItemStack((IItemProvider)IafItemRegistry.ICE_DRAGON_FLESH, 1), 8, 3, 0.05f));
        ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 8), new ItemStack((IItemProvider)IafItemRegistry.LIGHTNING_DRAGON_FLESH, 1), 8, 3, 0.05f));
        ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 10), new ItemStack((IItemProvider)IafItemRegistry.DRAGON_BONE, 2), 20, 5, 0.05f));
        ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 4), new ItemStack((IItemProvider)IafItemRegistry.SHINY_SCALES, 1), 5, 2, 0.05f));
        ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.DREAD_SHARD, 5), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 10, 4, 0.05f));
        ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 8), new ItemStack((IItemProvider)IafItemRegistry.STYMPHALIAN_BIRD_FEATHER, 12), 3, 6, 0.05f));
        ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 4), new ItemStack((IItemProvider)IafItemRegistry.TROLL_TUSK, 12), 7, 3, 0.05f));
        ((List)trades.get(5)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 15), new ItemStack((IItemProvider)IafItemRegistry.SERPENT_FANG, 3), 20, 3, 0.05f));
        ((List)trades.get(5)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 12), new ItemStack((IItemProvider)IafItemRegistry.HYDRA_FANG, 1), 20, 3, 0.05f));
        ((List)trades.get(5)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.ECTOPLASM, 6), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 7, 3, 0.05f));
    }

    private static void addStructureToPool(ResourceLocation pool, ResourceLocation terminatorPool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        ImmutableList shuffled = old != null ? old.func_214943_b(new Random()) : ImmutableList.of();
        List newPieces = shuffled.stream().map(p -> new Pair(p, (Object)1)).collect(Collectors.toList());
        newPieces.add(new Pair((Object)new LegacySingleJigsawPiece(Either.left((Object)toAdd), () -> HOUSE_PROCESSOR, JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(pool, terminatorPool, newPieces));
    }
}

