/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.util.IAFMath;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Items;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class CockatriceAITargetItems<T extends ItemEntity>
extends TargetGoal {
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected ItemEntity targetEntity;
    @Nonnull
    private List<ItemEntity> list = IAFMath.emptyItemEntityList;

    public CockatriceAITargetItems(EntityCockatrice creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public CockatriceAITargetItems(EntityCockatrice creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 0, checkSight, onlyNearby, null);
    }

    public CockatriceAITargetItems(EntityCockatrice creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super((MobEntity)creature, checkSight, onlyNearby);
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            @Override
            public boolean test(ItemEntity item) {
                return item != null && !item.func_92059_d().func_190926_b() && (item.func_92059_d().func_77973_b() == Items.field_151078_bh || FoodUtils.isSeeds(item.func_92059_d()));
            }
        };
    }

    public boolean func_75250_a() {
        if (!((EntityCockatrice)this.field_75299_d).canMove() || this.field_75299_d.func_110143_aJ() >= this.field_75299_d.func_110138_aP()) {
            this.list = IAFMath.emptyItemEntityList;
            return false;
        }
        if (this.field_75299_d.field_70170_p.func_82737_E() % 4L == 0L) {
            this.list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        }
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
        } else if (this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.0) {
            EntityCockatrice cockatrice = (EntityCockatrice)this.field_75299_d;
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            cockatrice.func_70691_i(8.0f);
            cockatrice.setAnimation(EntityCockatrice.ANIMATION_EAT);
            this.func_75251_c();
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }
}

