/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class DeathwormAITargetItems<T extends ItemEntity>
extends TargetGoal {
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected ItemEntity targetEntity;
    private final EntityDeathWorm worm;

    public DeathwormAITargetItems(EntityDeathWorm creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public DeathwormAITargetItems(EntityDeathWorm creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 0, checkSight, onlyNearby, null);
    }

    public DeathwormAITargetItems(EntityDeathWorm creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super((MobEntity)creature, checkSight, onlyNearby);
        this.worm = creature;
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            @Override
            public boolean test(ItemEntity item) {
                return item != null && !item.func_92059_d().func_190926_b() && item.func_92059_d().func_77973_b() == Blocks.field_150335_W.func_199767_j() && item.field_70170_p.func_180495_p(item.func_233580_cy_().func_177977_b()).func_185904_a() == Material.field_151595_p;
            }
        };
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        List list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = (ItemEntity)list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        super.func_75249_e();
    }

    public boolean func_75253_b() {
        ItemEntity itemTarget = this.targetEntity;
        if (itemTarget == null) {
            return false;
        }
        if (!itemTarget.func_70089_S()) {
            return false;
        }
        Team team = this.field_75299_d.func_96124_cp();
        Team team1 = itemTarget.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.func_111175_f();
        return !(this.field_75299_d.func_70068_e((Entity)itemTarget) > d0 * d0);
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
        } else if (this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.0) {
            EntityDeathWorm deathWorm = (EntityDeathWorm)this.field_75299_d;
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            deathWorm.setAnimation(EntityDeathWorm.ANIMATION_BITE);
            PlayerEntity thrower = null;
            if (this.targetEntity.func_200214_m() != null) {
                thrower = this.targetEntity.field_70170_p.func_217371_b(this.targetEntity.func_200214_m());
            }
            deathWorm.setExplosive(true, thrower);
            this.func_75251_c();
        }
        if (this.worm.func_70661_as().func_75500_f()) {
            this.worm.func_70661_as().func_75497_a((Entity)this.targetEntity, 1.0);
        }
    }
}

