/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Hand;

public class DragonAIAttackMelee
extends Goal {
    protected EntityDragonBase dragon;
    private int attackTick;
    private boolean longMemory;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private double speedTowardsTarget;

    public DragonAIAttackMelee(EntityDragonBase dragon, double speedIn, boolean useLongMemory) {
        this.dragon = dragon;
        this.longMemory = useLongMemory;
        this.speedTowardsTarget = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        LivingEntity livingEntity = this.dragon.func_70638_az();
        if (!(this.dragon.func_70661_as() instanceof AdvancedPathNavigate)) {
            return false;
        }
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.func_70089_S()) {
            return false;
        }
        if (!this.dragon.canMove() || this.dragon.isHovering() || this.dragon.isFlying()) {
            return false;
        }
        ((AdvancedPathNavigate)this.dragon.func_70661_as()).moveToLivingEntity((Entity)livingEntity, this.speedTowardsTarget);
        return true;
    }

    public boolean func_75253_b() {
        if (!(this.dragon.func_70661_as() instanceof AdvancedPathNavigate)) {
            return false;
        }
        LivingEntity livingEntity = this.dragon.func_70638_az();
        if (livingEntity != null && !livingEntity.func_70089_S()) {
            this.func_75251_c();
            return false;
        }
        return livingEntity != null && livingEntity.func_70089_S() && !this.dragon.isFlying() && !this.dragon.isHovering();
    }

    public void func_75249_e() {
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        LivingEntity LivingEntity2 = this.dragon.func_70638_az();
        if (LivingEntity2 instanceof PlayerEntity && (LivingEntity2.func_175149_v() || ((PlayerEntity)LivingEntity2).func_184812_l_())) {
            this.dragon.func_70624_b(null);
        }
        this.dragon.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity entity = this.dragon.func_70638_az();
        if (this.delayCounter > 0) {
            --this.delayCounter;
        }
        if (entity != null) {
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                this.func_75251_c();
                return;
            }
            ((AdvancedPathNavigate)this.dragon.func_70661_as()).moveToLivingEntity((Entity)entity, this.speedTowardsTarget);
            double d0 = this.dragon.func_70092_e(entity.func_226277_ct_(), entity.func_174813_aQ().field_72338_b, entity.func_226281_cx_());
            double d1 = this.getAttackReachSqr(entity);
            --this.delayCounter;
            if ((this.longMemory || this.dragon.func_70635_at().func_75522_a((Entity)entity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entity.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.dragon.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = entity.func_226277_ct_();
                this.targetY = entity.func_174813_aQ().field_72338_b;
                this.targetZ = entity.func_226281_cx_();
                this.delayCounter = 4 + this.dragon.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.dragon.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.dragon.func_70661_as().func_75505_d().func_75870_c()) != null && entity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (this.dragon.canMove()) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (d0 <= d1 && this.attackTick <= 0) {
                this.attackTick = 20;
                this.dragon.func_184609_a(Hand.MAIN_HAND);
                this.dragon.func_70652_k((Entity)entity);
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.dragon.func_213311_cf() * 2.0f * this.dragon.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
    }
}

