/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DragonAIMate
extends Goal {
    private static final BlockState NEST = IafBlockRegistry.NEST.func_176223_P();
    private final EntityDragonBase dragon;
    World theWorld;
    int spawnBabyDelay;
    double moveSpeed;
    private EntityDragonBase targetMate;

    public DragonAIMate(EntityDragonBase dragon, double speedIn) {
        this.dragon = dragon;
        this.theWorld = dragon.field_70170_p;
        this.moveSpeed = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.dragon.func_70880_s() || !this.dragon.canMove()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean continueExecuting() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.dragon.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.dragon.func_70646_bf());
        this.dragon.func_70661_as().func_75492_a(this.targetMate.func_226277_ct_(), this.targetMate.func_226278_cu_(), this.targetMate.func_226281_cx_(), this.moveSpeed);
        this.dragon.setFlying(false);
        this.dragon.setHovering(false);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.dragon.func_70032_d((Entity)this.targetMate) < 35.0f) {
            this.spawnBaby();
        }
    }

    private EntityDragonBase getNearbyMate() {
        List list = this.theWorld.func_217357_a(this.dragon.getClass(), this.dragon.func_174813_aQ().func_72314_b(180.0, 180.0, 180.0));
        double d0 = Double.MAX_VALUE;
        EntityDragonBase mate = null;
        for (EntityDragonBase partner : list) {
            double d1;
            if (!this.dragon.func_70878_b((AnimalEntity)partner) || !((d1 = this.dragon.func_70068_e((Entity)partner)) < d0)) continue;
            mate = partner;
            d0 = d1;
        }
        return mate;
    }

    private void spawnBaby() {
        EntityDragonEgg egg = this.dragon.createEgg(this.targetMate);
        if (egg != null) {
            this.dragon.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.dragon.func_70875_t();
            this.targetMate.func_70875_t();
            int nestX = (int)(this.dragon.isMale() ? this.targetMate.func_226277_ct_() : this.dragon.func_226277_ct_());
            int nestY = (int)(this.dragon.isMale() ? this.targetMate.func_226278_cu_() : this.dragon.func_226278_cu_()) - 1;
            int nestZ = (int)(this.dragon.isMale() ? this.targetMate.func_226281_cx_() : this.dragon.func_226281_cx_());
            egg.func_70012_b((float)nestX - 0.5f, (float)nestY + 1.0f, (float)nestZ - 0.5f, 0.0f, 0.0f);
            this.theWorld.func_217376_c((Entity)egg);
            Random random = this.dragon.func_70681_au();
            for (int i = 0; i < 17; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.dragon.func_213311_cf() * 2.0 - (double)this.dragon.func_213311_cf();
                double d4 = 0.5 + random.nextDouble() * (double)this.dragon.func_213302_cg();
                double d5 = random.nextDouble() * (double)this.dragon.func_213311_cf() * 2.0 - (double)this.dragon.func_213311_cf();
                this.theWorld.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.dragon.func_226277_ct_() + d3, this.dragon.func_226278_cu_() + d4, this.dragon.func_226281_cx_() + d5, d0, d1, d2);
            }
            BlockPos eggPos = new BlockPos(nestX - 2, nestY, nestZ - 2);
            BlockPos dirtPos = eggPos.func_177982_a(1, 0, 1);
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    BlockPos add = eggPos.func_177982_a(x, 0, z);
                    BlockState prevState = this.theWorld.func_180495_p(add);
                    if (!prevState.func_185904_a().func_76222_j() && this.theWorld.func_180495_p(add).func_185904_a() != Material.field_151578_c && !(this.theWorld.func_180495_p(add).func_185887_b((IBlockReader)this.theWorld, add) < 5.0f) && !(this.theWorld.func_180495_p(add).func_185887_b((IBlockReader)this.theWorld, add) >= 0.0f)) continue;
                    this.theWorld.func_175656_a(add, NEST);
                }
            }
            if (this.theWorld.func_180495_p(dirtPos).func_185904_a().func_76222_j() || this.theWorld.func_180495_p(dirtPos) == NEST) {
                this.theWorld.func_175656_a(dirtPos, Blocks.field_185774_da.func_176223_P());
            }
            if (this.theWorld.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.theWorld.func_217376_c((Entity)new ExperienceOrbEntity(this.theWorld, this.dragon.func_226277_ct_(), this.dragon.func_226278_cu_(), this.dragon.func_226281_cx_(), random.nextInt(15) + 10));
            }
        }
    }
}

