/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.server.ServerWorld;

public class ChainProperties {
    private static final String CHAIN_TO_TAG = "ChainOwnerIaf";
    private static final String CHAIN_TO_ENTITY_ID_TAG = "ChainOwnerIDIaf";
    private static final String CHAIN_DATA = "ChainDataIaf";

    public static void attachChain(LivingEntity chained, Entity chainedTo) {
        if (ChainProperties.isChainedTo(chained, chainedTo)) {
            return;
        }
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)chained);
        ListNBT chainData = ChainProperties.getOrCreateChainData(entityData);
        CompoundNBT currentChainData = new CompoundNBT();
        currentChainData.func_186854_a(CHAIN_TO_TAG, chainedTo.func_110124_au());
        currentChainData.func_74768_a(CHAIN_TO_ENTITY_ID_TAG, chainedTo.func_145782_y());
        chainData.add((Object)currentChainData);
        entityData.func_218657_a(CHAIN_DATA, (INBT)chainData);
        ChainProperties.updateData(chained, entityData);
    }

    public static CompoundNBT getConnectedEntityChainData(LivingEntity host, Entity target) {
        ListNBT chainData = ChainProperties.getOrCreateChainData(host);
        if (chainData.isEmpty()) {
            return null;
        }
        return ChainProperties.getConnectedEntityChainData(chainData, target);
    }

    @Nullable
    public static CompoundNBT getConnectedEntityChainData(ListNBT chainData, Entity entity) {
        for (int i = 0; i < chainData.size(); ++i) {
            CompoundNBT nbt = (CompoundNBT)chainData.get(i);
            if (!nbt.func_74764_b(CHAIN_TO_TAG) || !nbt.func_186857_a(CHAIN_TO_TAG).equals(entity.func_110124_au())) continue;
            return nbt;
        }
        return null;
    }

    public static boolean hasChainData(LivingEntity entity) {
        return !ChainProperties.getOrCreateChainData(entity).isEmpty();
    }

    public static boolean hasEntityData(ListNBT chainData, Entity entity) {
        return ChainProperties.getConnectedEntityChainData(chainData, entity) != null;
    }

    private static ListNBT getOrCreateChainData(LivingEntity entity) {
        return ChainProperties.getOrCreateChainData(CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity));
    }

    private static ListNBT getOrCreateChainData(CompoundNBT entityData) {
        if (entityData.func_150297_b(CHAIN_DATA, 9)) {
            return entityData.func_150295_c(CHAIN_DATA, 10);
        }
        return new ListNBT();
    }

    public static void updateData(LivingEntity entity) {
        ChainProperties.updateData(entity, CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundNBT nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundNBT)nbt);
        if (!entity.field_70170_p.func_201670_d()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.func_145782_y()));
        }
    }

    public static void removeChain(LivingEntity entity, Entity connectedTo) {
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        ListNBT chainData = ChainProperties.getOrCreateChainData(entityData);
        int dataIndex = -1;
        for (int i = 0; i < chainData.size(); ++i) {
            CompoundNBT nbt = (CompoundNBT)chainData.get(i);
            if (!nbt.func_74764_b(CHAIN_TO_TAG) || !nbt.func_186857_a(CHAIN_TO_TAG).equals(connectedTo.func_110124_au())) continue;
            dataIndex = i;
            break;
        }
        if (dataIndex != -1) {
            chainData.remove(dataIndex);
            entityData.func_218657_a(CHAIN_DATA, (INBT)chainData);
            ChainProperties.updateData(entity, entityData);
        }
    }

    public static List<Entity> getChainedTo(LivingEntity chained) {
        ListNBT chainData = ChainProperties.getOrCreateChainData(chained);
        ArrayList<Entity> chainedTo = new ArrayList<Entity>();
        if (chainData.isEmpty()) {
            return chainedTo;
        }
        for (int i = 0; i < chainData.size(); ++i) {
            UUID uuid;
            Entity found;
            CompoundNBT lassoedTag = (CompoundNBT)chainData.get(i);
            if (chained.field_70170_p.func_201670_d() && lassoedTag.func_74764_b(CHAIN_TO_ENTITY_ID_TAG)) {
                int id = lassoedTag.func_74762_e(CHAIN_TO_ENTITY_ID_TAG);
                if (id == -1) continue;
                found = chained.field_70170_p.func_73045_a(id);
                if (found != null) {
                    chainedTo.add(found);
                    continue;
                }
                UUID uuid2 = lassoedTag.func_186857_a(CHAIN_TO_TAG);
                if (uuid2 == null || chained.field_70170_p.func_217371_b(uuid2) == null) continue;
                chainedTo.add((Entity)chained.field_70170_p.func_217371_b(uuid2));
                continue;
            }
            if (!(chained.field_70170_p instanceof ServerWorld) || (uuid = lassoedTag.func_186857_a(CHAIN_TO_TAG)) == null || (found = ((ServerWorld)chained.field_70170_p).func_217461_a(uuid)) == null) continue;
            lassoedTag.func_74768_a(CHAIN_TO_ENTITY_ID_TAG, found.func_145782_y());
            chainedTo.add(found);
        }
        return chainedTo;
    }

    public static void clearChainData(LivingEntity chained) {
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)chained);
        entityData.func_218657_a(CHAIN_DATA, (INBT)new ListNBT());
        ChainProperties.updateData(chained, entityData);
    }

    public static boolean isChainedTo(LivingEntity chained, Entity chainedTo) {
        if (chainedTo == null) {
            return false;
        }
        return ChainProperties.getChainedTo(chained).contains(chainedTo);
    }

    public static void tickChain(LivingEntity chained) {
        List<Entity> chainedToList = ChainProperties.getChainedTo(chained);
        for (Entity chainedOwner : chainedToList) {
            double distance;
            if (chainedOwner == null || !((distance = (double)chained.func_70032_d(chainedOwner)) > 7.0)) continue;
            double d0 = (chainedOwner.func_226277_ct_() - chained.func_226277_ct_()) / distance;
            double d1 = (chainedOwner.func_226278_cu_() - chained.func_226278_cu_()) / distance;
            double d2 = (chainedOwner.func_226281_cx_() - chained.func_226281_cx_()) / distance;
            chained.func_213317_d(chained.func_213322_ci().func_72441_c(d0 * Math.abs(d0) * 0.4, d1 * Math.abs(d1) * 0.2, d2 * Math.abs(d2) * 0.4));
        }
    }
}

