/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.IafVillagerRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AiDebug;
import com.github.alexthe666.iceandfire.entity.ai.EntitySheepAIFollowCyclops;
import com.github.alexthe666.iceandfire.entity.ai.VillagerAIFearUntamed;
import com.github.alexthe666.iceandfire.entity.props.ChainProperties;
import com.github.alexthe666.iceandfire.entity.props.ChickenProperties;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.props.SirenProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IHearsSiren;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemChain;
import com.github.alexthe666.iceandfire.item.ItemCockatriceScepter;
import com.github.alexthe666.iceandfire.item.ItemDeathwormGauntlet;
import com.github.alexthe666.iceandfire.item.ItemDragonsteelArmor;
import com.github.alexthe666.iceandfire.item.ItemGhostSword;
import com.github.alexthe666.iceandfire.item.ItemScaleArmor;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import com.github.alexthe666.iceandfire.message.MessagePlayerHitMultipart;
import com.github.alexthe666.iceandfire.message.MessageSwingArm;
import com.github.alexthe666.iceandfire.message.MessageSyncPath;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonCave;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iceandfire")
public class ServerEvents {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    private static final com.google.common.base.Predicate VILLAGER_FEAR = new com.google.common.base.Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity != null && entity instanceof IVillagerFear;
        }
    };
    private final Random rand = new Random();

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new IafRecipeRegistry());
    }

    private static void signalChickenAlarm(LivingEntity chicken, LivingEntity attacker) {
        float d0 = IafConfig.cockatriceChickenSearchLength;
        List list = chicken.field_70170_p.func_217357_a(EntityCockatrice.class, new AxisAlignedBB(chicken.func_226277_ct_(), chicken.func_226278_cu_(), chicken.func_226281_cx_(), chicken.func_226277_ct_() + 1.0, chicken.func_226278_cu_() + 1.0, chicken.func_226281_cx_() + 1.0).func_72314_b((double)d0, 10.0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            EntityCockatrice cockatrice;
            if (!(entity instanceof EntityCockatrice) || attacker instanceof EntityCockatrice || DragonUtils.hasSameOwner(cockatrice = (EntityCockatrice)entity, (Entity)attacker)) continue;
            if (attacker instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)attacker;
                if (player.func_184812_l_() || cockatrice.func_152114_e((LivingEntity)player)) continue;
                cockatrice.func_70624_b((LivingEntity)player);
                continue;
            }
            cockatrice.func_70624_b(attacker);
        }
    }

    private static void signalAmphithereAlarm(LivingEntity villager, LivingEntity attacker) {
        float d0 = IafConfig.amphithereVillagerSearchLength;
        List list = villager.field_70170_p.func_217357_a(EntityAmphithere.class, new AxisAlignedBB(villager.func_226277_ct_() - 1.0, villager.func_226278_cu_() - 1.0, villager.func_226281_cx_() - 1.0, villager.func_226277_ct_() + 1.0, villager.func_226278_cu_() + 1.0, villager.func_226281_cx_() + 1.0).func_72314_b((double)d0, (double)d0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            TameableEntity amphithere;
            if (!(entity instanceof EntityAmphithere) || attacker instanceof EntityAmphithere || DragonUtils.hasSameOwner(amphithere = (TameableEntity)entity, (Entity)attacker)) continue;
            if (attacker instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)attacker;
                if (player.func_184812_l_() || amphithere.func_152114_e((LivingEntity)player)) continue;
                amphithere.func_70624_b((LivingEntity)player);
                continue;
            }
            amphithere.func_70624_b(attacker);
        }
    }

    private static boolean isInEntityTag(ResourceLocation loc, EntityType type) {
        ITag tag = EntityTypeTags.func_219762_a().func_199910_a(loc);
        return tag != null && tag.func_230235_a_((Object)type);
    }

    public static boolean isLivestock(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.FEAR_DRAGONS, entity.func_200600_R());
    }

    public static boolean isVillager(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.VILLAGERS, entity.func_200600_R());
    }

    public static boolean isSheep(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.SHEEP, entity.func_200600_R());
    }

    public static boolean isChicken(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.CHICKENS, entity.func_200600_R());
    }

    public static boolean isCockatriceTarget(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.COCKATRICE_TARGETS, entity.func_200600_R());
    }

    public static boolean doesScareCockatrice(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.SCARES_COCKATRICES, entity.func_200600_R());
    }

    public static boolean isBlindMob(Entity entity) {
        return entity != null && ServerEvents.isInEntityTag(IafTagRegistry.BLINDED, entity.func_200600_R());
    }

    public static boolean isRidingOrBeingRiddenBy(Entity first, Entity entityIn) {
        for (Entity entity : first.func_184188_bt()) {
            if (!entity.equals((Object)entityIn) && !ServerEvents.isRidingOrBeingRiddenBy(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onArrowCollide(ProjectileImpactEvent event) {
        if (event.getEntity() instanceof AbstractArrowEntity && ((AbstractArrowEntity)event.getEntity()).func_234616_v_() != null && event.getRayTraceResult() instanceof EntityRayTraceResult && ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() != null) {
            Entity shootingEntity = ((AbstractArrowEntity)event.getEntity()).func_234616_v_();
            Entity shotEntity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            if (shootingEntity instanceof LivingEntity && ServerEvents.isRidingOrBeingRiddenBy(shootingEntity, shotEntity) && shotEntity instanceof TameableEntity && ((TameableEntity)shotEntity).func_70909_n() && shotEntity.func_184191_r(shootingEntity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttackMob(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityMutlipartPart && event.getEntity() instanceof PlayerEntity) {
            event.setCanceled(true);
            Entity parent = ((EntityMutlipartPart)event.getTarget()).getParent();
            try {
                if (parent != null) {
                    ((PlayerEntity)event.getEntity()).func_71059_n(parent);
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Exception thrown while interacting with entity.", (Throwable)e);
            }
            int extraData = 0;
            if (event.getTarget() instanceof EntityHydraHead && parent instanceof EntityHydra) {
                extraData = ((EntityHydraHead)event.getTarget()).headIndex;
                ((EntityHydra)parent).triggerHeadFlags(extraData);
            }
            if (event.getTarget().field_70170_p.field_72995_K && parent != null) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessagePlayerHitMultipart(parent.func_145782_y(), extraData));
            }
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && MiscProperties.hasDismounted(event.getEntityLiving())) {
            event.setDamageMultiplier(0.0f);
            MiscProperties.setDismountedDragon(event.getEntityLiving(), false);
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        String damageType;
        if (event.getSource().func_76352_a()) {
            float multi = 1.0f;
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.1);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.3);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.2);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.1);
            }
            event.setAmount(event.getAmount() * multi);
        }
        if ("dragon_fire".equals(damageType = event.getSource().func_76355_l()) || "dragon_ice".equals(damageType) || "dragon_lightning".equals(damageType)) {
            float multi = 1.0f;
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemScaleArmor || event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemDragonsteelArmor) {
                multi = (float)((double)multi - 0.1);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemScaleArmor || event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemDragonsteelArmor) {
                multi = (float)((double)multi - 0.3);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemScaleArmor || event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemDragonsteelArmor) {
                multi = (float)((double)multi - 0.2);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemScaleArmor || event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemDragonsteelArmor) {
                multi = (float)((double)multi - 0.1);
            }
            event.setAmount(event.getAmount() * multi);
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof WitherSkeletonEntity) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)IafItemRegistry.WITHERBONE, event.getEntityLiving().func_70681_au().nextInt(2))));
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        Entity attacker;
        if (event.getSource() != null && event.getSource().func_76346_g() != null && (attacker = event.getSource().func_76346_g()) instanceof LivingEntity) {
            if (MiscProperties.getLoveTicks((LivingEntity)attacker) > 0) {
                event.setCanceled(true);
            }
            if (ServerEvents.isChicken((Entity)event.getEntityLiving())) {
                ServerEvents.signalChickenAlarm(event.getEntityLiving(), (LivingEntity)attacker);
            } else if (DragonUtils.isVillager((Entity)event.getEntityLiving())) {
                ServerEvents.signalAmphithereAlarm(event.getEntityLiving(), (LivingEntity)attacker);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        LivingEntity target = event.getTarget();
        if (target != null) {
            LivingEntity attacker = event.getEntityLiving();
            if (ServerEvents.isChicken((Entity)target)) {
                ServerEvents.signalChickenAlarm(target, attacker);
            } else if (DragonUtils.isVillager((Entity)target)) {
                ServerEvents.signalAmphithereAlarm(target, attacker);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getTarget() != null && ServerEvents.isSheep(event.getTarget())) {
            float dist = IafConfig.cyclopesSheepSearchLength;
            List list = event.getTarget().field_70170_p.func_72839_b((Entity)event.getPlayer(), event.getPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityCyclops cyclops;
                    if (!(entity instanceof EntityCyclops) || (cyclops = (EntityCyclops)entity).isBlinded() || event.getPlayer().func_184812_l_()) continue;
                    cyclops.func_70624_b((LivingEntity)event.getPlayer());
                }
            }
        }
        if (event.getTarget() instanceof EntityStoneStatue) {
            ((LivingEntity)event.getTarget()).func_70606_j(((LivingEntity)event.getTarget()).func_110138_aP());
            if (event.getPlayer() != null) {
                ItemStack stack = event.getPlayer().func_184614_ca();
                event.getTarget().func_184185_a(SoundEvents.field_187835_fT, 2.0f, 0.5f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.5f);
                if (stack.func_77973_b() != null && (stack.func_77973_b().func_150897_b(Blocks.field_150348_b.func_176223_P()) || stack.func_77973_b().func_77658_a().contains("pickaxe"))) {
                    boolean ready = false;
                    event.setCanceled(true);
                    EntityStoneStatue statue = (EntityStoneStatue)event.getTarget();
                    statue.setCrackAmount(statue.getCrackAmount() + 1);
                    boolean bl = ready = statue.getCrackAmount() > 9;
                    if (ready) {
                        boolean silkTouch;
                        CompoundNBT writtenTag = new CompoundNBT();
                        event.getTarget().func_189511_e(writtenTag);
                        event.getTarget().func_184185_a(SoundEvents.field_187835_fT, 2.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.5f);
                        event.getTarget().func_70106_y();
                        boolean bl2 = silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
                        if (silkTouch) {
                            ItemStack statuette = new ItemStack((IItemProvider)IafItemRegistry.STONE_STATUE);
                            statuette.func_77982_d(new CompoundNBT());
                            statuette.func_77978_p().func_74757_a("IAFStoneStatuePlayerEntity", statue.getTrappedEntityTypeString().equalsIgnoreCase("minecraft:player"));
                            statuette.func_77978_p().func_74778_a("IAFStoneStatueEntityID", statue.getTrappedEntityTypeString());
                            statuette.func_77978_p().func_218657_a("IAFStoneStatueNBT", (INBT)writtenTag);
                            ((LivingEntity)event.getTarget()).func_213281_b(statuette.func_77978_p());
                            if (!event.getTarget().field_70170_p.field_72995_K) {
                                event.getTarget().func_70099_a(statuette, 1.0f);
                            }
                        } else if (!event.getTarget().field_70170_p.field_72995_K) {
                            event.getTarget().func_199702_a((IItemProvider)Blocks.field_150347_e.func_199767_j(), 2 + event.getEntityLiving().func_70681_au().nextInt(4));
                        }
                        event.getTarget().func_70106_y();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDie(LivingDeathEvent event) {
        LivingEntity attacker;
        if (!event.getEntity().field_70170_p.field_72995_K && ChainProperties.hasChainData(event.getEntityLiving())) {
            ItemEntity entityitem = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_() + 1.0, event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)IafItemRegistry.CHAIN, ChainProperties.getChainedTo(event.getEntityLiving()).size()));
            entityitem.func_174869_p();
            event.getEntity().field_70170_p.func_217376_c((Entity)entityitem);
            ChainProperties.clearChainData(event.getEntityLiving());
        }
        if (event.getEntityLiving().func_110124_au().equals(ALEX_UUID)) {
            event.getEntityLiving().func_70099_a(new ItemStack((IItemProvider)IafItemRegistry.WEEZER_BLUE_ALBUM), 1.0f);
        }
        if (event.getEntityLiving() instanceof PlayerEntity && IafConfig.ghostsFromPlayerDeaths && (attacker = event.getEntityLiving().func_70643_av()) instanceof PlayerEntity && event.getEntityLiving().func_70681_au().nextInt(3) == 0) {
            boolean flag;
            CombatTracker combat = event.getEntityLiving().func_110142_aN();
            CombatEntry entry = combat.func_94544_f();
            boolean bl = flag = entry != null && (entry.func_94560_a() == DamageSource.field_76379_h || entry.func_94560_a() == DamageSource.field_76369_e || entry.func_94560_a() == DamageSource.field_76371_c);
            if (event.getEntityLiving().func_70644_a(Effects.field_76436_u)) {
                flag = true;
            }
            if (flag) {
                World world = event.getEntityLiving().field_70170_p;
                EntityGhost ghost = (EntityGhost)((EntityType)IafEntityRegistry.GHOST.get()).func_200721_a(world);
                ghost.func_82149_j((Entity)event.getEntityLiving());
                if (!world.field_72995_K) {
                    ghost.func_213386_a((IServerWorld)world, world.func_175649_E(event.getEntityLiving().func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                    world.func_217376_c((Entity)ghost);
                }
                ghost.setDaytimeMode(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityStopUsingItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getItem().func_77973_b() instanceof ItemDeathwormGauntlet || event.getItem().func_77973_b() instanceof ItemCockatriceScepter) {
            event.setDuration(20);
        }
    }

    @SubscribeEvent
    public void onEntityUseItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().field_70125_A > 87.0f && event.getEntityLiving().func_184187_bx() != null && event.getEntityLiving().func_184187_bx() instanceof EntityDragonBase) {
            ((EntityDragonBase)event.getEntityLiving().func_184187_bx()).func_230254_b_((PlayerEntity)event.getEntityLiving(), event.getHand());
        }
        if (event.getEntityLiving() instanceof EntityDragonBase && !event.getEntityLiving().func_70089_S()) {
            event.setResult(Event.Result.DENY);
            ((EntityDragonBase)event.getEntityLiving()).func_230254_b_(event.getPlayer(), event.getHand());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (ChainProperties.hasChainData(event.getEntityLiving())) {
            ChainProperties.tickChain(event.getEntityLiving());
        }
        if (IafConfig.chickensLayRottenEggs && !event.getEntityLiving().field_70170_p.field_72995_K && ServerEvents.isChicken((Entity)event.getEntityLiving()) && !event.getEntityLiving().func_70631_g_() && event.getEntityLiving() instanceof AnimalEntity) {
            ChickenProperties.tickChicken(event.getEntityLiving());
        }
        if (FrozenProperties.isFrozen(event.getEntityLiving())) {
            FrozenProperties.tickFrozenEntity(event.getEntityLiving());
            if (!(event.getEntityLiving() instanceof PlayerEntity) || !((PlayerEntity)event.getEntityLiving()).func_184812_l_()) {
                event.getEntity().func_213317_d(event.getEntity().func_213322_ci().func_216372_d(0.25, 1.0, 0.25));
                if (!(event.getEntityLiving() instanceof EnderDragonEntity) && !event.getEntityLiving().func_233570_aj_()) {
                    event.getEntity().func_213317_d(event.getEntity().func_213322_ci().func_72441_c(0.0, -0.2, 0.0));
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity || event.getEntityLiving() instanceof AbstractVillagerEntity || event.getEntityLiving() instanceof IHearsSiren) {
            SirenProperties.tickCharmedEntity(event.getEntityLiving());
        }
        if (MiscProperties.getLoveTicks(event.getEntityLiving()) > 0) {
            MiscProperties.tickLove(event.getEntityLiving());
        }
        if (AiDebug.isEnabled() && event.getEntityLiving() instanceof MobEntity && AiDebug.contains((MobEntity)event.getEntityLiving())) {
            AiDebug.logData();
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        LivingEntity target;
        if (event.getTarget() instanceof LivingEntity && ChainProperties.isChainedTo(target = (LivingEntity)event.getTarget(), (Entity)event.getPlayer())) {
            ChainProperties.removeChain(target, (Entity)event.getPlayer());
            if (!event.getWorld().field_72995_K) {
                event.getTarget().func_199702_a((IItemProvider)IafItemRegistry.CHAIN, 1);
            }
        }
        if (!event.getWorld().func_201670_d() && event.getTarget() instanceof MobEntity && event.getItemStack().func_77973_b() == Items.field_151055_y) {
            if (AiDebug.isEnabled()) {
                AiDebug.addEntity((MobEntity)event.getTarget());
            }
            if (Pathfinding.isDebug()) {
                if (AbstractPathJob.trackingMap.getOrDefault(event.getPlayer(), UUID.randomUUID()).equals(event.getTarget().func_110124_au())) {
                    AbstractPathJob.trackingMap.remove(event.getPlayer());
                    IceAndFire.sendMSGToPlayer(new MessageSyncPath(new HashSet<Node>(), new HashSet<Node>(), new HashSet<Node>()), (ServerPlayerEntity)event.getPlayer());
                } else {
                    AbstractPathJob.trackingMap.put(event.getPlayer(), event.getTarget().func_110124_au());
                }
            }
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        EntityRayTraceResult entityResult;
        if (event.getRayTraceResult() != null && event.getRayTraceResult() instanceof EntityRayTraceResult && (entityResult = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() != null && entityResult.func_216348_a() instanceof EntityGhost) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ServerEvents.onLeftClick(event.getPlayer(), event.getItemStack());
        if (event.getWorld().field_72995_K) {
            IceAndFire.sendMSGToServer(new MessageSwingArm());
        }
    }

    public static void onLeftClick(PlayerEntity playerEntity, ItemStack stack) {
        if (stack.func_77973_b() == IafItemRegistry.GHOST_SWORD) {
            ItemGhostSword.spawnGhostSwordEntity(stack, playerEntity);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPlayer() != null && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof AbstractChestBlock && !event.getPlayer().func_184812_l_()) {
            float dist = IafConfig.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)event.getPlayer(), event.getPlayer().func_174813_aQ().func_72314_b((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((LivingEntity)event.getPlayer())) continue;
                    dragon.func_233686_v_(false);
                    dragon.func_233687_w_(false);
                    dragon.func_70624_b((LivingEntity)event.getPlayer());
                }
            }
        }
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof WallBlock) {
            ItemChain.attachToFence(event.getPlayer(), event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && (event.getState().func_177230_c() instanceof AbstractChestBlock || event.getState().func_177230_c() == IafBlockRegistry.GOLD_PILE || event.getState().func_177230_c() == IafBlockRegistry.SILVER_PILE || event.getState().func_177230_c() == IafBlockRegistry.COPPER_PILE)) {
            float dist = IafConfig.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)event.getPlayer(), event.getPlayer().func_174813_aQ().func_72314_b((double)dist, (double)dist, (double)dist));
            if (list.isEmpty()) {
                return;
            }
            for (Entity entity : list) {
                EntityDragonBase dragon;
                if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((LivingEntity)event.getPlayer()) || event.getPlayer().func_184812_l_()) continue;
                dragon.func_233686_v_(false);
                dragon.func_233687_w_(false);
                dragon.func_70624_b((LivingEntity)event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onChestGenerated(LootTableLoadEvent event) {
        LootPool.Builder builder;
        StandaloneLootEntry.Builder item;
        boolean condition1;
        ResourceLocation eventName = event.getName();
        boolean bl = condition1 = eventName.equals((Object)LootTables.field_186422_d) || eventName.equals((Object)LootTables.field_186424_f) || eventName.equals((Object)LootTables.field_186429_k) || eventName.equals((Object)LootTables.field_186430_l) || eventName.equals((Object)LootTables.field_186428_j) || eventName.equals((Object)LootTables.field_186427_i);
        if (condition1 || eventName.equals((Object)LootTables.field_215817_h)) {
            item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.MANUSCRIPT).func_216085_b(20).func_216086_a(5);
            builder = new LootPool.Builder().name("iaf_manuscript").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.35f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 4.0f)).bonusRolls(0.0f, 3.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
        if (condition1 || eventName.equals((Object)LootTables.field_186431_m) || eventName.equals((Object)LootTables.field_191192_o) || eventName.equals((Object)LootTables.field_215815_f) || eventName.equals((Object)LootTables.field_215816_g)) {
            if (IafConfig.generateSilverOre) {
                item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.SILVER_INGOT).func_216085_b(15).func_216086_a(12);
                builder = new LootPool.Builder().name("iaf_silver_ingot").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.5f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 3.0f)).bonusRolls(0.0f, 2.0f);
                event.getTable().addPool(builder.func_216044_b());
            } else if (IafConfig.generateCopperOre) {
                item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.COPPER_INGOT).func_216085_b(10).func_216086_a(14);
                builder = new LootPool.Builder().name("iaf_copper_ingot").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.6f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 2.0f)).bonusRolls(0.0f, 3.0f);
                event.getTable().addPool(builder.func_216044_b());
            }
        } else if (event.getName().equals((Object)WorldGenFireDragonCave.FIRE_DRAGON_CHEST) || event.getName().equals((Object)WorldGenFireDragonCave.FIRE_DRAGON_CHEST_MALE) || event.getName().equals((Object)WorldGenIceDragonCave.ICE_DRAGON_CHEST) || event.getName().equals((Object)WorldGenIceDragonCave.ICE_DRAGON_CHEST_MALE) || event.getName().equals((Object)WorldGenLightningDragonCave.LIGHTNING_DRAGON_CHEST) || event.getName().equals((Object)WorldGenLightningDragonCave.LIGHTNING_DRAGON_CHEST_MALE)) {
            item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.WEEZER_BLUE_ALBUM).func_216085_b(100).func_216086_a(1);
            builder = new LootPool.Builder().name("iaf_weezer").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.01f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 1.0f)).bonusRolls(0.0f, 0.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
    }

    @SubscribeEvent
    public void onPlayerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() != null && !event.getPlayer().func_184188_bt().isEmpty()) {
            for (Entity entity : event.getPlayer().func_184188_bt()) {
                entity.func_184210_p();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)event.getTarget();
            if (ChainProperties.hasChainData(target)) {
                ChainProperties.updateData(target);
            }
            if (FrozenProperties.isFrozen(target)) {
                FrozenProperties.updateData(target);
            }
            if (MiscProperties.getLoveTicks(target) > 0) {
                MiscProperties.updateData(target);
            }
            if (SirenProperties.isCharmed(target)) {
                SirenProperties.updateData(target);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(LivingSpawnEvent.SpecialSpawn event) {
        try {
            AnimalEntity animal;
            if (event.getEntity() != null && ServerEvents.isSheep(event.getEntity()) && event.getEntity() instanceof AnimalEntity) {
                animal = (AnimalEntity)event.getEntity();
                animal.field_70714_bg.func_75776_a(8, (Goal)new EntitySheepAIFollowCyclops(animal, 1.2));
            }
            if (event.getEntity() != null && ServerEvents.isVillager(event.getEntity()) && event.getEntity() instanceof MobEntity && IafConfig.villagersFearDragons) {
                MobEntity villager = (MobEntity)event.getEntity();
                villager.field_70714_bg.func_75776_a(1, (Goal)new VillagerAIFearUntamed((CreatureEntity)villager, LivingEntity.class, 8.0f, 0.8, 0.8, (Predicate<LivingEntity>)VILLAGER_FEAR));
            }
            if (event.getEntity() != null && ServerEvents.isLivestock(event.getEntity()) && event.getEntity() instanceof MobEntity && IafConfig.animalsFearDragons) {
                animal = (MobEntity)event.getEntity();
                animal.field_70714_bg.func_75776_a(1, (Goal)new VillagerAIFearUntamed((CreatureEntity)animal, LivingEntity.class, 30.0f, 1.0, 0.5, new Predicate<LivingEntity>((MobEntity)animal){
                    final /* synthetic */ MobEntity val$animal;
                    {
                        this.val$animal = mobEntity;
                    }

                    @Override
                    public boolean test(LivingEntity entity) {
                        return entity != null && entity instanceof IAnimalFear && ((IAnimalFear)entity).shouldAnimalsFear((Entity)this.val$animal);
                    }
                }));
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == IafVillagerRegistry.SCRIBE) {
            IafVillagerRegistry.addScribeTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)event.getTrades());
        }
    }
}

