/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncPath {
    public static Set<Node> lastDebugNodesVisited = new HashSet<Node>();
    public static Set<Node> lastDebugNodesNotVisited = new HashSet<Node>();
    public static Set<Node> lastDebugNodesPath = new HashSet<Node>();

    public MessageSyncPath() {
    }

    public MessageSyncPath(Set<Node> lastDebugNodesVisited, Set<Node> lastDebugNodesNotVisited, Set<Node> lastDebugNodesPath) {
        MessageSyncPath.lastDebugNodesVisited = lastDebugNodesVisited;
        MessageSyncPath.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        MessageSyncPath.lastDebugNodesPath = lastDebugNodesPath;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(lastDebugNodesVisited.size());
        for (Node node : lastDebugNodesVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(lastDebugNodesNotVisited.size());
        for (Node node : lastDebugNodesNotVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(lastDebugNodesPath.size());
        for (Node node : lastDebugNodesPath) {
            node.serializeToBuf(buf);
        }
    }

    public static MessageSyncPath read(PacketBuffer buf) {
        int i;
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            lastDebugNodesVisited.add(new Node(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            lastDebugNodesNotVisited.add(new Node(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            lastDebugNodesPath.add(new Node(buf));
        }
        return new MessageSyncPath();
    }

    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    public static class Handler {
        public static void handle(MessageSyncPath message, Supplier<NetworkEvent.Context> context) {
            Pathfinding.lastDebugNodesVisited = lastDebugNodesVisited;
            Pathfinding.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
            Pathfinding.lastDebugNodesPath = lastDebugNodesPath;
            context.get().setPacketHandled(true);
        }
    }
}

