/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.pathfinding.NodeProcessorFly;
import com.github.alexthe666.iceandfire.pathfinding.NodeProcessorWalk;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.IStuckHandler;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathFindingStatus;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathPointExtended;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathResult;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathingStuckHandler;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.PathJobMoveAwayFromLocation;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.PathJobMoveToLocation;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.PathJobRandomPos;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.block.LadderBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class AdvancedPathNavigate
extends AbstractAdvancedPathNavigate {
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 2;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    @Nullable
    private PathResult<AbstractPathJob> pathResult;
    private long pathStartTime = 0L;
    private final BlockPos spawnedPos = BlockPos.field_177992_a;
    private BlockPos desiredPos;
    private int desiredPosTimeout = 0;
    private IStuckHandler stuckHandler;
    private boolean isSneaking = true;
    private double swimSpeedFactor = 1.0;
    private float width = 1.0f;
    private float height = 1.0f;

    public AdvancedPathNavigate(MobEntity entity, World world) {
        this(entity, world, MovementType.WALKING);
    }

    public AdvancedPathNavigate(MobEntity entity, World world, MovementType type) {
        this(entity, world, type, 1.0f, 1.0f);
    }

    public AdvancedPathNavigate(MobEntity entity, World world, MovementType type, float width, float height) {
        this(entity, world, type, width, height, PathingStuckHandler.createStuckHandler().withTeleportSteps(6).withTeleportOnFullStuck());
    }

    public AdvancedPathNavigate(MobEntity entity, World world, MovementType type, float width, float height, PathingStuckHandler stuckHandler) {
        super(entity, world);
        switch (type) {
            case FLYING: {
                this.field_179695_a = new NodeProcessorFly();
                this.getPathingOptions().setIsFlying(true);
                break;
            }
            case WALKING: {
                this.field_179695_a = new NodeProcessorWalk();
                break;
            }
            case CLIMBING: {
                this.field_179695_a = new NodeProcessorWalk();
                this.getPathingOptions().setCanClimb(true);
            }
        }
        this.field_179695_a.func_186317_a(true);
        this.getPathingOptions().setEnterDoors(true);
        this.field_179695_a.func_186321_b(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.field_179695_a.func_186316_c(true);
        this.getPathingOptions().setCanSwim(true);
        this.width = width;
        this.height = height;
        this.stuckHandler = stuckHandler;
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    @Override
    @Nullable
    public PathResult moveAwayFromXYZ(BlockPos avoid, double range, double speedFactor, boolean safeDestination) {
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(this.ourEntity.field_70170_p, start, avoid, (int)range, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), null, speedFactor, safeDestination);
    }

    @Override
    @Nullable
    public PathResult moveToRandomPos(double range, double speedFactor) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos) {
            return this.pathResult;
        }
        this.desiredPos = BlockPos.field_177992_a;
        int theRange = (int)((double)this.field_75515_a.func_70681_au().nextInt((int)range) + range / 2.0);
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobRandomPos(this.ourEntity.field_70170_p, start, theRange, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), null, speedFactor, true);
    }

    @Override
    @Nullable
    public PathResult moveToRandomPosAroundX(int range, double speedFactor, BlockPos pos) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos && ((PathJobRandomPos)this.pathResult.getJob()).posAndRangeMatch(range, pos)) {
            return this.pathResult;
        }
        this.desiredPos = BlockPos.field_177992_a;
        return this.setPathJob(new PathJobRandomPos(this.ourEntity.field_70170_p, AbstractPathJob.prepareStart((LivingEntity)this.ourEntity), 3, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), range, (LivingEntity)this.ourEntity, pos), pos, speedFactor, true);
    }

    @Override
    public PathResult moveToRandomPos(int range, double speedFactor, Tuple<BlockPos, BlockPos> corners, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos) {
            return this.pathResult;
        }
        this.desiredPos = BlockPos.field_177992_a;
        int theRange = this.field_75515_a.func_70681_au().nextInt(range) + range / 2;
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobRandomPos(this.ourEntity.field_70170_p, start, theRange, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity, (BlockPos)corners.func_76341_a(), (BlockPos)corners.func_76340_b(), restrictionType), null, speedFactor, true);
    }

    @Nullable
    public PathResult setPathJob(AbstractPathJob job, BlockPos dest, double speedFactor, boolean safeDestination) {
        this.func_75499_g();
        this.destination = dest;
        this.originalDestination = dest;
        if (safeDestination) {
            this.desiredPos = dest;
            if (dest != null) {
                this.desiredPosTimeout = 1000;
            }
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            IceAndFire.LOGGER.error("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity, (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.pathResult = job.getResult();
        this.pathResult.startJob(Pathfinding.getExecutor());
        return this.pathResult;
    }

    public boolean func_75500_f() {
        return (this.pathResult == null || this.pathResult.isFinished() && this.pathResult.getStatus() != PathFindingStatus.CALCULATION_COMPLETE) && super.func_75500_f();
    }

    public void func_75501_e() {
        int oldIndex;
        if (this.field_179695_a instanceof NodeProcessorWalk) {
            ((NodeProcessorWalk)this.field_179695_a).setEntitySize(this.width, this.height);
        } else {
            ((NodeProcessorFly)this.field_179695_a).setEntitySize(this.width, this.height);
        }
        if (this.desiredPosTimeout > 0 && this.desiredPosTimeout-- <= 0) {
            this.desiredPos = null;
        }
        if (this.pathResult != null) {
            if (!this.pathResult.isFinished()) {
                return;
            }
            if (this.pathResult.getStatus() == PathFindingStatus.CALCULATION_COMPLETE) {
                try {
                    this.processCompletedCalculationResult();
                }
                catch (InterruptedException | ExecutionException e) {
                    IceAndFire.LOGGER.catching((Throwable)e);
                }
            }
        }
        int n = oldIndex = this.func_75500_f() ? 0 : this.func_75505_d().func_75873_e();
        if (this.isSneaking) {
            this.isSneaking = false;
            this.field_75515_a.func_226284_e_(false);
        }
        if (this.handleLadders(oldIndex)) {
            this.func_75508_h();
            this.stuckHandler.checkStuck(this);
            return;
        }
        if (this.handleRails()) {
            this.stuckHandler.checkStuck(this);
            return;
        }
        ++this.field_75510_g;
        if (!this.func_75500_f()) {
            Vector3d vector3d2;
            BlockPos blockpos;
            if (this.func_75485_k()) {
                this.func_75508_h();
            } else if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
                Vector3d vector3d = this.func_75502_i();
                Vector3d vector3d1 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                if (vector3d.field_72448_b > vector3d1.field_72448_b && !this.field_75515_a.func_233570_aj_() && MathHelper.func_76128_c((double)vector3d.field_72450_a) == MathHelper.func_76128_c((double)vector3d1.field_72450_a) && MathHelper.func_76128_c((double)vector3d.field_72449_c) == MathHelper.func_76128_c((double)vector3d1.field_72449_c)) {
                    this.field_75514_c.func_75875_a();
                }
            }
            DebugPacketSender.func_218803_a((World)this.field_75513_b, (MobEntity)this.field_75515_a, (Path)this.field_75514_c, (float)this.field_188561_o);
            if (!this.func_75500_f() && AdvancedPathNavigate.isEntityBlockLoaded((IWorld)this.field_75513_b, blockpos = new BlockPos(vector3d2 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a)))) {
                this.field_75515_a.func_70605_aq().func_75642_a(vector3d2.field_72450_a, this.field_75513_b.func_180495_p(blockpos.func_177977_b()).func_196958_f() ? vector3d2.field_72448_b : AdvancedPathNavigate.getSmartGroundY((IBlockReader)this.field_75513_b, blockpos), vector3d2.field_72449_c, this.field_75511_d);
            }
        }
        if (this.field_188562_p) {
            this.recomputePath();
        }
        if (this.pathResult != null && this.func_75500_f()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            this.pathResult = null;
        }
        if (this.field_75515_a instanceof TameableEntity) {
            if (((TameableEntity)this.field_75515_a).func_70909_n()) {
                return;
            }
            if (this.field_75515_a instanceof EntityDragonBase) {
                if (((EntityDragonBase)this.field_75515_a).isChained()) {
                    return;
                }
                if (((EntityDragonBase)this.field_75515_a).func_233684_eK_()) {
                    return;
                }
            }
        }
        this.stuckHandler.checkStuck(this);
    }

    public static double getSmartGroundY(IBlockReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        VoxelShape voxelshape = world.func_180495_p(blockpos).func_196951_e(world, blockpos);
        if (voxelshape.func_197766_b() || voxelshape.func_197758_c(Direction.Axis.Y) < 1.0) {
            return pos.func_177956_o();
        }
        return (double)blockpos.func_177956_o() + voxelshape.func_197758_c(Direction.Axis.Y);
    }

    @Override
    @Nullable
    public PathResult moveToXYZ(double x, double y, double z, double speedFactor) {
        int newX = MathHelper.func_76128_c((double)x);
        int newY = (int)y;
        int newZ = MathHelper.func_76128_c((double)z);
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobMoveToLocation && (this.pathResult.isComputing() || this.destination != null && AdvancedPathNavigate.isEqual(this.destination, newX, newY, newZ) || this.originalDestination != null && AdvancedPathNavigate.isEqual(this.originalDestination, newX, newY, newZ))) {
            return this.pathResult;
        }
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        this.desiredPos = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(this.ourEntity.field_70170_p, start, this.desiredPos, (int)this.ourEntity.func_110148_a(Attributes.field_233819_b_).func_111126_e(), (LivingEntity)this.ourEntity), this.desiredPos, speedFactor, true);
    }

    @Override
    public boolean tryMoveToBlockPos(BlockPos pos, double speedFactor) {
        this.moveToXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), speedFactor);
        return true;
    }

    protected PathFinder func_179679_a(int p_179679_1_) {
        return new PathFinder((NodeProcessor)new WalkNodeProcessor(), p_179679_1_);
    }

    protected boolean func_75485_k() {
        if (this.ourEntity.func_184187_bx() != null) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            if (pEx.isRailsExit()) {
                Entity entity = this.ourEntity.func_184187_bx();
                this.ourEntity.func_184210_p();
                entity.func_70106_y();
            } else if (!pEx.isOnRails()) {
                if (this.destination == null || this.field_75515_a.func_70092_e((double)this.destination.func_177958_n(), (double)this.destination.func_177956_o(), (double)this.destination.func_177952_p()) > 2.0) {
                    this.ourEntity.func_184210_p();
                }
            } else if ((Math.abs((double)pEx.field_75839_a - this.field_75515_a.func_226277_ct_()) > 7.0 || Math.abs((double)pEx.field_75838_c - this.field_75515_a.func_226281_cx_()) > 7.0) && this.ourEntity.func_184187_bx() != null) {
                Entity entity = this.ourEntity.func_184187_bx();
                this.ourEntity.func_184210_p();
                entity.func_70106_y();
            }
        }
        return true;
    }

    protected Vector3d func_75502_i() {
        return this.ourEntity.func_213303_ch();
    }

    public Path func_179680_a(BlockPos pos, int accuracy) {
        return null;
    }

    protected boolean func_75493_a(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ) {
        return super.func_75493_a(start, end, sizeX, sizeY, sizeZ);
    }

    public double getSpeedFactor() {
        if (this.ourEntity.func_70090_H()) {
            this.field_75511_d = this.walkSpeedFactor * this.swimSpeedFactor;
            return this.field_75511_d;
        }
        this.field_75511_d = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void func_75489_a(double speedFactor) {
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            IceAndFire.LOGGER.debug("Tried to set a bad speed:" + speedFactor + " for entity:" + this.ourEntity);
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    public boolean func_75492_a(double x, double y, double z, double speedFactor) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return false;
        }
        this.moveToXYZ(x, y, z, speedFactor);
        return true;
    }

    public boolean func_75497_a(Entity entityIn, double speedFactor) {
        return this.tryMoveToBlockPos(entityIn.func_233580_cy_(), speedFactor);
    }

    protected void func_75487_m() {
    }

    public boolean func_75484_a(@Nullable Path path, double speedFactor) {
        if (path == null) {
            this.func_75499_g();
            return false;
        }
        this.pathStartTime = this.field_75513_b.func_82737_E();
        return super.func_75484_a(this.convertPath(path), speedFactor);
    }

    private Path convertPath(Path path) {
        int pathLength = path.func_75874_d();
        Path tempPath = null;
        if (pathLength > 0 && !(path.func_75877_a(0) instanceof PathPointExtended)) {
            PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                PathPoint point = path.func_75877_a(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.func_224770_k(), path.func_224771_h());
            PathPointExtended finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c);
        }
        return tempPath == null ? path : tempPath;
    }

    private boolean processCompletedCalculationResult() throws InterruptedException, ExecutionException {
        this.pathResult.getJob().synchToClient((LivingEntity)this.field_75515_a);
        this.func_75484_a(this.pathResult.getPath(), this.getSpeedFactor());
        this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        return false;
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.func_75500_f()) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            BlockPos pos = new BlockPos(pEx.field_75839_a, pEx.field_75837_b, pEx.field_75838_c);
            if (pEx.isOnLadder() && pExNext != null && (pEx.field_75837_b != pExNext.field_75837_b || this.field_75515_a.func_226278_cu_() > (double)pEx.field_75837_b) && this.field_75513_b.func_180495_p(pos).isLadder((IWorldReader)this.field_75513_b, pos, (LivingEntity)this.ourEntity)) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.func_70090_H()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.field_75513_b.field_73012_v.nextInt(10) == 0) {
                this.field_75511_d = !pEx.isOnLadder() && pExNext != null && pExNext.isOnLadder() ? this.getSpeedFactor() / 4.0 : this.getSpeedFactor();
            }
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(Entity parEntity) {
        int blockX = (int)Math.round(parEntity.func_226277_ct_());
        int blockY = MathHelper.func_76128_c((double)(parEntity.func_226278_cu_() - 0.2));
        int blockZ = (int)Math.round(parEntity.func_226281_cx_());
        return new BlockPos(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.func_75500_f()) {
            PathPointExtended pExNext;
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pathPointExtended = pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            if (pExNext != null && pEx.field_75839_a == pExNext.field_75839_a && pEx.field_75838_c == pExNext.field_75838_c) {
                PathPointExtended pathPointExtended2 = pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 2 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 2) : null;
            }
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        Vector3d vec3 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        BlockPos entityPos = new BlockPos((Vector3i)this.ourEntity.func_233580_cy_());
        if (vec3.func_186679_c(this.ourEntity.func_226277_ct_(), vec3.field_72448_b, this.ourEntity.func_226281_cx_()) < 0.6 && Math.abs(vec3.field_72448_b - (double)entityPos.func_177956_o()) <= 2.0) {
            double newSpeed = 0.3;
            switch (pEx.getLadderFacing()) {
                case NORTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, 0.4);
                    break;
                }
                case SOUTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, -0.4);
                    break;
                }
                case WEST: {
                    vec3 = vec3.func_72441_c(0.4, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    vec3 = vec3.func_72441_c(-0.4, 0.0, 0.0);
                    break;
                }
                case UP: {
                    vec3 = vec3.func_72441_c(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    this.field_75515_a.func_226284_e_(true);
                    this.isSneaking = true;
                    this.ourEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 0.2);
                }
            }
            if (newSpeed > 0.0) {
                if (!(this.field_75513_b.func_180495_p(this.ourEntity.func_233580_cy_()).func_177230_c() instanceof LadderBlock)) {
                    this.ourEntity.func_213317_d(this.ourEntity.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                }
                this.ourEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, newSpeed);
            } else {
                if (!this.field_75513_b.func_180495_p(entityPos.func_177977_b()).isLadder((IWorldReader)this.field_75513_b, entityPos.func_177977_b(), (LivingEntity)this.ourEntity)) {
                    return false;
                }
                this.ourEntity.func_70657_f(-0.5f);
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        int curIndex = this.func_75505_d().func_75873_e();
        if (curIndex > 0 && curIndex + 1 < this.func_75505_d().func_75874_d() && this.func_75505_d().func_75877_a((int)(curIndex - 1)).field_75837_b != pEx.field_75837_b) {
            oldIndex = curIndex + 1;
        }
        this.func_75505_d().func_75872_c(oldIndex);
        Vector3d vec3d = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        Vector3d vector3d = new Vector3d(this.ourEntity.func_226277_ct_(), vec3d.field_72448_b, this.ourEntity.func_226281_cx_());
        if (vec3d.func_72436_e(vector3d) < 0.1 && Math.abs(this.ourEntity.func_226278_cu_() - vec3d.field_72448_b) < 0.5) {
            this.func_75505_d().func_75875_a();
            if (this.func_75500_f()) {
                return true;
            }
            vec3d = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        }
        this.ourEntity.func_70605_aq().func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.getSpeedFactor());
        return false;
    }

    protected void func_75508_h() {
        Vector3d next;
        this.getSpeedFactor();
        int curNode = this.field_75514_c.func_75873_e();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.field_75514_c.func_75874_d()) {
            if (!(this.field_75514_c.func_75877_a(curNode) instanceof PathPointExtended)) {
                this.field_75514_c = this.convertPath(this.field_75514_c);
            }
            PathPointExtended pEx = (PathPointExtended)this.field_75514_c.func_75877_a(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.field_75514_c.func_75877_a(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vector3d vec3 = this.func_75502_i();
                if (vec3.field_72448_b - (double)pEx.field_75837_b < 0.001) {
                    this.field_75514_c.func_75872_c(curNodeNext);
                }
                return;
            }
        }
        this.field_188561_o = Math.max(1.2f, this.field_75515_a.func_213311_cf());
        boolean wentAhead = false;
        boolean isTracking = AbstractPathJob.trackingMap.containsValue(this.ourEntity.func_110124_au());
        HashSet<BlockPos> reached = new HashSet<BlockPos>();
        for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 4); ++i) {
            next = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, i);
            if (!(Math.abs(this.field_75515_a.func_226277_ct_() - next.field_72450_a) < (double)this.field_188561_o - Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) * 0.1) || !(Math.abs(this.field_75515_a.func_226281_cx_() - next.field_72449_c) < (double)this.field_188561_o - Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) * 0.1) || !(Math.abs(this.field_75515_a.func_226278_cu_() - next.field_72448_b) <= Math.min(1.0, Math.ceil(this.field_75515_a.func_213302_cg() / 2.0f)))) continue;
            this.field_75514_c.func_75875_a();
            wentAhead = true;
            if (!isTracking) continue;
            PathPoint point = this.field_75514_c.func_75877_a(i);
            reached.add(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c));
        }
        if (isTracking) {
            AbstractPathJob.synchToClient(reached, this.ourEntity);
            reached.clear();
        }
        if (this.field_75514_c.func_75879_b()) {
            this.onPathFinish();
            return;
        }
        if (wentAhead) {
            return;
        }
        if (curNode >= this.field_75514_c.func_75874_d() || curNode <= 1) {
            return;
        }
        Vector3d curr = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, curNode - 1);
        next = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, curNode);
        if (this.field_75515_a.func_233580_cy_().func_218137_a((IPosition)curr, 2.0) && this.field_75515_a.func_233580_cy_().func_218137_a((IPosition)next, 2.0)) {
            for (int currentIndex = curNode - 1; currentIndex > 0; --currentIndex) {
                Vector3d tempoPos = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, currentIndex);
                if (this.field_75515_a.func_233580_cy_().func_218137_a((IPosition)tempoPos, 1.0)) {
                    this.field_75514_c.func_75872_c(currentIndex);
                    continue;
                }
                if (!isTracking) continue;
                reached.add(new BlockPos(tempoPos.field_72450_a, tempoPos.field_72448_b, tempoPos.field_72449_c));
            }
        }
        if (isTracking) {
            AbstractPathJob.synchToClient(reached, this.ourEntity);
            reached.clear();
        }
    }

    private void onPathFinish() {
        this.func_75499_g();
    }

    public void recomputePath() {
    }

    protected void func_179677_a(Vector3d positionVec3) {
    }

    public boolean entityOnAndBelowPath(Entity entity, Vector3d slack) {
        Path path = this.func_75505_d();
        if (path == null) {
            return false;
        }
        int closest = path.func_75873_e();
        for (int i = 0; i < path.func_75874_d() - 1; ++i) {
            PathPoint currentPoint;
            if (closest + i < path.func_75874_d() && this.entityNearAndBelowPoint(currentPoint = path.func_75877_a(closest + i), entity, slack)) {
                return true;
            }
            if (closest - i < 0 || !this.entityNearAndBelowPoint(currentPoint = path.func_75877_a(closest - i), entity, slack)) continue;
            return true;
        }
        return false;
    }

    private boolean entityNearAndBelowPoint(PathPoint currentPoint, Entity entity, Vector3d slack) {
        return Math.abs((double)currentPoint.field_75839_a - entity.func_226277_ct_()) < slack.func_82615_a() && (double)currentPoint.field_75837_b - entity.func_226278_cu_() + slack.func_82617_b() > 0.0 && Math.abs((double)currentPoint.field_75838_c - entity.func_226281_cx_()) < slack.func_82616_c();
    }

    public void func_75499_g() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.func_75499_g();
    }

    @Override
    @Nullable
    public PathResult moveToLivingEntity(Entity e, double speed) {
        return this.moveToXYZ(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), speed);
    }

    @Override
    @Nullable
    public PathResult moveAwayFromLivingEntity(Entity e, double distance, double speed) {
        return this.moveAwayFromXYZ(new BlockPos((Vector3i)e.func_233580_cy_()), distance, speed, true);
    }

    public void func_212239_d(boolean canSwim) {
        super.func_212239_d(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getDesiredPos() {
        return this.desiredPos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }

    @Override
    public void setSwimSpeedFactor(double factor) {
        this.swimSpeedFactor = factor;
    }

    public static boolean isEqual(BlockPos coords, int x, int y, int z) {
        return coords.func_177958_n() == x && coords.func_177956_o() == y && coords.func_177952_p() == z;
    }

    public static boolean isEntityBlockLoaded(IWorld world, BlockPos pos) {
        return AdvancedPathNavigate.isEntityChunkLoaded(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static boolean isEntityChunkLoaded(IWorld world, int x, int z) {
        return AdvancedPathNavigate.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(IWorld world, ChunkPos pos) {
        return world.func_72863_F().func_222865_a(pos);
    }

    public static enum MovementType {
        WALKING,
        FLYING,
        CLIMBING;

    }
}

