/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.MagmaBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public enum SurfaceType {
    WALKABLE,
    DROPABLE,
    NOT_PASSABLE,
    FLYABLE;


    public static SurfaceType getSurfaceType(IBlockReader world, BlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof BambooBlock || block instanceof DoorBlock || block instanceof MagmaBlock) {
            return NOT_PASSABLE;
        }
        VoxelShape shape = blockState.func_196954_c(world, pos);
        if (shape.func_197758_c(Direction.Axis.Y) > 1.0) {
            return NOT_PASSABLE;
        }
        FluidState fluid = world.func_204610_c(pos);
        if (blockState.func_177230_c() == Blocks.field_150353_l || fluid != null && !fluid.func_206888_e() && (fluid.func_206886_c() == Fluids.field_204547_b || fluid.func_206886_c() == Fluids.field_207213_d)) {
            return NOT_PASSABLE;
        }
        if (SurfaceType.isWater(world, pos, blockState, fluid)) {
            return WALKABLE;
        }
        if (block instanceof AbstractSignBlock || block instanceof VineBlock) {
            return DROPABLE;
        }
        if (blockState.func_185904_a().func_76220_a() && shape.func_197758_c(Direction.Axis.X) - shape.func_197762_b(Direction.Axis.X) > 0.75 && shape.func_197758_c(Direction.Axis.Z) - shape.func_197762_b(Direction.Axis.Z) > 0.75 || blockState.func_177230_c() == Blocks.field_150433_aE && (Integer)blockState.func_177229_b((Property)SnowBlock.field_176315_a) > 1 || block instanceof CarpetBlock) {
            return WALKABLE;
        }
        return DROPABLE;
    }

    public static boolean isWater(IWorldReader world, BlockPos pos) {
        return SurfaceType.isWater((IBlockReader)world, pos, null, null);
    }

    public static boolean isWater(IBlockReader world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        if (state.func_200132_m()) {
            return false;
        }
        if (state.func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.func_204610_c(pos);
        }
        if (fluidState == null || fluidState.func_206888_e()) {
            return false;
        }
        Fluid fluid = fluidState.func_206886_c();
        return fluid == Fluids.field_204546_a || fluid == Fluids.field_207212_b;
    }
}

