/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.util;

import com.google.common.collect.AbstractIterator;
import java.util.Random;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class ShapeBuilder {
    Iterable<BlockPos> blocks;

    ShapeBuilder() {
    }

    public static ShapeBuilder start() {
        return new ShapeBuilder();
    }

    public ShapeBuilder getAllInSphereMutable(int radius, BlockPos center) {
        return this.getAllInSphereMutable(radius, center.func_177958_n(), center.func_177956_o(), center.func_177952_p());
    }

    public ShapeBuilder getAllInSphereMutable(int radius, int c1, int c2, int c3) {
        return this.getAllInCutOffSphereMutable(radius, radius, c1, c2, c3);
    }

    public ShapeBuilder getAllInCutOffSphereMutable(int radiusX, int yCutOff, BlockPos center) {
        return this.getAllInCutOffSphereMutable(radiusX, yCutOff, yCutOff, center.func_177958_n(), center.func_177956_o(), center.func_177952_p());
    }

    public ShapeBuilder getAllInCutOffSphereMutable(int radiusX, int yCutOff, int c1, int c2, int c3) {
        return this.getAllInCutOffSphereMutable(radiusX, yCutOff, yCutOff, c1, c2, c3);
    }

    public ShapeBuilder getAllInCutOffSphereMutable(int radiusX, int yCutOffMax, int yCutOffMin, BlockPos center) {
        return this.getAllInCutOffSphereMutable(radiusX, yCutOffMax, yCutOffMin, center.func_177958_n(), center.func_177956_o(), center.func_177952_p());
    }

    public ShapeBuilder getAllInCutOffSphereMutable(final int radiusX, final int yCutOffMax, final int yCutOffMin, final int c1, final int c2, final int c3) {
        final int r2 = radiusX * radiusX;
        this.blocks = () -> new AbstractIterator<BlockPos>(){
            private final BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            private int currRX = radiusX;
            private int currRY = yCutOffMax;
            private int offset = 0;
            private int phase = 1;

            protected BlockPos computeNext() {
                if (-this.currRY > yCutOffMin) {
                    return (BlockPos)this.endOfData();
                }
                if (this.isWithinRange(this.currRX, this.currRY, this.phase, this.offset, r2)) {
                    BlockPos.Mutable pos = this.mutablePos.func_181079_c(c1 + this.currRX, c2 + this.currRY, c3 + this.phase * this.offset);
                    ++this.offset;
                    return pos;
                }
                if (this.phase == 1) {
                    this.phase = -1;
                    this.offset = 1;
                } else if (this.phase == -1) {
                    this.phase = 1;
                    this.offset = 0;
                    --this.currRX;
                }
                if (-this.currRX > radiusX) {
                    --this.currRY;
                    this.currRX = radiusX;
                }
                return this.computeNext();
            }

            private boolean isWithinRange(int currentRadiusX, int currentRadiusY, int phase, int offset, int radius2) {
                return Math.round((double)currentRadiusX * (double)currentRadiusX + (double)(currentRadiusY * currentRadiusY) + (double)(phase * offset * (phase * offset))) <= (long)radius2;
            }
        };
        return this;
    }

    public ShapeBuilder getAllInRandomlyDistributedRangeYCutOffSphereMutable(int maxRadiusX, int minRadiusX, int yCutOff, Random rand, BlockPos center) {
        return this.getAllInRandomlyDistributedRangeYCutOffSphereMutable(maxRadiusX, minRadiusX, yCutOff, rand, center.func_177958_n(), center.func_177956_o(), center.func_177952_p());
    }

    public ShapeBuilder getAllInRandomlyDistributedRangeYCutOffSphereMutable(int maxRadiusX, int minRadiusX, int ycutoffmin, Random rand, int c1, int c2, int c3) {
        return this.getAllInRandomlyDistributedRangeYCutOffSphereMutable(maxRadiusX, minRadiusX, ycutoffmin, ycutoffmin, rand, c1, c2, c3);
    }

    public ShapeBuilder getAllInRandomlyDistributedRangeYCutOffSphereMutable(final int maxRadiusX, int minRadiusX, final int yCutOffMax, final int yCutOffMin, final Random rand, final int c1, final int c2, final int c3) {
        final int maxr2 = maxRadiusX * maxRadiusX;
        final int minr2 = minRadiusX * minRadiusX;
        final float rDifference = (float)minRadiusX / (float)maxRadiusX;
        this.blocks = () -> new AbstractIterator<BlockPos>(){
            private final BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            private int currRX = maxRadiusX;
            private int currRY = yCutOffMax;
            private int offset = 0;
            private int phase = 1;

            protected BlockPos computeNext() {
                if (-this.currRY > yCutOffMin) {
                    return (BlockPos)this.endOfData();
                }
                int distance = this.distance(this.currRX, this.currRY, this.phase, this.offset);
                if (distance <= minr2 || (float)distance <= (float)maxr2 * MathHelper.func_76131_a((float)rand.nextFloat(), (float)rDifference, (float)1.0f)) {
                    BlockPos.Mutable pos = this.mutablePos.func_181079_c(c1 + this.currRX, c2 + this.currRY, c3 + this.phase * this.offset);
                    ++this.offset;
                    return pos;
                }
                if (distance <= maxr2) {
                    ++this.offset;
                    return this.computeNext();
                }
                if (this.phase == 1) {
                    this.phase = -1;
                    this.offset = 1;
                } else if (this.phase == -1) {
                    this.phase = 1;
                    this.offset = 0;
                    --this.currRX;
                }
                if (-this.currRX > maxRadiusX) {
                    --this.currRY;
                    this.currRX = maxRadiusX;
                }
                return this.computeNext();
            }

            private int distance(int currentRadiusX, int currentRadiusY, int phase, int offset) {
                return (int)Math.round((double)currentRadiusX * (double)currentRadiusX + (double)(currentRadiusY * currentRadiusY) + (double)(phase * offset * (phase * offset)));
            }
        };
        return this;
    }

    public ShapeBuilder getAllInCircleMutable(final int radius, final int c1, final int c2, final int c3) {
        final int r2 = radius * radius;
        this.blocks = () -> new AbstractIterator<BlockPos>(){
            private final BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            private int totalAmount;
            private int currR = radius;
            private int offset = 0;
            private int phase = 1;

            protected BlockPos computeNext() {
                if (-this.currR > radius) {
                    return (BlockPos)this.endOfData();
                }
                if (this.isWithinRange(this.currR, this.phase, this.offset, r2)) {
                    BlockPos.Mutable pos = this.mutablePos.func_181079_c(c1 + this.currR, c2, c3 + this.phase * this.offset);
                    ++this.offset;
                    return pos;
                }
                if (this.phase == 1) {
                    this.phase = -1;
                    this.offset = 1;
                } else if (this.phase == -1) {
                    this.phase = 1;
                    this.offset = 0;
                    --this.currR;
                }
                return this.computeNext();
            }

            private boolean isWithinRange(int currentRadius, int phase, int offset, int radius2) {
                return Math.floor((double)currentRadius * (double)currentRadius + (double)(phase * offset * (phase * offset))) <= (double)radius2;
            }
        };
        return this;
    }

    public Stream<BlockPos> toStream(boolean parallel) {
        return StreamSupport.stream(this.blocks.spliterator(), parallel);
    }

    public Iterable<BlockPos> toIterable() {
        return this.blocks;
    }
}

