/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.util.ShapeBuilder;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCaveStalactites;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class WorldGenDragonCave
extends Feature<NoFeatureConfig> {
    public ResourceLocation DRAGON_CHEST;
    public ResourceLocation DRAGON_MALE_CHEST;
    public WorldGenCaveStalactites CEILING_DECO;
    public BlockState PALETTE_BLOCK1;
    public BlockState PALETTE_BLOCK2;
    public BlockState PALETTE_ORE1;
    public BlockState PALETTE_ORE2;
    public BlockState TREASURE_PILE;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public boolean isMale;
    public boolean generateGemOre = false;

    protected WorldGenDragonCave(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator chunkGenerator, Random rand, BlockPos position, NoFeatureConfig featureConfig) {
        if (!IafWorldRegistry.isDimensionListedForDragons((IServerWorld)worldIn)) {
            return false;
        }
        if (!(IafConfig.generateDragonDens && rand.nextInt(IafConfig.generateDragonDenChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((IServerWorld)worldIn, position))) {
            return false;
        }
        this.isMale = rand.nextBoolean();
        ChunkPos chunkPos = worldIn.func_217349_x(position).func_76632_l();
        position = new BlockPos((chunkPos.field_77276_a << 4) + 8, 20 + rand.nextInt(20), (chunkPos.field_77275_b << 4) + 8);
        int dragonAge = 75 + rand.nextInt(50);
        int radius = (int)((float)dragonAge * 0.2f) + rand.nextInt(4);
        this.generateCave((IWorld)worldIn, radius, 3, position, rand);
        EntityDragonBase dragon = this.createDragon(worldIn, rand, position, dragonAge);
        worldIn.func_217376_c((Entity)dragon);
        return false;
    }

    public void generateCave(IWorld worldIn, int radius, int amount, BlockPos center, Random rand) {
        ArrayList<SphereInfo> sphereList = new ArrayList<SphereInfo>();
        sphereList.add(new SphereInfo(radius, center.func_185334_h()));
        Stream<BlockPos> sphereBlocks = ShapeBuilder.start().getAllInCutOffSphereMutable(radius, radius / 2, center).toStream(false);
        Stream<BlockPos> hollowBlocks = ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(radius - 2, (int)((double)(radius - 2) * 0.75), (radius - 2) / 2, rand, center).toStream(false);
        for (int i = 0; i < amount + rand.nextInt(2); ++i) {
            Direction direction = HORIZONTALS[rand.nextInt(HORIZONTALS.length - 1)];
            int r = 2 * (int)((float)radius / 3.0f) + rand.nextInt(8);
            BlockPos centerOffset = center.func_177967_a(direction, radius - 2);
            sphereBlocks = Stream.concat(sphereBlocks, ShapeBuilder.start().getAllInCutOffSphereMutable(r, r, centerOffset).toStream(false));
            hollowBlocks = Stream.concat(hollowBlocks, ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(r - 2, (int)((double)(r - 2) * 0.75), (r - 2) / 2, rand, centerOffset).toStream(false));
            sphereList.add(new SphereInfo(r, centerOffset));
        }
        Set<BlockPos> shellBlocksSet = sphereBlocks.map(BlockPos::func_185334_h).collect(Collectors.toSet());
        Set<BlockPos> hollowBlocksSet = hollowBlocks.map(BlockPos::func_185334_h).collect(Collectors.toSet());
        shellBlocksSet.removeAll(hollowBlocksSet);
        this.createShell(worldIn, rand, shellBlocksSet);
        this.hollowOut(worldIn, hollowBlocksSet);
        this.decorateCave(worldIn, rand, hollowBlocksSet, sphereList, center);
        sphereList.clear();
    }

    public void createShell(IWorld worldIn, Random rand, Set<BlockPos> positions) {
        positions.forEach(blockPos -> {
            if (!(worldIn.func_180495_p(blockPos).func_177230_c() instanceof ContainerBlock) && worldIn.func_180495_p(blockPos).func_185887_b((IBlockReader)worldIn, blockPos) >= 0.0f) {
                boolean doOres;
                boolean bl = doOres = rand.nextInt(IafConfig.oreToStoneRatioForDragonCaves + 1) == 0;
                if (doOres) {
                    int chance = rand.nextInt(199) + 1;
                    if (chance < 30) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150366_p.func_176223_P(), 2);
                    } else if (chance > 30 && chance < 40) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150352_o.func_176223_P(), 2);
                    } else if (chance > 40 && chance < 45) {
                        worldIn.func_180501_a(blockPos, IafConfig.generateCopperOre ? IafBlockRegistry.COPPER_ORE.func_176223_P() : this.PALETTE_BLOCK1, 2);
                    } else if (chance > 45 && chance < 50) {
                        worldIn.func_180501_a(blockPos, IafConfig.generateSilverOre ? IafBlockRegistry.SILVER_ORE.func_176223_P() : this.PALETTE_BLOCK1, 2);
                    } else if (chance > 50 && chance < 60) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150365_q.func_176223_P(), 2);
                    } else if (chance > 60 && chance < 70) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150450_ax.func_176223_P(), 2);
                    } else if (chance > 70 && chance < 80) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150369_x.func_176223_P(), 2);
                    } else if (chance > 80 && chance < 90) {
                        worldIn.func_180501_a(blockPos, Blocks.field_150482_ag.func_176223_P(), 2);
                    } else if (chance > 90) {
                        worldIn.func_180501_a(blockPos, this.generateGemOre ? this.PALETTE_ORE1 : this.PALETTE_ORE2, 2);
                    }
                } else {
                    worldIn.func_180501_a(blockPos, rand.nextBoolean() ? this.PALETTE_BLOCK1 : this.PALETTE_BLOCK2, 2);
                }
            }
        });
    }

    public void hollowOut(IWorld worldIn, Set<BlockPos> positions) {
        positions.forEach(blockPos -> {
            if (!(worldIn.func_180495_p(blockPos).func_177230_c() instanceof ContainerBlock)) {
                worldIn.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        });
    }

    public void decorateCave(IWorld worldIn, Random rand, Set<BlockPos> positions, List<SphereInfo> spheres, BlockPos center) {
        for (SphereInfo sphere : spheres) {
            BlockPos pos = sphere.pos;
            int radius = sphere.radius;
            for (int i = 0; i < 15 + rand.nextInt(10); ++i) {
                this.CEILING_DECO.generate(worldIn, rand, pos.func_177981_b(radius / 2 - 1).func_177982_a(rand.nextInt(radius) - radius / 2, 0, rand.nextInt(radius) - radius / 2));
            }
        }
        int y = center.func_177956_o();
        positions.forEach(blockPos -> {
            if (blockPos.func_177956_o() < y && worldIn.func_180495_p(blockPos.func_177977_b()).func_185904_a() == Material.field_151576_e && worldIn.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a) {
                this.setGoldPile(worldIn, (BlockPos)blockPos, rand);
            }
        });
    }

    public void setGoldPile(IWorld world, BlockPos pos, Random rand) {
        if (!(world.func_180495_p(pos).func_177230_c() instanceof ContainerBlock)) {
            int chance = rand.nextInt(99) + 1;
            if (chance < 60) {
                int goldRand = Math.max(1, IafConfig.dragonDenGoldAmount) * (this.isMale ? 1 : 2);
                boolean generateGold = rand.nextInt(goldRand) == 0;
                world.func_180501_a(pos, generateGold ? (BlockState)this.TREASURE_PILE.func_206870_a((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.nextInt(7))) : Blocks.field_150350_a.func_176223_P(), 3);
            } else if (chance == 61) {
                TileEntity tileentity1;
                world.func_180501_a(pos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)HORIZONTALS[rand.nextInt(3)]), 2);
                if (world.func_180495_p(pos).func_177230_c() instanceof ChestBlock && (tileentity1 = world.func_175625_s(pos)) instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity1).func_189404_a(this.isMale ? this.DRAGON_MALE_CHEST : this.DRAGON_CHEST, rand.nextLong());
                }
            }
        }
    }

    abstract EntityDragonBase createDragon(ISeedReader var1, Random var2, BlockPos var3, int var4);

    private static class SphereInfo {
        int radius;
        BlockPos pos;

        private SphereInfo(int radius, BlockPos pos) {
            this.radius = radius;
            this.pos = pos;
        }
    }
}

