/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import org.infernalstudios.infernalexp.entities.BlindsightEntity;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IETags;

public class DullthornsBlock
extends BushBlock
implements IForgeShearable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    public static final BooleanProperty TIP = BooleanProperty.func_177716_a((String)"tip");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);

    public DullthornsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)TIP, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack((IItemProvider)IEItems.DULLTHORNS.get()));
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_235714_a_(IETags.Blocks.DULLTHORNS_GROUND);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177984_a();
        if (worldIn.func_175623_d(blockpos)) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_203425_a((Block)this)) {
                ++i;
            }
            if (i < 9) {
                int j = (Integer)state.func_177229_b((Property)AGE);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.func_175656_a(blockpos, this.func_176223_P());
                        BlockState blockstate = (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0));
                        worldIn.func_180501_a(pos, blockstate, 4);
                        blockstate.func_215697_a((World)worldIn, blockpos, (Block)this, pos, false);
                    } else {
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public boolean bonemealGrow(BlockState state, World worldIn, BlockPos pos) {
        BlockPos posUp = pos.func_177984_a();
        if (worldIn.func_175623_d(posUp)) {
            worldIn.func_175656_a(posUp, this.func_176223_P());
            BlockState blockstate = (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0));
            worldIn.func_180501_a(pos, blockstate, 4);
            blockstate.func_215697_a(worldIn, posUp, (Block)this, pos, false);
            return true;
        }
        if (worldIn.func_180495_p(posUp).func_177230_c() == IEBlocks.DULLTHORNS.get()) {
            return ((DullthornsBlock)worldIn.func_180495_p(posUp).func_177230_c()).bonemealGrow(state, worldIn, posUp);
        }
        return false;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.func_201670_d()) {
            if (entityIn instanceof LivingEntity && entityIn.func_70089_S() && !(entityIn instanceof BlindsightEntity)) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                livingEntity.func_195064_c(new EffectInstance((Effect)IEEffects.LUMINOUS.get(), 200, 0, true, true));
            }
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState aboveBlockState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a());
        boolean aboveIsDullthorns = aboveBlockState.func_203425_a((Block)IEBlocks.DULLTHORNS.get());
        if (aboveIsDullthorns) {
            return this.func_176223_P();
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)TIP, (Comparable)Boolean.valueOf(true));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState aboveBlockState = worldIn.func_180495_p(currentPos.func_177984_a());
        boolean aboveIsDullthorns = aboveBlockState.func_203425_a((Block)IEBlocks.DULLTHORNS.get());
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (!aboveIsDullthorns && !((Boolean)stateIn.func_177229_b((Property)TIP)).booleanValue()) {
            return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : (BlockState)stateIn.func_206870_a((Property)TIP, (Comparable)Boolean.valueOf(true));
        }
        if (aboveIsDullthorns && ((Boolean)stateIn.func_177229_b((Property)TIP)).booleanValue()) {
            return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : (BlockState)stateIn.func_206870_a((Property)TIP, (Comparable)Boolean.valueOf(false));
        }
        return stateIn;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vector3d = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
        builder.func_206894_a(new Property[]{TIP});
    }
}

