/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.access.AbstractArrowEntityAccess;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEEffects;

@OnlyIn(value=Dist.CLIENT)
public class DynamicLightingHandler {
    private static final Minecraft MinecraftInstance = Minecraft.func_71410_x();
    public static final Map<BlockPos, LightData> LIGHT_SOURCES = new ConcurrentHashMap<BlockPos, LightData>();

    public static void tick(LivingEntity entity) {
        if (entity != null && DynamicLightingHandler.MinecraftInstance.field_71439_g != null && DynamicLightingHandler.MinecraftInstance.field_71439_g.field_70173_aa % (int)InfernalExpansionConfig.ClientConfig.LUMINOUS_REFRESH_DELAY.getDouble() == 0) {
            if (DynamicLightingHandler.shouldGlow(entity)) {
                LIGHT_SOURCES.put(entity.func_233580_cy_(), new LightData(DynamicLightingHandler.getTimeAmplifier(entity)));
            }
            if (entity == DynamicLightingHandler.MinecraftInstance.field_71439_g) {
                LIGHT_SOURCES.forEach((pos, data) -> {
                    if (data.time == 0.0) {
                        data.shouldKeep = false;
                    }
                    if (data.time == 20.0 * data.amplifier || !data.shouldKeep) {
                        DynamicLightingHandler.MinecraftInstance.field_71441_e.func_72863_F().func_212863_j_().func_215568_a(pos);
                    }
                    data.time -= (double)((int)InfernalExpansionConfig.ClientConfig.LUMINOUS_REFRESH_DELAY.getDouble());
                });
                LIGHT_SOURCES.entrySet().removeIf(entry -> !((LightData)entry.getValue()).shouldKeep);
            }
        }
    }

    public static void tick(AbstractArrowEntity entity) {
        if (entity != null && DynamicLightingHandler.MinecraftInstance.field_71439_g != null && DynamicLightingHandler.MinecraftInstance.field_71439_g.field_70173_aa % (int)InfernalExpansionConfig.ClientConfig.LUMINOUS_REFRESH_DELAY.getDouble() == 0 && DynamicLightingHandler.shouldGlow(entity)) {
            LIGHT_SOURCES.put(entity.func_233580_cy_(), new LightData(0.5));
        }
    }

    public static int getTimeAmplifier(LivingEntity entity) {
        EffectInstance luminousEffect = entity.func_70660_b((Effect)IEEffects.LUMINOUS.get());
        if (luminousEffect != null) {
            return luminousEffect.func_76458_c() == 0 ? 1 : 2;
        }
        return 1;
    }

    public static boolean shouldGlow(AbstractArrowEntity entity) {
        return ((AbstractArrowEntityAccess)entity).getGlow();
    }

    public static boolean shouldGlow(LivingEntity entity) {
        return entity.func_70644_a((Effect)IEEffects.LUMINOUS.get());
    }

    public static class LightData {
        public boolean shouldKeep = true;
        public double time;
        public double amplifier;

        public LightData(double amplifier) {
            this.amplifier = amplifier;
            this.time = 20.0 * amplifier;
        }
    }
}

