/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.infernalstudios.infernalexp.InfernalExpansion;

public class VolineEatTable
extends JsonReloadListener {
    private static final Gson GSON_INSTANCE = new GsonBuilder().create();
    private static final Map<Item, Map<Item, Integer>> VOLINE_EAT_TABLE = new HashMap<Item, Map<Item, Integer>>();

    public VolineEatTable() {
        super(GSON_INSTANCE, "loot_tables/gameplay");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ResourceLocation resourceLocation = new ResourceLocation("infernalexp", "loot_tables/gameplay/voline_eat_table.json");
        try {
            for (IResource iResource : resourceManagerIn.func_199004_b(resourceLocation)) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(iResource.func_199027_b(), StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        JsonObject jsonObject = (JsonObject)JSONUtils.func_193839_a((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                        if (jsonObject == null) continue;
                        for (final JsonElement entry : jsonObject.getAsJsonArray("entries")) {
                            VOLINE_EAT_TABLE.put((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getAsJsonObject().get("accepted_item").getAsString())), (Map<Item, Integer>)new HashMap<Item, Integer>(){
                                {
                                    for (JsonElement item : entry.getAsJsonObject().getAsJsonArray("returned_items")) {
                                        this.put(ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.getAsJsonObject().get("item").getAsString())), item.getAsJsonObject().get("amount").getAsInt());
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (IOException | RuntimeException exception) {
                    InfernalExpansion.LOGGER.error("Couldn't read voline eat table list {} in data pack {}", (Object)resourceLocation, (Object)iResource.func_199026_d(), (Object)exception);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iResource);
                }
            }
        }
        catch (IOException exception) {
            InfernalExpansion.LOGGER.error("Couldn't read voline eat table from {}", (Object)resourceLocation, (Object)exception);
        }
    }

    public Map<Item, Map<Item, Integer>> getVolineEatTable() {
        return VOLINE_EAT_TABLE;
    }
}

