/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.List;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IEParticleTypes;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class AscusBombEntity
extends ProjectileItemEntity
implements IRendersAsItem {
    public AscusBombEntity(EntityType<? extends AscusBombEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public AscusBombEntity(World world, LivingEntity livingEntity) {
        super((EntityType)IEEntityTypes.ASCUS_BOMB.get(), livingEntity, world);
    }

    protected Item func_213885_i() {
        return (Item)IEItems.ASCUS_BOMB.get();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 0.5f);
            this.spawnExplosionCloud();
            this.func_70106_y();
            this.initialEffect(result);
            this.spawnLingeringCloud();
        }
    }

    private void spawnExplosionCloud() {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.6, this.func_226281_cx_());
        areaeffectcloudentity.func_184483_a(0.1f);
        areaeffectcloudentity.func_184485_d(0);
        areaeffectcloudentity.func_184486_b(10);
        areaeffectcloudentity.func_184487_c(0.0f);
        areaeffectcloudentity.func_195059_a((IParticleData)ParticleTypes.field_197627_t);
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    private void spawnLingeringCloud() {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 8);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
        areaeffectcloudentity.func_184496_a(new EffectInstance((Effect)IEEffects.INFECTION.get(), 300));
        areaeffectcloudentity.func_195059_a((IParticleData)IEParticleTypes.INFECTION.get());
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    private void initialEffect(RayTraceResult result) {
        if (!this.field_70170_p.func_201670_d()) {
            Entity entity = result.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)result).func_216348_a() : null;
            AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
            List livingEntities = this.field_70170_p.func_217357_a(LivingEntity.class, axisAlignedBB);
            if (!livingEntities.isEmpty()) {
                for (LivingEntity livingEntity : livingEntities) {
                    double distanceSq = this.func_70068_e((Entity)livingEntity);
                    if (!(distanceSq < 16.0)) continue;
                    double durationMultiplier = 1.0 - Math.sqrt(distanceSq) / 4.0;
                    if (livingEntity == entity) {
                        durationMultiplier = 1.0;
                    }
                    int duration = (int)(durationMultiplier * 300.0 + 0.5);
                    livingEntity.func_195064_c(new EffectInstance((Effect)IEEffects.INFECTION.get(), duration));
                }
            }
        }
    }
}

