/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.network.IENetworkHandler;
import org.infernalstudios.infernalexp.network.SpawnInfernalPaintingPacket;

public class InfernalPaintingEntity
extends PaintingEntity {
    public InfernalPaintingEntity(EntityType<? extends InfernalPaintingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public InfernalPaintingEntity(World worldIn, BlockPos pos, Direction facing) {
        this((EntityType<? extends InfernalPaintingEntity>)((EntityType)IEEntityTypes.INFERNAL_PAINTING.get()), worldIn);
        PaintingType paintingType;
        this.field_174861_a = pos;
        this.func_174859_a(facing);
        ArrayList<PaintingType> paintings = new ArrayList<PaintingType>();
        int maxSurfaceArea = 0;
        Iterator iterator = ForgeRegistries.PAINTING_TYPES.iterator();
        while (iterator.hasNext()) {
            this.field_70522_e = paintingType = (PaintingType)iterator.next();
            this.func_174859_a(facing);
            if (!this.func_70518_d() || !paintingType.getRegistryName().func_110624_b().equals("infernalexp")) continue;
            paintings.add(paintingType);
            int surfaceArea = paintingType.func_200834_b() * paintingType.func_200832_c();
            if (surfaceArea <= maxSurfaceArea) continue;
            maxSurfaceArea = surfaceArea;
        }
        if (!paintings.isEmpty()) {
            Iterator iterator2 = paintings.iterator();
            while (iterator2.hasNext()) {
                paintingType = (PaintingType)iterator2.next();
                if (paintingType.func_200834_b() * paintingType.func_200832_c() >= maxSurfaceArea) continue;
                iterator2.remove();
            }
            this.field_70522_e = (PaintingType)paintings.get(this.field_70146_Z.nextInt(paintings.size()));
        }
        this.func_174859_a(facing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfernalPaintingEntity(World world, BlockPos pos, Direction facing, PaintingType art) {
        this(world, pos, facing);
        this.field_70522_e = art;
        this.func_174859_a(facing);
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (brokenEntity instanceof PlayerEntity && ((PlayerEntity)brokenEntity).field_71075_bZ.field_75098_d) {
                return;
            }
            this.func_199703_a((IItemProvider)IEItems.INFERNAL_PAINTING.get());
        }
    }

    public IPacket<?> func_213297_N() {
        return IENetworkHandler.INSTANCE.toVanillaPacket((Object)new SpawnInfernalPaintingPacket(this), NetworkDirection.PLAY_TO_CLIENT);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ((Item)IEItems.INFERNAL_PAINTING.get()).func_190903_i();
    }
}

