/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;

@MethodsReturnNonnullByDefault
public class ThrowableBrickEntity
extends ProjectileItemEntity {
    public ThrowableBrickEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrowableBrickEntity(World world, LivingEntity livingEntity) {
        super((EntityType)IEEntityTypes.THROWABLE_BRICK.get(), livingEntity, world);
    }

    public ThrowableBrickEntity(EntityType<? extends ProjectileItemEntity> type, LivingEntity livingEntity, World world) {
        super(type, livingEntity, world);
    }

    protected Item func_213885_i() {
        return Items.field_151118_aC;
    }

    protected double getSpeedMultiplier() {
        return 0.79;
    }

    protected float getDamage() {
        return 2.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @ParametersAreNonnullByDefault
    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        if (!this.func_130014_f_().func_201670_d()) {
            BlockPos pos = result.func_216350_a();
            Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
            if (block == IEBlocks.QUARTZ_GLASS.get() || block == IEBlocks.QUARTZ_GLASS_PANE.get()) {
                this.func_130014_f_().func_184133_a(null, pos, IESoundEvents.QUARTZ_GLASS_TYPE.func_185846_f(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if ((block instanceof GlassBlock || block instanceof PaneBlock) && block != Blocks.field_150411_aY && block != IEBlocks.QUARTZ_GLASS.get() && block != IEBlocks.QUARTZ_GLASS_PANE.get()) {
                this.func_130014_f_().func_175655_b(pos, false);
                this.func_213317_d(this.func_213322_ci().func_186678_a(this.getSpeedMultiplier()));
            } else {
                ItemEntity itemEntity = new ItemEntity(this.func_130014_f_(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213885_i().func_190903_i());
                this.func_130014_f_().func_217376_c((Entity)itemEntity);
                this.func_70106_y();
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        if (!this.func_130014_f_().func_201670_d()) {
            Entity target = result.func_216348_a();
            target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), this.getDamage());
            this.func_70106_y();
        }
    }
}

