/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.IBucketable;
import org.infernalstudios.infernalexp.entities.IResizable;
import org.infernalstudios.infernalexp.entities.ai.EatItemsGoal;
import org.infernalstudios.infernalexp.entities.ai.TargetWithEffectGoal;
import org.infernalstudios.infernalexp.events.MiscEvents;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class VolineEntity
extends MonsterEntity
implements IBucketable,
IResizable {
    private static final Predicate<LivingEntity> TARGETABLE_MAGMA_CUBES = livingEntity -> {
        MagmaCubeEntity magmaCubeEntity = (MagmaCubeEntity)livingEntity;
        return magmaCubeEntity.func_189101_db() && !magmaCubeEntity.func_145818_k_();
    };
    private static final DataParameter<Float> VOLINE_SIZE = EntityDataManager.func_187226_a(VolineEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(VolineEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean isEating;

    public VolineEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setEntitySize(1.0f + this.field_70170_p.func_201674_k().nextFloat() * 0.4f);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new VolineEatItemsGoal(this, MiscEvents.getVolineEatTable(), 32.0, this.func_233637_b_(Attributes.field_233821_d_) * 2.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_) * 1.2, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_)));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractPiglinEntity.class, 16.0f, this.func_233637_b_(Attributes.field_233821_d_) * 2.0, this.func_233637_b_(Attributes.field_233821_d_) * 1.5));
        this.field_70714_bg.func_75776_a(5, (Goal)new PanicGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_) * 2.0));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.VOLINE_ATTACK_FIRE_RESISTANCE.getBoolean()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new TargetWithEffectGoal((MobEntity)this, LivingEntity.class, true, false, Effects.field_76426_n, null));
        }
        if (InfernalExpansionConfig.MobInteractions.VOLINE_ATTACK_PLAYER.getBoolean()) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        }
        if (InfernalExpansionConfig.MobInteractions.VOLINE_ATTACK_MAGMA_CUBE.getBoolean()) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MagmaCubeEntity.class, 10, true, true, TARGETABLE_MAGMA_CUBES));
        }
    }

    public void func_70636_d() {
        if (this.func_233637_b_(Attributes.field_233821_d_) <= 0.0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, this.func_226282_d_(0.5), this.func_226278_cu_() + 1.6, this.func_226287_g_(0.5), 0.0, 0.07, 0.0);
        }
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VOLINE_SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    @Override
    public float getEntitySize() {
        return ((Float)this.field_70180_af.func_187225_a(VOLINE_SIZE)).floatValue();
    }

    @Override
    public void setEntitySize(float size) {
        size = Math.min(size, 2.0f);
        this.field_70180_af.func_187227_b(VOLINE_SIZE, (Object)Float.valueOf(size));
        this.func_226264_Z_();
        this.func_213323_x_();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)(0.5f - (size - 1.0f) / 2.0f));
    }

    @Override
    public boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean fromBucket) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)fromBucket);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Size", this.getEntitySize());
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    public void func_70037_a(CompoundNBT compound) {
        float size = Math.max(compound.func_74760_g("Size"), 1.0f);
        this.setEntitySize(size);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        super.func_70037_a(compound);
    }

    public void func_213323_x_() {
        super.func_213323_x_();
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(0.85f * this.getEntitySize());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (VOLINE_SIZE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)IESoundEvents.VOLINE_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)IESoundEvents.VOLINE_HURT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.VOLINE_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public boolean func_230279_az_() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEating() {
        return this.isEating;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isEating = false;
        } else if (id == 9) {
            this.isEating = true;
        } else {
            super.func_70103_a(id);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        return IBucketable.tryBucketEntity(playerIn, hand, this).orElse(super.func_230254_b_(playerIn, hand));
    }

    @Override
    public void copyToStack(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        IBucketable.copyToStack((MobEntity)this, stack);
        compoundNBT.func_74776_a("Size", this.getEntitySize());
    }

    @Override
    public void copyFromAdditional(CompoundNBT compound) {
        IBucketable.copyFromAdditional((MobEntity)this, compound);
        if (compound.func_150297_b("Size", 99)) {
            this.setEntitySize(compound.func_74760_g("Size"));
        }
    }

    @Override
    public SoundEvent getBucketedSound() {
        return SoundEvents.field_187633_N;
    }

    @Override
    public ItemStack getBucketItem() {
        return new ItemStack((IItemProvider)IEItems.VOLINE_BUCKET.get());
    }

    public static class VolineEatItemsGoal
    extends EatItemsGoal<VolineEntity> {
        private final Map<Item, Map<Item, Integer>> eatItemsMap;

        public VolineEatItemsGoal(VolineEntity entityIn, Map<Item, Map<Item, Integer>> itemsToEat, double range, double speedIn) {
            super(entityIn, itemsToEat.keySet(), range, speedIn);
            this.eatItemsMap = itemsToEat;
        }

        @Override
        public void consumeItem() {
            Map<Item, Integer> eatItem;
            ((VolineEntity)this.entityIn).setEntitySize(((VolineEntity)this.entityIn).getEntitySize() + 0.2f);
            Item itemReference = this.itemInstance.func_92059_d().func_77973_b();
            super.consumeItem();
            if (itemReference == Items.field_151153_ao) {
                ((VolineEntity)this.entityIn).func_195064_c(new EffectInstance(Effects.field_76428_l, 100, 1));
                ((VolineEntity)this.entityIn).func_195064_c(new EffectInstance(Effects.field_76444_x, 2400, 0));
            }
            if ((eatItem = this.eatItemsMap.get(itemReference)) != null) {
                for (Map.Entry<Item, Integer> item : eatItem.entrySet()) {
                    ((VolineEntity)this.entityIn).func_70099_a(new ItemStack((IItemProvider)item.getKey(), item.getValue().intValue()), 1.0f);
                }
            }
        }
    }
}

