/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities.ai;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.tags.ITag;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class AvoidBlockGoal
extends Goal {
    protected final SlimeEntity entity;
    protected Optional<BlockPos> avoidBlockPos;
    protected final int avoidDistance;
    protected final ITag avoidBlocks;

    public AvoidBlockGoal(SlimeEntity entityIn, ITag.INamedTag<Block> blocksToAvoidIn, int avoidDistanceIn) {
        this(entityIn, blocksToAvoidIn, p_200828_0_ -> true, avoidDistanceIn, EntityPredicates.field_188444_d::test);
    }

    private AvoidBlockGoal(SlimeEntity entityIn, ITag.INamedTag<Block> blocksToAvoidIn, Predicate<LivingEntity> targetPredicate, int distance, Predicate<LivingEntity> p_i48859_9_) {
        this.entity = entityIn;
        this.avoidBlocks = blocksToAvoidIn;
        this.avoidDistance = distance;
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        this.avoidBlockPos = BlockPos.func_239584_a_((BlockPos)this.entity.func_233580_cy_(), (int)this.avoidDistance, (int)4, pos -> this.entity.field_70170_p.func_180495_p(pos).func_235714_a_(this.avoidBlocks));
        return this.avoidBlockPos.isPresent() && this.entity.func_70605_aq() instanceof SlimeEntity.MoveHelperController;
    }

    public void func_75249_e() {
        super.func_75249_e();
    }

    public boolean func_75253_b() {
        this.avoidBlockPos = BlockPos.func_239584_a_((BlockPos)this.entity.func_233580_cy_(), (int)this.avoidDistance, (int)4, pos -> this.entity.field_70170_p.func_180495_p(pos).func_235714_a_(this.avoidBlocks));
        return this.avoidBlockPos.isPresent() && this.entity.func_70092_e((double)this.avoidBlockPos.get().func_177958_n(), (double)this.avoidBlockPos.get().func_177956_o(), (double)this.avoidBlockPos.get().func_177952_p()) <= (double)this.avoidDistance;
    }

    public void func_75251_c() {
        this.avoidBlockPos = null;
    }

    public void func_75246_d() {
        this.faceAway();
        ((SlimeEntity.MoveHelperController)this.entity.func_70605_aq()).func_179921_a(1.0);
    }

    private void faceAway() {
        double d0 = (double)this.avoidBlockPos.get().func_177958_n() - this.entity.func_226277_ct_();
        double d2 = (double)this.avoidBlockPos.get().func_177952_p() - this.entity.func_226281_cx_();
        double d1 = ((double)this.avoidBlockPos.get().func_177956_o() + this.entity.func_174813_aQ().field_72337_e) / 2.0 - this.entity.func_226280_cw_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
        this.entity.field_70125_A = this.updateRotation(this.entity.field_70125_A, f1, 10.0f);
        this.entity.field_70177_z = this.updateRotation(this.entity.field_70177_z, f + 180.0f, 10.0f);
        ((SlimeEntity.MoveHelperController)this.entity.func_70605_aq()).func_179920_a(this.entity.field_70177_z, false);
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }
}

