/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.events;

import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.init.IECarvers;
import org.infernalstudios.infernalexp.init.IEConfiguredFeatures;
import org.infernalstudios.infernalexp.init.IEConfiguredStructures;
import org.infernalstudios.infernalexp.init.IEFeatures;
import org.infernalstudios.infernalexp.init.IEStructures;
import org.infernalstudios.infernalexp.init.IESurfaceBuilders;
import org.infernalstudios.infernalexp.world.type.CompatWorldType;

@Mod.EventBusSubscriber(modid="infernalexp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldEvents {
    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IEFeatures.features.forEach(feature -> event.getRegistry().register((IForgeRegistryEntry)feature));
    }

    @SubscribeEvent
    public static void registerStructures(RegistryEvent.Register<Structure<?>> event) {
        IEStructures.structures.forEach(structure -> event.getRegistry().register((IForgeRegistryEntry)structure));
    }

    @SubscribeEvent
    public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        IESurfaceBuilders.surfaceBuilders.forEach(surfaceBuilder -> event.getRegistry().register((IForgeRegistryEntry)surfaceBuilder));
    }

    @SubscribeEvent
    public static void registerWorldCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
        IECarvers.carvers.forEach(carver -> event.getRegistry().register((IForgeRegistryEntry)carver));
    }

    @SubscribeEvent
    public static void registerWorldTypes(RegistryEvent.Register<ForgeWorldType> event) {
        event.getRegistry().register(new CompatWorldType().setRegistryName(new ResourceLocation("infernalexp", "compat_world_type")));
    }

    @SubscribeEvent
    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            try {
                Method GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                ResourceLocation cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)world.func_72863_F().field_186029_c, new Object[0])));
                if (cgRL != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                InfernalExpansion.LOGGER.error("Was unable to check if " + world.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator");
            }
            if (world.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && world.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap tempMap = new HashMap(world.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            IEStructures.structures.forEach(structure -> {
                StructureSeparationSettings cfr_ignored_0 = (StructureSeparationSettings)tempMap.putIfAbsent(structure, DimensionStructuresSettings.field_236191_b_.get((Object)structure));
            });
            world.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        ResourceLocation name = event.getName();
        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)name);
        if (biome == Biomes.field_235253_az_) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, IEConfiguredFeatures.ORE_GLOWSILK_COCOON);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, IEConfiguredFeatures.PATCH_CRIMSON_CAP);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, IEConfiguredFeatures.SHROOMLIGHT_TEAR);
        } else if (biome == Biomes.field_235251_aB_) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, IEConfiguredFeatures.ORE_GLOWSILK_COCOON);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, IEConfiguredFeatures.ORE_BASALT_IRON_BASALT_DELTA);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, IEConfiguredFeatures.BASALTIC_MAGMA);
            event.getGeneration().func_242516_a(IEConfiguredStructures.STRIDER_ALTAR);
        } else if (biome == Biomes.field_235250_aA_) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, IEConfiguredFeatures.PATCH_WARPED_CAP);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, IEConfiguredFeatures.SHROOMLIGHT_TEAR);
        } else if (biome == Biomes.field_235252_ay_) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, IEConfiguredFeatures.ORE_BASALT_IRON_BASALT_DELTA);
            event.getGeneration().func_242516_a(IEConfiguredStructures.SOUL_SAND_VALLEY_RUIN);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, IEConfiguredFeatures.PATCH_BURIED_BONE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, IEConfiguredFeatures.ORE_SOUL_STONE);
        } else if (biome == Biomes.field_235254_j_) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, IEConfiguredFeatures.PATCH_PLANTED_QUARTZ);
        }
    }
}

