/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.util.ShroomloinType;

public final class IEShroomloinTypes {
    private static final List<ShroomloinType> SHROOMLOIN_TYPES = new ArrayList<ShroomloinType>(34);
    public static final ShroomloinType BLACK_PUFF = IEShroomloinTypes.registerWithIEDirectory("black_puff", "byg", "black_puff");
    public static final ShroomloinType BLOOD = IEShroomloinTypes.registerWithIEDirectory("blood_mushroom", "undergarden", "blood");
    public static final ShroomloinType BLUE = IEShroomloinTypes.registerWithIEDirectory("blue_mushroom", "shroomed", "blue_mushroom");
    public static final ShroomloinType BLUE_GLOWSHROOM = IEShroomloinTypes.registerWithIEDirectory("blue_glowshroom", "byg", "blue_glowshroom");
    public static final ShroomloinType BROWN = IEShroomloinTypes.registerWithIEDirectory(Items.field_221692_bh, "infernalexp", "brown");
    public static final ShroomloinType BULBIS_ANOMALY = IEShroomloinTypes.registerWithIEDirectory("bulbis_anomaly", "byg", "bulbis_anomaly");
    public static final ShroomloinType CRIMSON = IEShroomloinTypes.registerWithIEDirectory(Items.field_234722_bw_, "infernalexp", "crimson");
    public static final ShroomloinType DEATH_CAP = IEShroomloinTypes.registerWithIEDirectory("death_cap", "byg", "death_cap");
    public static final ShroomloinType EMBUR = IEShroomloinTypes.registerWithIEDirectory("embur_wart", "byg", "embur_wart");
    public static final ShroomloinType FAIRY_RING = IEShroomloinTypes.registerWithIEDirectory("fairy_ring_mushroom", "habitat", "fairy_ring_mushroom");
    public static final ShroomloinType FUNGAL_IMPARIUS = IEShroomloinTypes.registerWithIEDirectory("fungal_imparius", "byg", "fungal_imparius");
    public static final ShroomloinType GLOWSHROOM_BOP = IEShroomloinTypes.registerWithIEDirectory("glowshroom", "biomesoplenty", "glowshroom");
    public static final ShroomloinType GLOWSHROOM_DARKER_DEPTHS = IEShroomloinTypes.registerWithIEDirectory("glowshroom", "darkerdepths", "glowshroom");
    public static final ShroomloinType GLOWSHROOM_QUARK = IEShroomloinTypes.registerWithIEDirectory("glowshroom", "quark", "glowshroom");
    public static final ShroomloinType GREEN_MUSHROOM = IEShroomloinTypes.registerWithIEDirectory("green_mushroom", "byg", "green_mushroom");
    public static final ShroomloinType IMPARIUS_MUSHROOM = IEShroomloinTypes.registerWithIEDirectory("imparius_mushroom", "byg", "imparius_mushroom");
    public static final ShroomloinType INDIGO = IEShroomloinTypes.registerWithIEDirectory("indigo_mushroom", "undergarden", "indigo_mushroom");
    public static final ShroomloinType INK = IEShroomloinTypes.registerWithIEDirectory("ink_mushroom", "undergarden", "ink_mushroom");
    public static final ShroomloinType LUMINOUS = IEShroomloinTypes.registerWithIEDirectory("luminous_fungus", "infernalexp", "luminous");
    public static final ShroomloinType MASS = IEShroomloinTypes.registerWithIEDirectory("lightcap", "twist", "lightcap");
    public static final ShroomloinType ORANGE = IEShroomloinTypes.registerWithIEDirectory("orange_mushroom", "shroomed", "orange_mushroom");
    public static final ShroomloinType PIZZA = IEShroomloinTypes.registerWithIEDirectory((Item)null, "infernalexp", "pizza");
    public static final ShroomloinType POISE = IEShroomloinTypes.registerWithIEDirectory("poise_bush", "endergetic", "poise_bush");
    public static final ShroomloinType PURPLE = IEShroomloinTypes.registerWithIEDirectory("purple_mushroom", "shroomed", "purple_mushroom");
    public static final ShroomloinType PURPLE_GLOWSHROOM = IEShroomloinTypes.registerWithIEDirectory("purple_glowshroom", "byg", "purple_glowshroom");
    public static final ShroomloinType RED = IEShroomloinTypes.registerWithIEDirectory(Items.field_221694_bi, "infernalexp", "red");
    public static final ShroomloinType SHULKREN_FUNGUS = IEShroomloinTypes.registerWithIEDirectory("shulkren_fungus", "byg", "shulkren_fungus");
    public static final ShroomloinType SOUL_SHROOM = IEShroomloinTypes.registerWithIEDirectory("soul_shroom", "byg", "soul_shroom");
    public static final ShroomloinType SYTHIAN_FUNGUS = IEShroomloinTypes.registerWithIEDirectory("sythian_fungus", "byg", "sythian_fungus");
    public static final ShroomloinType TOADSTOOL = IEShroomloinTypes.registerWithIEDirectory("toadstool", "biomesoplenty", "toadstool");
    public static final ShroomloinType VEIL = IEShroomloinTypes.registerWithIEDirectory("veil_mushroom", "undergarden", "veil_mushroom");
    public static final ShroomloinType WARPED = IEShroomloinTypes.registerWithIEDirectory(Items.field_234723_bx_, "infernalexp", "warped");
    public static final ShroomloinType WEEPING_MILKCAP = IEShroomloinTypes.registerWithIEDirectory("weeping_milkcap", "byg", "weeping_milkcap");
    public static final ShroomloinType WOOD_BLEWIT = IEShroomloinTypes.registerWithIEDirectory("wood_blewit", "byg", "wood_blewit");

    private static ShroomloinType registerWithIEDirectory(String itemName, String namespace, String name) {
        return IEShroomloinTypes.registerWithIEDirectory(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, itemName)), namespace, name);
    }

    private static ShroomloinType registerWithIEDirectory(@Nullable Item item, String namespace, String name) {
        return IEShroomloinTypes.registerWithIEDirectory(() -> item, namespace, name);
    }

    private static ShroomloinType registerWithIEDirectory(@Nullable Supplier<Item> item, String namespace, String name) {
        if (name == "glowshroom") {
            return IEShroomloinTypes.register(new ShroomloinType(item, new ResourceLocation(namespace, name), new ResourceLocation("infernalexp", "textures/entity/shroomloin/glowshroom_" + namespace + ".png"), new ResourceLocation("infernalexp", "textures/entity/shroomloin/glowshroom_" + namespace + "_glow.png")));
        }
        return IEShroomloinTypes.register(new ShroomloinType(item, new ResourceLocation(namespace, name), new ResourceLocation("infernalexp", "textures/entity/shroomloin/" + name + ".png"), new ResourceLocation("infernalexp", "textures/entity/shroomloin/" + name + "_glow.png")));
    }

    private static ShroomloinType register(ShroomloinType shroomloinType) {
        SHROOMLOIN_TYPES.add(shroomloinType);
        return shroomloinType;
    }

    public static void registerAll() {
        for (ShroomloinType shroomloinType : SHROOMLOIN_TYPES) {
            ShroomloinType.registerShroomloinType(shroomloinType);
        }
    }
}

