/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.items;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.infernalstudios.infernalexp.entities.IBucketable;

public class EntityBucketItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;
    private final Supplier<SoundEvent> emptyingSoundSupplier;

    public EntityBucketItem(Supplier<EntityType<?>> entityType, Fluid fluid, Supplier<SoundEvent> emptyingSound, Item.Properties builder) {
        super(fluid, builder);
        this.entityTypeSupplier = entityType;
        this.emptyingSoundSupplier = emptyingSound;
    }

    public void func_203792_a(World worldIn, ItemStack stack, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            this.placeEntity((ServerWorld)worldIn, stack, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, this.emptyingSoundSupplier.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeEntity(ServerWorld worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityTypeSupplier.get().func_220331_a(worldIn, stack, null, pos, SpawnReason.BUCKET, true, true);
        if (entity instanceof IBucketable) {
            IBucketable bucketable = (IBucketable)entity;
            bucketable.copyFromAdditional(stack.func_196082_o());
            bucketable.setFromBucket(true);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        BlockRayTraceResult rayTraceResult = EntityBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        if (!(worldIn instanceof ServerWorld)) {
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        BlockPos pos = rayTraceResult.func_216350_a();
        if (!(worldIn.func_180495_p(pos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        return actionResult;
    }
}

