/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.infernalstudios.infernalexp.capabilities.IWhipUpdate;
import org.infernalstudios.infernalexp.capabilities.WhipUpdateCapability;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.network.IENetworkHandler;
import org.infernalstudios.infernalexp.network.WhipReachPacket;

public class WhipItem
extends TieredItem
implements IVanishable {
    private final float attackDamage;
    private final float attackSpeed;

    public WhipItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, builderIn);
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("\u00a76Hold right click to charge, then when fully charged, release to strike!"));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack itemStack = new ItemStack((IItemProvider)this);
            if (itemStack.func_77969_a(((WhipItem)IEItems.KINETIC_TONGUE_WHIP.get()).func_190903_i())) {
                itemStack.func_77966_a(Enchantments.field_180313_o, 3);
            }
            items.add((Object)itemStack);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entityLiving;
            this.setCharging(stack, false);
            int ticksSinceStart = this.func_77626_a(stack) - timeLeft;
            if (ticksSinceStart < 0 || this.getTicksSinceAttack(stack) < 15) {
                this.setTicksSinceAttack(stack, 0);
                return;
            }
            this.setAttacking(stack, true);
            this.setTicksSinceAttack(stack, 18);
            playerEntity.func_130014_f_().func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
            playerEntity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            if (worldIn.func_201670_d()) {
                IENetworkHandler.sendToServer(new WhipReachPacket(playerEntity.func_110124_au()));
            }
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (handIn.equals((Object)Hand.MAIN_HAND)) {
            playerIn.func_184598_c(handIn);
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (this.getAttacking(stack)) {
            this.setTicksSinceAttack(stack, 0);
            this.setAttacking(stack, false);
        }
        this.setCharging(stack, true);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.getCharging(stack) && this.getTicksSinceAttack(stack) <= 15 || this.getAttacking(stack)) {
            this.setTicksSinceAttack(stack, this.getTicksSinceAttack(stack) + 1);
        }
        if (this.getTicksSinceAttack(stack) >= 30 || !isSelected && entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).func_184592_cb() != stack) {
            this.setTicksSinceAttack(stack, 0);
            this.setAttacking(stack, false);
            this.setCharging(stack, false);
        }
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.func_77644_a(stack, target, attacker);
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.WEAPON;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack itemStack) {
        ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
        attributeBuilder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        attributeBuilder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        ImmutableMultimap attributes = attributeBuilder.build();
        return equipmentSlot == EquipmentSlotType.MAINHAND ? attributes : super.getAttributeModifiers(equipmentSlot, itemStack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (WhipUpdateCapability.INSTANCE == null) {
            return null;
        }
        return WhipUpdateCapability.createProvider();
    }

    public void setTicksSinceAttack(ItemStack itemStack, int ticksSinceAttack) {
        WhipUpdateCapability.getWhipUpdate(itemStack).ifPresent(whipUpdate -> whipUpdate.setTicksSinceAttack(ticksSinceAttack));
    }

    public int getTicksSinceAttack(ItemStack itemStack) {
        IWhipUpdate whipUpdate = (IWhipUpdate)WhipUpdateCapability.getWhipUpdate(itemStack).orElse(null);
        return whipUpdate == null ? 0 : whipUpdate.getTicksSinceAttack();
    }

    public void setAttacking(ItemStack itemStack, boolean attacking) {
        WhipUpdateCapability.getWhipUpdate(itemStack).ifPresent(whipUpdate -> whipUpdate.setAttacking(attacking));
    }

    public boolean getAttacking(ItemStack itemStack) {
        IWhipUpdate whipUpdate = (IWhipUpdate)WhipUpdateCapability.getWhipUpdate(itemStack).orElse(null);
        return whipUpdate != null && whipUpdate.getAttacking();
    }

    public void setCharging(ItemStack itemStack, boolean charging) {
        WhipUpdateCapability.getWhipUpdate(itemStack).ifPresent(whipUpdate -> whipUpdate.setCharging(charging));
    }

    public boolean getCharging(ItemStack itemStack) {
        IWhipUpdate whipUpdate = (IWhipUpdate)WhipUpdateCapability.getWhipUpdate(itemStack).orElse(null);
        return whipUpdate != null && whipUpdate.getCharging();
    }
}

