/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.access.AbstractArrowEntityAccess;
import org.infernalstudios.infernalexp.client.DynamicLightingHandler;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrowEntity.class})
public class MixinAbstractArrowEntity
implements AbstractArrowEntityAccess {
    @Unique
    private static final DataParameter<Boolean> GLOW = EntityDataManager.func_187226_a(AbstractArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    @Unique
    private static final DataParameter<Boolean> LUMINOUS = EntityDataManager.func_187226_a(AbstractArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    @Unique
    private static final DataParameter<Boolean> INFECTION = EntityDataManager.func_187226_a(AbstractArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    @Unique
    private static final DataParameter<Boolean> INFECTED_SOURCE = EntityDataManager.func_187226_a(AbstractArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void arrowTickInfernalExpansion(CallbackInfo ci) {
        DynamicLightingHandler.tick((AbstractArrowEntity)this);
    }

    @Inject(at={@At(value="RETURN")}, method={"registerData"})
    private void registerDataInfernalExpansion(CallbackInfo ci) {
        ((AbstractArrowEntity)this).func_184212_Q().func_187214_a(LUMINOUS, (Object)false);
        ((AbstractArrowEntity)this).func_184212_Q().func_187214_a(INFECTION, (Object)false);
        ((AbstractArrowEntity)this).func_184212_Q().func_187214_a(GLOW, (Object)false);
        ((AbstractArrowEntity)this).func_184212_Q().func_187214_a(INFECTED_SOURCE, (Object)false);
    }

    @Inject(at={@At(value="RETURN")}, method={"writeAdditional"})
    private void writeAdditionalInfernalExpansion(CompoundNBT compound, CallbackInfo ci) {
        compound.func_74757_a("Luminous", ((Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(LUMINOUS)).booleanValue());
        compound.func_74757_a("Infection", ((Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(INFECTION)).booleanValue());
        compound.func_74757_a("Glow", ((Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(GLOW)).booleanValue());
        compound.func_74757_a("InfectedSource", ((Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(INFECTED_SOURCE)).booleanValue());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditional"})
    private void readAdditionalInfernalExpansion(CompoundNBT compound, CallbackInfo ci) {
        this.setLuminous(compound.func_74767_n("Luminous"));
        this.setInfection(compound.func_74767_n("Infection"));
        this.setGlow(compound.func_74767_n("Glow"));
        this.setInfectedSource(compound.func_74767_n("InfectedSource"));
    }

    @Inject(at={@At(value="RETURN")}, method={"setShooter"})
    private void setShooterInfernalExpansion(Entity entityIn, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (entityIn instanceof LivingEntity && (livingEntity = (LivingEntity)entityIn).func_70644_a((Effect)IEEffects.INFECTION.get())) {
            this.setInfectedSource(true);
            this.setInfection(true);
        }
    }

    @Override
    public boolean getLuminous() {
        return (Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(LUMINOUS);
    }

    @Override
    public void setLuminous(boolean isLuminous) {
        ((AbstractArrowEntity)this).func_184212_Q().func_187227_b(LUMINOUS, (Object)isLuminous);
    }

    @Override
    public boolean getInfection() {
        return (Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(INFECTION);
    }

    @Override
    public void setInfection(boolean isInfection) {
        ((AbstractArrowEntity)this).func_184212_Q().func_187227_b(INFECTION, (Object)isInfection);
    }

    @Override
    public boolean getInfectedSource() {
        return (Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(INFECTED_SOURCE);
    }

    @Override
    public void setInfectedSource(boolean isInfectedSource) {
        ((AbstractArrowEntity)this).func_184212_Q().func_187227_b(INFECTED_SOURCE, (Object)isInfectedSource);
    }

    @Override
    public boolean getGlow() {
        return (Boolean)((AbstractArrowEntity)this).func_184212_Q().func_187225_a(GLOW);
    }

    @Override
    public void setGlow(boolean shouldGlow) {
        ((AbstractArrowEntity)this).func_184212_Q().func_187227_b(GLOW, (Object)shouldGlow);
    }
}

