/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.infernalstudios.infernalexp.entities.IBucketable;
import org.infernalstudios.infernalexp.init.IEItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StriderEntity.class})
public abstract class MixinStriderEntity
extends AnimalEntity
implements IRideable,
IEquipable,
IBucketable {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(StriderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    @Shadow
    protected abstract void func_70088_a();

    @Shadow
    public abstract void func_70037_a(CompoundNBT var1);

    protected MixinStriderEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"registerData"}, at={@At(value="HEAD")})
    private void IE_registerData(CallbackInfo info) {
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    @Override
    public boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean isFromBucket) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)isFromBucket);
    }

    @Inject(method={"writeAdditional"}, at={@At(value="HEAD")})
    private void IE_writeAdditional(CompoundNBT compound, CallbackInfo ci) {
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    @Inject(method={"readAdditional"}, at={@At(value="HEAD")})
    private void IE_readAdditional(CompoundNBT compound, CallbackInfo ci) {
        this.setFromBucket(compound.func_74767_n("FromBucket"));
    }

    @Inject(method={"getEntityInteractionResult"}, at={@At(value="RETURN")}, cancellable=true)
    public void IE_getEntityInteractionResult(PlayerEntity playerIn, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        ActionResultType resultType = (ActionResultType)cir.getReturnValue();
        if (this.func_70631_g_()) {
            cir.setReturnValue((Object)IBucketable.tryBucketEntity(playerIn, hand, this).orElse(super.func_230254_b_(playerIn, hand)));
        } else {
            cir.setReturnValue((Object)resultType);
        }
    }

    @Inject(method={"onInitialSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void IE_onInitialSpawn(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag, CallbackInfoReturnable<ILivingEntityData> cir) {
        if (reason == SpawnReason.BUCKET) {
            spawnDataIn = new AgeableEntity.AgeableData(true);
            this.func_70873_a(-24000);
            cir.setReturnValue((Object)spawnDataIn);
        }
    }

    @Override
    public void copyToStack(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        IBucketable.copyToStack((MobEntity)this, stack);
        compound.func_74768_a("Age", this.func_70874_b());
    }

    @Override
    public void copyFromAdditional(CompoundNBT compound) {
        IBucketable.copyFromAdditional((MobEntity)this, compound);
        if (compound.func_150297_b("Age", 99)) {
            this.func_70873_a(compound.func_74762_e("Age"));
        }
    }

    @Override
    public SoundEvent getBucketedSound() {
        return SoundEvents.field_187633_N;
    }

    @Override
    public ItemStack getBucketItem() {
        return new ItemStack((IItemProvider)IEItems.STRIDER_BUCKET.get());
    }
}

