/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.infernalstudios.infernalexp.entities.InfernalPaintingEntity;

public class SpawnInfernalPaintingPacket {
    private final int entityID;
    private final UUID uniqueID;
    private final BlockPos pos;
    private final Direction facing;
    private final String title;

    public SpawnInfernalPaintingPacket(InfernalPaintingEntity painting) {
        this.entityID = painting.func_145782_y();
        this.uniqueID = painting.func_110124_au();
        this.pos = painting.func_174857_n();
        this.facing = painting.func_174811_aO();
        this.title = ForgeRegistries.PAINTING_TYPES.getKey((IForgeRegistryEntry)painting.field_70522_e).toString();
    }

    public SpawnInfernalPaintingPacket(int entityID, UUID uniqueID, BlockPos pos, Direction facing, String title) {
        this.entityID = entityID;
        this.uniqueID = uniqueID;
        this.pos = pos;
        this.facing = facing;
        this.title = title;
    }

    public static void encode(SpawnInfernalPaintingPacket message, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(message.entityID);
        packetBuffer.func_179252_a(message.uniqueID);
        packetBuffer.func_179255_a(message.pos);
        packetBuffer.writeByte(message.facing.func_176736_b());
        packetBuffer.func_180714_a(message.title);
    }

    public static SpawnInfernalPaintingPacket decode(PacketBuffer packetBuffer) {
        return new SpawnInfernalPaintingPacket(packetBuffer.func_150792_a(), packetBuffer.func_179253_g(), packetBuffer.func_179259_c(), Direction.func_176731_b((int)packetBuffer.readByte()), packetBuffer.func_218666_n());
    }

    public static void handle(SpawnInfernalPaintingPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide());
            InfernalPaintingEntity paintingEntity = new InfernalPaintingEntity(world.orElse(null), message.pos, message.facing, (PaintingType)ForgeRegistries.PAINTING_TYPES.getValue(new ResourceLocation(message.title)));
            paintingEntity.func_145769_d(message.entityID);
            paintingEntity.func_184221_a(message.uniqueID);
            world.filter(ClientWorld.class::isInstance).ifPresent(w -> ((ClientWorld)w).func_217411_a(message.entityID, (Entity)paintingEntity));
        });
        ctx.get().setPacketHandled(true);
    }
}

