/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.network;

import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkEvent;
import org.infernalstudios.infernalexp.init.IEItems;

public class WhipReachPacket {
    private final UUID playerUUID;
    private static final Random random = new Random();

    public WhipReachPacket(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public static void encode(WhipReachPacket message, PacketBuffer buffer) {
        buffer.func_179252_a(message.playerUUID);
    }

    public static WhipReachPacket decode(PacketBuffer buffer) {
        return new WhipReachPacket(buffer.func_179253_g());
    }

    public static void handle(WhipReachPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            double distance;
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            double reach = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0;
            Vector3d eyePos = player.func_174824_e(1.0f);
            Vector3d lookVec = player.func_70040_Z();
            Vector3d reachVec = eyePos.func_178787_e(lookVec.func_216372_d(reach, reach, reach));
            AxisAlignedBB playerBox = player.func_174813_aQ().func_216361_a(lookVec.func_186678_a(reach)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityTraceResult = ProjectileHelper.func_221273_a((Entity)player, (Vector3d)eyePos, (Vector3d)reachVec, (AxisAlignedBB)playerBox, target -> !target.func_175149_v() && target.func_203003_aK(), (double)(reach * reach));
            BlockRayTraceResult blockTraceResult = player.func_130014_f_().func_217299_a(new RayTraceContext(eyePos, reachVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
            if (entityTraceResult != null && (distance = eyePos.func_72436_e(entityTraceResult.func_216347_e())) < reach * reach && distance < eyePos.func_72436_e(blockTraceResult.func_216347_e())) {
                player.field_184617_aD = (int)player.func_184818_cX();
                player.func_130014_f_().func_184148_a((PlayerEntity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 1.2f));
                if (player != null && player.func_184102_h() != null) {
                    ServerPlayerEntity serverPlayer = player.func_184102_h().func_184103_al().func_177451_a(message.playerUUID);
                    Entity target2 = entityTraceResult.func_216348_a();
                    if (serverPlayer != null && target2 != null && serverPlayer.func_70068_e(target2) < reach * reach * (double)serverPlayer.func_184825_o(0.0f)) {
                        serverPlayer.func_71059_n(target2);
                        serverPlayer.func_130014_f_().func_184148_a(null, serverPlayer.func_226277_ct_(), serverPlayer.func_226278_cu_(), serverPlayer.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 1.2f));
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    private int getActiveKnockback(ItemStack stack) {
        if (stack.func_77973_b() != IEItems.BLINDSIGHT_TONGUE_WHIP.get()) {
            return 0;
        }
        ListNBT listnbt = stack.func_77986_q();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundNBT = listnbt.func_150305_b(i);
            if (!compoundNBT.func_74779_i("id").equals("minecraft:knockback")) continue;
            return MathHelper.func_76125_a((int)compoundNBT.func_74762_e("lvl"), (int)0, (int)2);
        }
        return 0;
    }
}

