/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;

public class BoulderFeature
extends Feature<BlockStateFeatureConfig> {
    public BoulderFeature(Codec<BlockStateFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, BlockStateFeatureConfig config) {
        int radius = (new int[]{1, 1, 2, 2, 2, 2, 3})[random.nextInt(7)];
        if (!world.func_175623_d(pos) || world.func_180495_p(pos.func_177977_b()).func_177230_c() != IEBlocks.GLOWDUST_SAND.get() || world.func_175623_d(pos.func_177979_c(radius)) || random.nextInt(3) == 2) {
            return false;
        }
        this.placeSphere(world, random, pos.func_177979_c(Math.floorDiv(radius, 3)), radius, config);
        return true;
    }

    private void placeSphere(ISeedReader world, Random random, BlockPos pos, int radius, BlockStateFeatureConfig config) {
        for (BlockPos point : ShapeUtil.generateSolidSphere(radius)) {
            world.func_180501_a(pos.func_177971_a((Vector3i)point), config.field_227270_a_, 2);
            this.randomNoise(world, random, pos, config);
        }
    }

    private void randomNoise(ISeedReader world, Random random, BlockPos pos, BlockStateFeatureConfig config) {
        switch (random.nextInt(8)) {
            case 0: {
                if (!world.func_180495_p(pos.func_177976_e().func_177977_b()).func_196958_f()) {
                    world.func_180501_a(pos.func_177976_e(), config.field_227270_a_, 2);
                }
            }
            case 1: {
                if (!world.func_180495_p(pos.func_177978_c().func_177977_b()).func_196958_f()) {
                    world.func_180501_a(pos.func_177978_c(), config.field_227270_a_, 2);
                }
            }
            case 2: {
                if (!world.func_180495_p(pos.func_177974_f().func_177977_b()).func_196958_f()) {
                    world.func_180501_a(pos.func_177974_f(), config.field_227270_a_, 2);
                }
            }
            case 3: {
                if (!world.func_180495_p(pos.func_177968_d().func_177977_b()).func_196958_f()) {
                    world.func_180501_a(pos.func_177968_d(), config.field_227270_a_, 2);
                }
            }
            case 4: {
                if (world.func_180495_p(pos.func_177984_a().func_177977_b()).func_196958_f()) break;
                world.func_180501_a(pos.func_177984_a(), config.field_227270_a_, 2);
            }
        }
    }
}

