/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import org.infernalstudios.infernalexp.blocks.GlowdustBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;

public class GlowLayerFeature
extends Feature<NoFeatureConfig> {
    public GlowLayerFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        BlockPos.Mutable mutableBlockPosNeighbors = new BlockPos.Mutable().func_189533_g((Vector3i)mutableBlockPos);
        boolean doExpandedPlacing = this.isMultipleBiomesInChunk(world, pos, mutableBlockPos);
        IChunk cachedChunk = world.func_217349_x((BlockPos)mutableBlockPos);
        int minimumRange = doExpandedPlacing ? -12 : 0;
        int maxRange = doExpandedPlacing ? 28 : 16;
        for (int x = minimumRange; x < maxRange; ++x) {
            for (int z = minimumRange; z < maxRange; ++z) {
                int maxY;
                for (int y = maxY = generator.func_222529_a(pos.func_177958_n() + x, pos.func_177952_p() + z, Heightmap.Type.MOTION_BLOCKING); y > generator.func_230356_f_(); --y) {
                    int glowdustLayerHeight;
                    BlockState currentBlock;
                    mutableBlockPos.func_189533_g((Vector3i)pos).func_196234_d(x, y, z);
                    if (cachedChunk.func_76632_l().field_77276_a != x >> 4 || cachedChunk.func_76632_l().field_77275_b != z >> 4) {
                        cachedChunk = world.func_217349_x((BlockPos)mutableBlockPos);
                    }
                    if (!(currentBlock = cachedChunk.func_180495_p((BlockPos)mutableBlockPos)).func_203425_a((Block)IEBlocks.GLOWDUST_SAND.get()) || !cachedChunk.func_180495_p((BlockPos)mutableBlockPos.func_189536_c(Direction.UP)).func_196958_f() || (glowdustLayerHeight = this.numberOfGlowdustSandNearby(world, mutableBlockPos, mutableBlockPosNeighbors)) <= 0) continue;
                    world.func_180501_a((BlockPos)mutableBlockPos, (BlockState)((Block)IEBlocks.GLOWDUST.get()).func_176223_P().func_206870_a((Property)GlowdustBlock.field_176315_a, (Comparable)Integer.valueOf(glowdustLayerHeight)), 3);
                }
            }
        }
        return true;
    }

    private boolean isMultipleBiomesInChunk(ISeedReader world, BlockPos pos, BlockPos.Mutable mutableBlockPos) {
        Biome centerBiome = world.func_226691_t_((BlockPos)mutableBlockPos.func_189533_g((Vector3i)pos).func_196234_d(8, 0, 8));
        for (int x = 0; x <= 16; x += 8) {
            for (int z = 0; z <= 16; z += 8) {
                if (x == 8 || z == 8) continue;
                mutableBlockPos.func_189533_g((Vector3i)pos);
                mutableBlockPos.func_196234_d(x, 0, z);
                if (x == 16) {
                    mutableBlockPos.func_196234_d(-1, 0, 0);
                }
                if (z == 16) {
                    mutableBlockPos.func_196234_d(0, 0, -1);
                }
                if (centerBiome == world.func_226691_t_((BlockPos)mutableBlockPos)) continue;
                return true;
            }
        }
        return false;
    }

    private int numberOfGlowdustSandNearby(ISeedReader world, BlockPos.Mutable mutableBlockPos, BlockPos.Mutable mutableBlockPosNeighbors) {
        int glowdustSandCount = 0;
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) continue;
                mutableBlockPosNeighbors.func_189533_g((Vector3i)mutableBlockPos).func_196234_d(x, 0, z);
                BlockState neighborBlock = world.func_180495_p((BlockPos)mutableBlockPosNeighbors);
                if (!neighborBlock.func_203425_a((Block)IEBlocks.GLOWDUST_SAND.get())) continue;
                ++glowdustSandCount;
            }
        }
        return Math.min((int)Math.ceil((double)glowdustSandCount / 6.0), 8);
    }
}

