/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.jei.JeiInternalPlugin;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TranslationTextComponent;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IngredientInfoRecipe> {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private static final int lineSpacing = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final JeiInternalPlugin jeiPlugin;
    private final ITextComponent localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures, JeiInternalPlugin jeiPlugin) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.jeiPlugin = jeiPlugin;
        this.localizedName = new TranslationTextComponent("gui.jei.category.itemInformation");
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.INFORMATION;
    }

    @Override
    public Class<? extends IngredientInfoRecipe> getRecipeClass() {
        return IngredientInfoRecipe.class;
    }

    @Override
    @Deprecated
    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    @Override
    public ITextComponent getTitleAsTextComponent() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void setIngredients(IngredientInfoRecipe recipe, IIngredients ingredients) {
        this.setIngredientsTyped(recipe, ingredients);
    }

    private <T> void setIngredientsTyped(IngredientInfoRecipe<T> recipe, IIngredients ingredients) {
        IIngredientType<T> ingredientType = recipe.getIngredientType();
        List<List<T>> recipeIngredients = Collections.singletonList(recipe.getIngredients());
        ingredients.setInputLists(ingredientType, recipeIngredients);
        ingredients.setOutputLists(ingredientType, recipeIngredients);
    }

    @Override
    public void draw(IngredientInfoRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.drawTyped(matrixStack, recipe);
    }

    private <T> void drawTyped(MatrixStack matrixStack, IngredientInfoRecipe<T> recipe) {
        boolean xPos = false;
        int yPos = this.slotBackground.getHeight() + 4;
        Minecraft minecraft = Minecraft.func_71410_x();
        for (ITextProperties descriptionLine : recipe.getDescription()) {
            minecraft.field_71466_p.func_238422_b_(matrixStack, LanguageMap.func_74808_a().func_241870_a(descriptionLine), (float)xPos, (float)yPos, -16777216);
            minecraft.field_71466_p.getClass();
            yPos += 9 + 2;
        }
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, IngredientInfoRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int xPos = 71;
        guiItemStacks.init(0, true, xPos, 0);
        guiItemStacks.setBackground(0, this.slotBackground);
        guiItemStacks.set(ingredients);
        IIngredientManager ingredientManager = this.jeiPlugin.ingredientManager;
        if (ingredientManager != null) {
            for (IIngredientType<?> type : ingredientManager.getRegisteredIngredientTypes()) {
                IGuiIngredientGroup<?> group = recipeLayout.getIngredientsGroup(type);
                group.init(0, true, xPos + 1, 1);
                group.set(ingredients);
            }
        }
    }
}

