/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.mod.IModBlockHandler;
import journeymap.client.mod.vanilla.FlowerBlockProxy;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.properties.CoreProperties;
import net.minecraft.block.BeaconBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.SeaGrassBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraftforge.common.IPlantable;

public final class VanillaBlockHandler
implements IModBlockHandler {
    ListMultimap<Material, BlockFlag> materialFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Class<?>, BlockFlag> blockClassFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Block, BlockFlag> blockFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    HashMap<Material, Float> materialAlphas = new HashMap();
    HashMap<Block, Float> blockAlphas = new HashMap();
    HashMap<Class<?>, Float> blockClassAlphas = new HashMap();
    private boolean mapPlants;
    private boolean mapPlantShadows;
    private boolean mapCrops;

    public VanillaBlockHandler() {
        this.preInitialize();
    }

    private void preInitialize() {
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        this.mapPlants = coreProperties.mapPlants.get();
        this.mapCrops = coreProperties.mapCrops.get();
        this.mapPlantShadows = coreProperties.mapPlantShadows.get();
        this.setFlags(Material.field_175972_I, BlockFlag.Ignore);
        this.setFlags(Material.field_151579_a, BlockFlag.Ignore);
        this.setFlags(Material.field_151592_s, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(Material.field_151577_b, BlockFlag.Grass);
        if (coreProperties.caveIgnoreGlass.get().booleanValue()) {
            this.setFlags(Material.field_151592_s, BlockFlag.OpenToSky);
        }
        this.setFlags(Material.field_151587_i, Float.valueOf(1.0f), BlockFlag.NoShadow);
        this.setFlags(Material.field_151586_h, Float.valueOf(0.25f), BlockFlag.Water, BlockFlag.NoShadow);
        this.materialAlphas.put(Material.field_151588_w, Float.valueOf(0.8f));
        this.materialAlphas.put(Material.field_151598_x, Float.valueOf(0.8f));
        this.setFlags(Blocks.field_150411_aY, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(Blocks.field_150480_ab, BlockFlag.NoShadow);
        this.setFlags(Blocks.field_150468_ap, BlockFlag.OpenToSky);
        this.setFlags(Blocks.field_150433_aE, BlockFlag.NoTopo, BlockFlag.NoShadow);
        this.setFlags(Blocks.field_150473_bD, BlockFlag.Ignore);
        this.setFlags(Blocks.field_150479_bC, BlockFlag.Ignore);
        this.setFlags(Blocks.field_196553_aF, BlockFlag.OpenToSky, BlockFlag.NoShadow);
        this.setFlags(BushBlock.class, BlockFlag.Plant);
        this.setFlags(FenceBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(FenceGateBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(GrassBlock.class, BlockFlag.Grass);
        this.setFlags(LeavesBlock.class, BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoTopo);
        this.setFlags(RailBlock.class, BlockFlag.NoShadow, BlockFlag.NoTopo);
        this.setFlags(RedstoneWireBlock.class, BlockFlag.Ignore);
        this.setFlags(TorchBlock.class, BlockFlag.Ignore);
        this.setFlags(VineBlock.class, Float.valueOf(0.2f), BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoShadow);
        this.setFlags(IPlantable.class, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(SeaGrassBlock.class, BlockFlag.Plant, BlockFlag.NoTopo);
    }

    @Override
    public void initialize(BlockMD blockMD) {
        Block block = blockMD.getBlockState().func_177230_c();
        Material material = blockMD.getBlockState().func_185904_a();
        BlockState blockState = blockMD.getBlockState();
        if (blockState.func_185901_i() == BlockRenderType.INVISIBLE && !(blockState.func_177230_c() instanceof FlowingFluidBlock)) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
        blockMD.addFlags(this.materialFlags.get((Object)material));
        Float alpha = this.materialAlphas.get(material);
        if (alpha != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        if (this.blockFlags.containsKey((Object)block)) {
            blockMD.addFlags(this.blockFlags.get((Object)block));
        }
        if ((alpha = this.blockAlphas.get(block)) != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        for (Class parentClass : this.blockClassFlags.keys()) {
            if (!parentClass.isAssignableFrom(block.getClass())) continue;
            blockMD.addFlags(this.blockClassFlags.get((Object)parentClass));
            alpha = this.blockClassAlphas.get(parentClass);
            if (alpha == null) break;
            blockMD.setAlpha(alpha.floatValue());
            break;
        }
        if (block instanceof FlowingFluidBlock) {
            blockMD.addFlags(BlockFlag.Fluid, BlockFlag.NoShadow);
            blockMD.setAlpha(0.7f);
        }
        if (material == Material.field_151592_s && (block.getRegistryName().func_110623_a().equalsIgnoreCase("glowstone") || block instanceof LanternBlock || block instanceof BeaconBlock || block.equals(Blocks.field_150426_aN))) {
            blockMD.removeFlags(BlockFlag.OpenToSky, BlockFlag.Transparency);
            blockMD.setAlpha(1.0f);
        }
        if (block instanceof BushBlock && blockMD.getBlockState().func_235904_r_().contains(DoublePlantBlock.field_176492_b) && blockMD.getBlockState().func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER) {
            blockMD.addFlags(BlockFlag.Ignore);
        }
        if (block instanceof CropsBlock) {
            blockMD.addFlags(BlockFlag.Crop);
        }
        if (block instanceof FlowerBlock || block instanceof FlowerPotBlock) {
            blockMD.setBlockColorProxy(FlowerBlockProxy.INSTANCE);
        }
        if (blockMD.isVanillaBlock()) {
            return;
        }
        String uid = blockMD.getBlockId();
        if (uid.toLowerCase().contains("torch")) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
    }

    public void postInitialize(BlockMD blockMD) {
        if (blockMD.hasFlag(BlockFlag.Crop)) {
            blockMD.removeFlags(BlockFlag.Plant);
        }
        if (blockMD.hasAnyFlag(BlockMD.FlagsPlantAndCrop)) {
            if (!this.mapPlants && blockMD.hasFlag(BlockFlag.Plant) || !this.mapCrops && blockMD.hasFlag(BlockFlag.Crop)) {
                blockMD.addFlags(BlockFlag.Ignore);
            } else if (!this.mapPlantShadows) {
                blockMD.addFlags(BlockFlag.NoShadow);
            }
        }
        if (blockMD.isIgnore()) {
            blockMD.removeFlags(BlockMD.FlagsNormal);
        }
    }

    private void setFlags(Material material, BlockFlag ... flags) {
        this.materialFlags.putAll((Object)material, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Material material, Float alpha, BlockFlag ... flags) {
        this.materialAlphas.put(material, alpha);
        this.setFlags(material, flags);
    }

    private void setFlags(Class parentClass, BlockFlag ... flags) {
        this.blockClassFlags.putAll((Object)parentClass, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Class parentClass, Float alpha, BlockFlag ... flags) {
        this.blockClassAlphas.put(parentClass, alpha);
        this.setFlags(parentClass, flags);
    }

    private void setFlags(Block block, BlockFlag ... flags) {
        this.blockFlags.putAll((Object)block, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Block block, Float alpha, BlockFlag ... flags) {
        this.blockAlphas.put(block, alpha);
        this.setFlags(block, flags);
    }
}

