/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleRing
extends SpriteTexturedParticle {
    public float r;
    public float g;
    public float b;
    public float opacity;
    public boolean facesCamera;
    public float yaw;
    public float pitch;
    public float size;
    private final EnumRingBehavior behavior;

    public ParticleRing(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, float yaw, float pitch, int duration, float r, float g, float b, float opacity, float size, boolean facesCamera, EnumRingBehavior behavior) {
        super(world, x, y, z);
        this.func_187115_a(1.0f, 1.0f);
        this.size = size * 0.1f;
        this.field_70547_e = duration;
        this.field_82339_as = 1.0f;
        this.r = r;
        this.g = g;
        this.b = b;
        this.opacity = opacity;
        this.yaw = yaw;
        this.pitch = pitch;
        this.facesCamera = facesCamera;
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.behavior = behavior;
    }

    public int func_189214_a(float delta) {
        return 0xF0 | super.func_189214_a(delta) & 0xFF0000;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
        ++this.field_70546_d;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        float var = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_70544_f = this.behavior == EnumRingBehavior.GROW ? this.size * var : (this.behavior == EnumRingBehavior.SHRINK ? this.size * (1.0f - var) : (this.behavior == EnumRingBehavior.GROW_THEN_SHRINK ? (float)((double)this.size * ((double)(1.0f - var) - Math.pow(2000.0, -var))) : this.size));
        this.field_82339_as = this.opacity * 0.95f * (1.0f - ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e) + 0.05f;
        this.field_70552_h = this.r;
        this.field_70553_i = this.g;
        this.field_70551_j = this.b;
        Vector3d Vector3d2 = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - Vector3d2.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - Vector3d2.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - Vector3d2.func_82616_c());
        Quaternion quaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        if (this.facesCamera) {
            if (this.field_190014_F == 0.0f) {
                quaternion = renderInfo.func_227995_f_();
            } else {
                quaternion = new Quaternion(renderInfo.func_227995_f_());
                float f3 = MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F);
                quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(f3));
            }
        } else {
            Quaternion quatX = new Quaternion(this.pitch, 0.0f, 0.0f, false);
            Quaternion quatY = new Quaternion(0.0f, this.yaw, 0.0f, false);
            quaternion.func_195890_a(quatY);
            quaternion.func_195890_a(quatX);
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        float f7 = this.func_217563_c();
        float f8 = this.func_217564_d();
        float f5 = this.func_217562_e();
        float f6 = this.func_217560_f();
        int j = this.func_189214_a(partialTicks);
        buffer.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(f8, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(f8, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(f7, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        buffer.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(f7, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
    }

    public IParticleRenderType func_217558_b() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public static class RingData
    implements IParticleData {
        public static final IParticleData.IDeserializer<RingData> DESERIALIZER = new IParticleData.IDeserializer<RingData>(){

            public RingData deserialize(ParticleType<RingData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float yaw = (float)reader.readDouble();
                reader.expect(' ');
                float pitch = (float)reader.readDouble();
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float a = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                boolean facesCamera = reader.readBoolean();
                return new RingData(yaw, pitch, duration, r, g, b, a, scale, facesCamera, EnumRingBehavior.GROW);
            }

            public RingData read(ParticleType<RingData> particleTypeIn, PacketBuffer buffer) {
                return new RingData(buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), EnumRingBehavior.GROW);
            }
        };
        private final float yaw;
        private final float pitch;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final float scale;
        private final int duration;
        private final boolean facesCamera;
        private final EnumRingBehavior behavior;

        public RingData(float yaw, float pitch, int duration, float r, float g, float b, float a, float scale, boolean facesCamera, EnumRingBehavior behavior) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.scale = scale;
            this.duration = duration;
            this.facesCamera = facesCamera;
            this.behavior = behavior;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %d %b", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.yaw), Float.valueOf(this.pitch), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), Float.valueOf(this.a), this.duration, this.facesCamera);
        }

        public ParticleType<RingData> func_197554_b() {
            return (ParticleType)ParticleHandler.RING.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getYaw() {
            return this.yaw;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getPitch() {
            return this.pitch;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getA() {
            return this.a;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean getFacesCamera() {
            return this.facesCamera;
        }

        @OnlyIn(value=Dist.CLIENT)
        public EnumRingBehavior getBehavior() {
            return this.behavior;
        }

        public static Codec<RingData> CODEC(ParticleType<RingData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("yaw").forGetter(RingData::getYaw), (App)Codec.FLOAT.fieldOf("pitch").forGetter(RingData::getPitch), (App)Codec.FLOAT.fieldOf("r").forGetter(RingData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(RingData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(RingData::getB), (App)Codec.FLOAT.fieldOf("a").forGetter(RingData::getA), (App)Codec.FLOAT.fieldOf("scale").forGetter(RingData::getScale), (App)Codec.INT.fieldOf("duration").forGetter(RingData::getDuration), (App)Codec.BOOL.fieldOf("facesCamera").forGetter(RingData::getFacesCamera), (App)Codec.STRING.fieldOf("behavior").forGetter(ringData -> ringData.getBehavior().toString())).apply((Applicative)codecBuilder, (yaw, pitch, r, g, b, a, scale, duration, facesCamera, behavior) -> new RingData(yaw.floatValue(), pitch.floatValue(), (int)duration, r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue(), scale.floatValue(), (boolean)facesCamera, EnumRingBehavior.valueOf(behavior))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class RingFactory
    implements IParticleFactory<RingData> {
        private final IAnimatedSprite spriteSet;

        public RingFactory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(RingData typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleRing particle = new ParticleRing(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getYaw(), typeIn.getPitch(), typeIn.getDuration(), typeIn.getR(), typeIn.getG(), typeIn.getB(), typeIn.getA(), typeIn.getScale(), typeIn.getFacesCamera(), typeIn.getBehavior());
            particle.func_217566_b(this.spriteSet);
            return particle;
        }
    }

    public static enum EnumRingBehavior {
        SHRINK,
        GROW,
        CONSTANT,
        GROW_THEN_SHRINK;

    }
}

