/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.ParticleRibbon;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.RibbonParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3d;

public class RibbonComponent
extends ParticleComponent {
    int length;
    ParticleType<? extends RibbonParticleData> ribbon;
    double yaw;
    double pitch;
    double roll;
    double scale;
    double r;
    double g;
    double b;
    double a;
    boolean faceCamera;
    boolean emissive;
    ParticleComponent[] components;

    public RibbonComponent(ParticleType<? extends RibbonParticleData> particle, int length, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, boolean faceCamera, boolean emissive, ParticleComponent[] components) {
        this.length = length;
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.scale = scale;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.emissive = emissive;
        this.faceCamera = faceCamera;
        this.components = components;
        this.ribbon = particle;
    }

    @Override
    public void init(AdvancedParticleBase particle) {
        super.init(particle);
        if (particle != null) {
            ParticleComponent[] newComponents = new ParticleComponent[this.components.length + 2];
            System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
            newComponents[this.components.length] = new AttachToParticle(particle);
            newComponents[this.components.length + 1] = new Trail();
            ParticleRibbon.spawnRibbon(particle.getWorld(), this.ribbon, this.length, particle.getPosX(), particle.getPosY(), particle.getPosZ(), 0.0, 0.0, 0.0, this.faceCamera, this.yaw, this.pitch, this.roll, this.scale, this.r, this.g, this.b, this.a, 0.0, particle.func_206254_h() + this.length, this.emissive, newComponents);
        }
    }

    public static class PanTexture
    extends ParticleComponent {
        float startOffset = 0.0f;
        float speed = 1.0f;

        public PanTexture(float startOffset, float speed) {
            this.startOffset = startOffset;
            this.speed = speed;
        }

        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            if (particle instanceof ParticleRibbon) {
                ParticleRibbon ribbon = (ParticleRibbon)particle;
                float time = (ribbon.getAge() - 1.0f + partialTicks) / (float)ribbon.func_206254_h();
                float t = (this.startOffset + time * this.speed) % 1.0f;
                ribbon.texPanOffset = (ribbon.getMaxUPublic() - ribbon.getMinUPublic()) / 2.0f * t;
            }
        }
    }

    public static class BeamPinning
    extends ParticleComponent {
        private final Vector3d[] startLocation;
        private final Vector3d[] endLocation;

        public BeamPinning(Vector3d[] startLocation, Vector3d[] endLocation) {
            this.startLocation = startLocation;
            this.endLocation = endLocation;
        }

        @Override
        public void postUpdate(AdvancedParticleBase particle) {
            if (particle instanceof ParticleRibbon && this.validateLocation(this.startLocation) && this.validateLocation(this.endLocation)) {
                ParticleRibbon ribbon = (ParticleRibbon)particle;
                ribbon.func_187109_b(this.startLocation[0].func_82615_a(), this.startLocation[0].func_82617_b(), this.startLocation[0].func_82616_c());
                Vector3d increment = this.endLocation[0].func_178788_d(this.startLocation[0]).func_186678_a((double)(1.0f / (float)(ribbon.positions.length - 1)));
                for (int i = 0; i < ribbon.positions.length; ++i) {
                    Vector3d newPos = this.startLocation[0].func_178787_e(increment.func_186678_a((double)i));
                    ribbon.prevPositions[i] = ribbon.positions[i] == null ? newPos : ribbon.positions[i];
                    ribbon.positions[i] = newPos;
                }
            }
        }

        private boolean validateLocation(Vector3d[] location) {
            return location != null && location.length >= 1 && location[0] != null;
        }
    }

    public static class Trail
    extends ParticleComponent {
        @Override
        public void postUpdate(AdvancedParticleBase particle) {
            if (particle instanceof ParticleRibbon) {
                ParticleRibbon ribbon = (ParticleRibbon)particle;
                for (int i = ribbon.positions.length - 1; i > 0; --i) {
                    ribbon.positions[i] = ribbon.positions[i - 1];
                    ribbon.prevPositions[i] = ribbon.prevPositions[i - 1];
                }
                ribbon.positions[0] = new Vector3d(ribbon.getPosX(), ribbon.getPosY(), ribbon.getPosZ());
                ribbon.prevPositions[0] = ribbon.getPrevPos();
            }
        }
    }

    public static class PropertyOverLength
    extends ParticleComponent {
        private final ParticleComponent.AnimData animData;
        private final EnumRibbonProperty property;

        public PropertyOverLength(EnumRibbonProperty property, ParticleComponent.AnimData animData) {
            this.animData = animData;
            this.property = property;
        }

        public float evaluate(float t) {
            return this.animData.evaluate(t);
        }

        public EnumRibbonProperty getProperty() {
            return this.property;
        }

        public static enum EnumRibbonProperty {
            RED,
            GREEN,
            BLUE,
            ALPHA,
            SCALE;

        }
    }

    private static class AttachToParticle
    extends ParticleComponent {
        AdvancedParticleBase attachedParticle;

        public AttachToParticle(AdvancedParticleBase attachedParticle) {
            this.attachedParticle = attachedParticle;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            super.init(particle);
            this.attachedParticle.ribbon = (ParticleRibbon)particle;
        }
    }
}

