/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class SolarBeamAbility
extends Ability {
    protected EntitySolarBeam solarBeam;

    public SolarBeamAbility(AbilityType<SolarBeamAbility> abilityType, LivingEntity user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 20), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 55), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 20)});
    }

    @Override
    public void start() {
        super.start();
        LivingEntity user = this.getUser();
        if (!this.getUser().field_70170_p.func_201670_d()) {
            EntitySolarBeam solarBeam = new EntitySolarBeam((EntityType<? extends EntitySolarBeam>)((EntityType)EntityHandler.SOLAR_BEAM.get()), user.field_70170_p, user, user.func_226277_ct_(), user.func_226278_cu_() + (double)1.2f, user.func_226281_cx_(), (float)((double)(user.field_70759_as + 90.0f) * Math.PI / 180.0), (float)((double)(-user.field_70125_A) * Math.PI / 180.0), 55);
            solarBeam.setHasPlayer(true);
            user.field_70170_p.func_217376_c((Entity)solarBeam);
            user.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, 2, false, false));
            EffectInstance sunsBlessingInstance = user.func_70660_b((Effect)EffectHandler.SUNS_BLESSING);
            if (sunsBlessingInstance != null) {
                int duration = sunsBlessingInstance.func_76459_b();
                user.func_195063_d((Effect)EffectHandler.SUNS_BLESSING);
                int solarBeamCost = (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.solarBeamCost.get() * 60 * 20;
                if (duration - solarBeamCost > 0) {
                    user.func_195064_c(new EffectInstance((Effect)EffectHandler.SUNS_BLESSING, duration - solarBeamCost, 0, false, false));
                }
            }
            this.solarBeam = solarBeam;
        } else {
            this.heldItemMainHandVisualOverride = ItemStack.field_190927_a;
            this.heldItemOffHandVisualOverride = ItemStack.field_190927_a;
            this.firstPersonOffHandDisplay = Ability.HandDisplay.FORCE_RENDER;
            this.firstPersonMainHandDisplay = Ability.HandDisplay.FORCE_RENDER;
        }
        this.playAnimation("solar_beam_charge", false);
    }

    @Override
    public void end() {
        super.end();
        if (this.solarBeam != null) {
            this.solarBeam.func_70106_y();
        }
    }

    @Override
    public boolean canUse() {
        if (this.getUser() instanceof PlayerEntity && !((PlayerEntity)this.getUser()).field_71071_by.func_70448_g().func_190926_b()) {
            return false;
        }
        return this.getUser().func_70644_a((Effect)EffectHandler.SUNS_BLESSING) && super.canUse();
    }
}

