/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.server.ai.BarakoaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoan;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class EntityBarakoana
extends EntityBarakoa
implements LeaderSunstrikeImmune,
IMob {
    private final List<EntityBarakoanToBarakoana> pack = new ArrayList<EntityBarakoanToBarakoana>();
    private final int packRadius = 3;

    public EntityBarakoana(EntityType<? extends EntityBarakoana> type, World world) {
        super((EntityType<? extends EntityBarakoa>)type, world);
        this.setMask(MaskType.FURY);
        this.field_70728_aV = 8;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new BarakoaHurtByTargetAI(this, true, new Class[0]));
    }

    @Override
    protected void registerTargetGoals() {
        this.registerHuntingTargetGoals();
    }

    @Override
    protected boolean canHoldVaryingWeapons() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MowzieEntity.createAttributes().func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 10.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < this.pack.size(); ++i) {
            this.pack.get((int)i).index = i;
        }
        if (!this.field_70170_p.field_72995_K && this.pack != null) {
            float theta = (float)Math.PI * 2 / (float)this.pack.size();
            for (int i = 0; i < this.pack.size(); ++i) {
                EntityBarakoanToBarakoana hunter = this.pack.get(i);
                if (hunter.func_70638_az() != null) continue;
                hunter.func_70661_as().func_75492_a(this.func_226277_ct_() + (double)(3.0f * MathHelper.func_76134_b((float)(theta * (float)i))), this.func_226278_cu_(), this.func_226281_cx_() + (double)(3.0f * MathHelper.func_76126_a((float)(theta * (float)i))), 0.45);
                if (!(this.func_70032_d((Entity)hunter) > 20.0f) || !this.field_70122_E) continue;
                hunter.func_70107_b(this.func_226277_ct_() + (double)(3.0f * MathHelper.func_76134_b((float)(theta * (float)i))), this.func_226278_cu_(), this.func_226281_cx_() + (double)(3.0f * MathHelper.func_76126_a((float)(theta * (float)i))));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        if (this.field_70173_aa == 0) {
            this.pack.forEach(EntityBarakoan::setShouldSetDead);
        }
        super.func_70106_y();
    }

    public boolean func_205019_a(IWorldReader worldReader) {
        if (this.field_70173_aa == 0) {
            return !worldReader.func_72953_d(this.func_174813_aQ()) && worldReader.func_226669_j_((Entity)this);
        }
        return !worldReader.func_72953_d(this.func_174813_aQ()) && worldReader.func_226669_j_((Entity)this) && this.field_70170_p.func_226668_i_((Entity)this);
    }

    public void removePackMember(EntityBarakoanToBarakoana tribeHunter) {
        this.pack.remove(tribeHunter);
        this.sortPackMembers();
    }

    public void addPackMember(EntityBarakoanToBarakoana tribeHunter) {
        this.pack.add(tribeHunter);
        this.sortPackMembers();
    }

    private void sortPackMembers() {
        double theta = Math.PI * 2 / (double)this.pack.size();
        for (int i = 0; i < this.pack.size(); ++i) {
            int nearestIndex = -1;
            double smallestDiffSq = Double.MAX_VALUE;
            double targetTheta = theta * (double)i;
            double x = this.func_226277_ct_() + 3.0 * Math.cos(targetTheta);
            double z = this.func_226281_cx_() + 3.0 * Math.sin(targetTheta);
            for (int n = 0; n < this.pack.size(); ++n) {
                EntityBarakoanToBarakoana tribeHunter = this.pack.get(n);
                double diffSq = (x - tribeHunter.func_226277_ct_()) * (x - tribeHunter.func_226277_ct_()) + (z - tribeHunter.func_226281_cx_()) * (z - tribeHunter.func_226281_cx_());
                if (!(diffSq < smallestDiffSq)) continue;
                smallestDiffSq = diffSq;
                nearestIndex = n;
            }
            if (nearestIndex == -1) {
                throw new ArithmeticException("All pack members have NaN x and z?");
            }
            this.pack.add(i, this.pack.remove(nearestIndex));
        }
    }

    public int getPackSize() {
        return this.pack.size();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        int size = this.field_70146_Z.nextInt(2) + 3;
        float theta = (float)Math.PI * 2 / (float)size;
        for (int i = 0; i <= size; ++i) {
            EntityBarakoanToBarakoana tribeHunter = new EntityBarakoanToBarakoana((EntityType<? extends EntityBarakoanToBarakoana>)((EntityType)EntityHandler.BARAKOAN_TO_BARAKOANA.get()), this.field_70170_p, this);
            tribeHunter.func_70107_b(this.func_226277_ct_() + 0.1 * (double)MathHelper.func_76134_b((float)(theta * (float)i)), this.func_226278_cu_(), this.func_226281_cx_() + 0.1 * (double)MathHelper.func_76126_a((float)(theta * (float)i)));
            int weapon = this.field_70146_Z.nextInt(3) == 0 ? 1 : 0;
            tribeHunter.setWeapon(weapon);
            world.func_217376_c((Entity)tribeHunter);
        }
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.pack.forEach(EntityBarakoanToBarakoana::removeLeader);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        this.pack.forEach(EntityBarakoanToBarakoana::removeLeader);
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.COMMON.MOBS.BARAKOA.spawnConfig;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        List<LivingEntity> nearby = this.getEntityLivingBaseNearby(30.0, 10.0, 30.0, 30.0);
        for (LivingEntity nearbyEntity : nearby) {
            if (!(nearbyEntity instanceof EntityBarakoana) && !(nearbyEntity instanceof VillagerEntity) && !(nearbyEntity instanceof EntityBarako) && !(nearbyEntity instanceof AnimalEntity)) continue;
            return false;
        }
        return super.func_213380_a(world, reason) && world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        } else if (!this.func_104002_bU() && !this.func_213392_I()) {
            PlayerEntity entity = this.field_70170_p.func_217362_a((Entity)this, -1.0);
            Event.Result result = ForgeEventFactory.canEntityDespawn((MobEntity)this);
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
                entity = null;
            } else if (result == Event.Result.ALLOW) {
                this.func_70106_y();
                entity = null;
            }
            if (entity != null) {
                double d0 = entity.func_70068_e((Entity)this);
                if (d0 > 16384.0 && this.func_213397_c(d0) && this.pack != null) {
                    this.pack.forEach(EntityBarakoan::setShouldSetDead);
                    this.func_70106_y();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d0 > 1024.0 && this.func_213397_c(d0) && this.pack != null) {
                    this.pack.forEach(EntityBarakoan::setShouldSetDead);
                    this.func_70106_y();
                } else if (d0 < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        } else {
            this.field_70708_bq = 0;
        }
    }
}

