/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.FeatureHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.tuple.Pair;

public class WroughtnautChamberPieces {
    private static final ResourceLocation PART = new ResourceLocation("mowziesmobs", "wroughtnaut_chamber");

    public static void start(TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> pieces, Random rand) {
        BlockPos rotationOffset = new BlockPos(0, 0, -9).func_190942_a(rot);
        BlockPos blockPos = rotationOffset.func_177971_a((Vector3i)pos);
        pieces.add((StructurePiece)new Piece(manager, PART, blockPos, rot));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private Rotation rotation;
        private final BlockPos startPos;
        private BlockPos wallPos;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(FeatureHandler.WROUGHTNAUT_CHAMBER_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            this.field_186178_c = pos;
            this.rotation = rotationIn;
            this.startPos = pos;
            this.wallPos = null;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(FeatureHandler.WROUGHTNAUT_CHAMBER_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.startPos = new BlockPos(tagCompound.func_74762_e("StartX"), tagCompound.func_74762_e("StartY"), tagCompound.func_74762_e("StartZ"));
            if (tagCompound.func_74767_n("HasWall")) {
                this.wallPos = new BlockPos(tagCompound.func_74762_e("WallX"), tagCompound.func_74762_e("WallY"), tagCompound.func_74762_e("WallZ"));
            }
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74768_a("StartX", this.startPos.func_177958_n());
            tagCompound.func_74768_a("StartY", this.startPos.func_177956_o());
            tagCompound.func_74768_a("StartZ", this.startPos.func_177952_p());
            tagCompound.func_74757_a("HasWall", this.wallPos != null);
            if (this.wallPos != null) {
                tagCompound.func_74768_a("WallX", this.wallPos.func_177958_n());
                tagCompound.func_74768_a("WallY", this.wallPos.func_177956_o());
                tagCompound.func_74768_a("WallZ", this.wallPos.func_177952_p());
            }
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox mutableBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            Pair<BlockPos, Rotation> chamberResults;
            if (this.wallPos == null) {
                chamberResults = Piece.tryWroughtChamber((IWorld)worldIn, this.startPos.func_177958_n(), this.startPos.func_177956_o(), this.startPos.func_177952_p());
                this.field_186177_b.func_186222_a(false);
            } else {
                chamberResults = Pair.of((Object)this.wallPos, (Object)this.rotation);
                this.field_186177_b.func_186222_a(true);
            }
            if (chamberResults == null) {
                return false;
            }
            this.wallPos = (BlockPos)chamberResults.getLeft();
            this.rotation = (Rotation)chamberResults.getRight();
            this.field_186178_c = (BlockPos)chamberResults.getLeft();
            this.field_186177_b.func_186220_a((Rotation)chamberResults.getRight());
            this.field_186177_b.func_237133_d_(true);
            BlockPos rotationOffset = new BlockPos(0, 0, -9).func_190942_a(this.field_186177_b.func_186215_c());
            this.field_186178_c = this.field_186178_c.func_177971_a((Vector3i)rotationOffset);
            mutableBoundingBoxIn = this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c);
            return super.func_230383_a_(worldIn, p_230383_2_, p_230383_3_, p_230383_4_, mutableBoundingBoxIn, p_230383_6_, p_230383_7_);
        }

        @Nullable
        public static Pair<BlockPos, Rotation> tryWroughtChamber(IWorld world, int x, int surfaceY, int z) {
            int xzCheckDistance = 6;
            ChunkPos chunkPos = new ChunkPos(new BlockPos(x, surfaceY, z));
            int heightMax = ((Double)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.heightMax.get()).intValue();
            int heightMin = ((Double)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.heightMin.get()).intValue();
            if (heightMax == -1) {
                heightMax = surfaceY;
            }
            if (heightMin == -1) {
                heightMin = 0;
            }
            block0: for (int y = heightMax = Math.min(heightMax, world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z)); y >= heightMin; --y) {
                BlockPos airPos = Piece.checkForAirInXY(world, new BlockPos(x, y, z), xzCheckDistance);
                if (airPos == null) continue;
                x = airPos.func_177958_n();
                z = airPos.func_177952_p();
                for (int y2 = 1; y2 <= 30; ++y2) {
                    ChunkPos p2ChunkPos;
                    ChunkPos p2ChunkPos2;
                    BlockPos p2;
                    Boolean wall;
                    ChunkPos p1ChunkPos;
                    BlockPos p1;
                    BlockPos p0 = new BlockPos(x, y - y2, z);
                    ChunkPos p0ChunkPos = new ChunkPos(p0);
                    if (!chunkPos.equals((Object)p0ChunkPos) || !world.func_180495_p(p0).func_215686_e((IBlockReader)world, p0)) continue;
                    int y4 = 0;
                    int y5 = 0;
                    for (int x2 = 0; x2 <= xzCheckDistance; ++x2) {
                        BlockPos p22;
                        int y3;
                        p1 = new BlockPos(x - x2, y - y2 + y4 + 1, z);
                        p1ChunkPos = new ChunkPos(p1);
                        if (!chunkPos.equals((Object)p1ChunkPos)) continue;
                        if (world.func_180495_p(p1).func_215686_e((IBlockReader)world, p1)) {
                            wall = true;
                            for (y3 = 1; y3 <= 4; ++y3) {
                                p2 = new BlockPos(x - x2, y - y2 + y4 + 1 + y3, z);
                                p2ChunkPos2 = new ChunkPos(p2);
                                if (!chunkPos.equals((Object)p2ChunkPos2) || world.func_180495_p(p2).func_215686_e((IBlockReader)world, p2)) continue;
                                wall = false;
                                y4 += y3;
                                break;
                            }
                            if (wall.booleanValue()) {
                                BlockPos p23 = new BlockPos(x - x2, y - y2 + y4, z);
                                p2ChunkPos = new ChunkPos(p23);
                                if (!chunkPos.equals((Object)p2ChunkPos)) continue;
                                if (world.func_180495_p(p23).func_215686_e((IBlockReader)world, p23)) {
                                    return Pair.of((Object)new BlockPos(x - x2, y - y2 + y4, z), (Object)Rotation.CLOCKWISE_180);
                                }
                            }
                        }
                        if (!chunkPos.equals((Object)(p1ChunkPos = new ChunkPos(p1 = new BlockPos(x + x2, y - y2 + y5 + 1, z)))) || !world.func_180495_p(p1).func_215686_e((IBlockReader)world, p1)) continue;
                        wall = true;
                        for (y3 = 1; y3 <= 4; ++y3) {
                            p2 = new BlockPos(x + x2, y - y2 + y5 + 1 + y3, z);
                            p2ChunkPos2 = new ChunkPos(p2);
                            if (!chunkPos.equals((Object)p2ChunkPos2) || world.func_180495_p(p2).func_215686_e((IBlockReader)world, p2)) continue;
                            wall = false;
                            y5 += y3;
                            break;
                        }
                        if (!wall.booleanValue() || !chunkPos.equals((Object)(p2ChunkPos = new ChunkPos(p22 = new BlockPos(x + x2, y - y2 + y5, z)))) || !world.func_180495_p(p22).func_215686_e((IBlockReader)world, p22)) continue;
                        return Pair.of((Object)new BlockPos(x + x2, y - y2 + y5, z), (Object)Rotation.NONE);
                    }
                    y4 = 0;
                    y5 = 0;
                    for (int z2 = 0; z2 <= xzCheckDistance; ++z2) {
                        BlockPos p24;
                        p1 = new BlockPos(x, y - y2 + y4 + 1, z - z2);
                        p1ChunkPos = new ChunkPos(p1);
                        if (!chunkPos.equals((Object)p1ChunkPos)) continue;
                        if (world.func_180495_p(p1).func_200015_d((IBlockReader)world, p1)) {
                            wall = true;
                            for (int y3 = 1; y3 <= 4; ++y3) {
                                p2 = new BlockPos(x, y - y2 + y4 + 1 + y3, z - z2);
                                if (world.func_180495_p(p2).func_215686_e((IBlockReader)world, p2)) continue;
                                wall = false;
                                y4 += y3;
                                break;
                            }
                            if (wall.booleanValue()) {
                                BlockPos p25 = new BlockPos(x, y - y2 + y4, z - z2);
                                p2ChunkPos = new ChunkPos(p25);
                                if (!chunkPos.equals((Object)p2ChunkPos)) continue;
                                if (world.func_180495_p(p25).func_215686_e((IBlockReader)world, p25)) {
                                    return Pair.of((Object)new BlockPos(x, y - y2 + y4, z - z2), (Object)Rotation.COUNTERCLOCKWISE_90);
                                }
                            }
                        }
                        if (!chunkPos.equals((Object)(p1ChunkPos = new ChunkPos(p1 = new BlockPos(x, y - y2 + y5 + 1, z + z2)))) || !world.func_180495_p(p1).func_215686_e((IBlockReader)world, p1)) continue;
                        wall = true;
                        for (int y3 = 1; y3 <= 4; ++y3) {
                            p2 = new BlockPos(x, y - y2 + y5 + 1 + y3, z + z2);
                            p2ChunkPos2 = new ChunkPos(p2);
                            if (!chunkPos.equals((Object)p2ChunkPos2) || world.func_180495_p(p2).func_215686_e((IBlockReader)world, p2)) continue;
                            wall = false;
                            y5 += y3;
                            break;
                        }
                        if (!wall.booleanValue() || !chunkPos.equals((Object)(p2ChunkPos = new ChunkPos(p24 = new BlockPos(x, y - y2 + y5, z + z2)))) || !world.func_180495_p(p24).func_215686_e((IBlockReader)world, p24)) continue;
                        return Pair.of((Object)new BlockPos(x, y - y2 + y5, z + z2), (Object)Rotation.CLOCKWISE_90);
                    }
                    continue block0;
                }
            }
            return null;
        }

        @Nullable
        public static BlockPos checkForAirInXY(IWorld world, BlockPos start, int range) {
            for (int dx = -range; dx < range; ++dx) {
                for (int dz = -range; dz < range; ++dz) {
                    BlockPos check = start.func_177982_a(dx, 0, dz);
                    if (!world.func_217354_b(check.func_177958_n() >> 4, check.func_177952_p() >> 4) || !world.func_175623_d(check)) continue;
                    return check;
                }
            }
            return null;
        }
    }
}

